#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/****************************************************************************
dfree.c version 1 02/05/93
Duane Paulson ci922@cleveland.freenet.edu duane.paulson@pcb.batpad.lgb.ca.us

Displays free bytes for drive specified. Verbose mode displays cluster and
sector information.

dfree <drive> [/v]

<drive> must be specified. This is the drive designator in ASCII format.
	It need not be followed by a colon.
/v is the verbose switch. When found, cluster and sector information for the
	drive will also be displayed.
****************************************************************************/
main(int argc, char **argv)
{
	int verbose=0;
	unsigned char drive, asciidrive;
	unsigned sectors_per_cluster, available_clusters, bytes_per_sector,
			clusters_per_drive;
	unsigned long total_disk_space, free_space, used;
	float percent;

	switch(argc)
	{
		case 2:
			asciidrive=argv[1][0];
			/* convert drive to 1-based binary designator (i.e., a=1) */
			drive=(unsigned char)tolower((argv[1][0]))
				-(unsigned char)'a'+(unsigned char)1;
			break;
		case 3:
			if(!strcmp(argv[1], "/v")||!strcmp(argv[1], "/V"))
			{
				verbose++;
				asciidrive=argv[2][0];
				drive=(unsigned char)tolower((argv[2][0]))
					-(unsigned char)'a'+(unsigned char)1;
				break;
			}
			else if(!strcmp(argv[2], "/v")||!strcmp(argv[2], "/V"))
			{
				verbose++;
				asciidrive=argv[1][0];
				drive=(unsigned char)tolower((argv[1][0]))
					-(unsigned char)'a'+(unsigned char)1;
				break;
			}
		default:
			printf("dfree <drive> [/V]\n");
			exit(1);
	}

	_asm
	{
		mov  ah,36h
		mov  dl,drive
		int  21h
		mov  sectors_per_cluster,ax
		mov  available_clusters,bx
		mov  bytes_per_sector,cx
		mov  clusters_per_drive,dx
	}

	if(sectors_per_cluster==0xffff) /* If drive designator invalid */
	{
		printf("Drive %c does not exist\n", asciidrive);
		exit(2);
	}

	free_space=total_disk_space=(unsigned long)bytes_per_sector *
		(unsigned long)sectors_per_cluster;
	total_disk_space*=(unsigned long)clusters_per_drive;
	free_space*=(unsigned long)available_clusters;
	used=total_disk_space-free_space;
	percent=(float)used/(float)total_disk_space;
	percent*=100.0;

	printf("Drive %c has %lu bytes free out of a total of %lu (%.0f%% full)\n",
		asciidrive, free_space, total_disk_space, percent);

	if(verbose)
	{
		printf("\n          About drive %c...\n", asciidrive);
		printf("       Bytes per sector: %u\n", bytes_per_sector);
		printf("    Sectors per cluster: %u\n", sectors_per_cluster);
		printf("     Available clusters: %u\n", available_clusters);
		printf("Total clusters on drive: %u\n", clusters_per_drive);
	}
	exit(0);
}
