/*****************************************************************
    FCHECK.C
        Program to test the size of a specified file against a
        specified value, setting ERRORLEVEL to one of the
        following values:
            0 -- File is SMALLER than size given
            1 -- File is EQUAL to size given
            2 -- File is LARGER than size given
            3 -- An error occurred in the program (the
                 file didn't exist, or the parameters were
                 incorrect.)

    History:
        Written 3/20/92 by Michael V. Lease.  Released to
        public domain.

    Usage:
        FCHECK <file name> <value>

        Intended for use in an MS-DOS batch file.  Since MS-DOS
        batch files evaluate "IF ERRORLEVEL <value>" as true if
        ERRORLEVEL is greater than or equal to <value>, it is
        necessary to test the possible returns in DESCENDING
        order; i.e., test for ERRORLEVEL 3 first, then ERRORLEVEL
        2, etc.

*****************************************************************/

#include <stdio.h>
#include <stat.h>       /* Turbo C gives this as "sys\stat.h", but I didn't */
                        /* like that, and moved the files in \TC\INC\SYS    */
                        /* to \TC\INC.  Personal preference...              */

/* Possible return values */
#define ERROR       3
#define LARGER      2
#define EQUAL       1
#define SMALLER     0


main(int argc, char *argv[])
{
    int             retval;
    long            check_size;
    struct stat     statbuf;

    if (argc != 3)
        {
        printf("FCHECK was written by Michael V. Lease and released to");
        printf(" public domain.\r\n\r\n");
        printf("Usage:  FCHECK <File Name> <Value>\r\n");
        printf("See FCHECK.DOC if you need more help.\r\n\r\n");
        exit(ERROR);
        }   /* if */

    check_size = atol(argv[2]);

    if (check_size <= 0L)
        {
        printf("Invalid value for size!  (Must be numeric and greater ");
        printf("than 0.)\r\n\r\n");
        exit(ERROR);
        }   /* if */

    retval = stat(argv[1], &statbuf);

    if (retval != 0)
        {
        printf("Error getting file size");
        printf(" (check to see if the file exists)!\r\n\r\n");
        exit(ERROR);
        }   /* if */

    if (statbuf.st_size == check_size)
        {   /* It's the same size... */
        exit(EQUAL);
        }   /* if */
    else if (statbuf.st_size > check_size)
        {   /* It's bigger... */
        exit(LARGER);
        }   /* else if */
    else
        {   /* Gotta be smaller... */
        exit(SMALLER);
        }   /* else */

    /* Shouldn't ever get here, unless the stack got screwed up somehow,    */
    /* but for safety's sake, I put in an error exit...                     */
    printf("An unknown error occurred!\r\n\r\n");
    exit(ERROR);
}   /* main() */

