Program SetAttr;
{ SetAttr v2.0 Copyright (C) 1992 CollisionWare(tm) Premium SoftWare }
{ Any modified versions of this code should be released with the additions }
{ documented. Commercial use is strictly prohibted (if even possible :-]). }
{ Written by Kito D. Mann }

Uses Dos;

Type str66 = string[66];

Procedure Show(FileName,Param : str66);
BEGIN
    Writeln('Setting file attribute of ',FileName,' to ',Param);
END;

Procedure ConvertFiles(FileName : Str66; Param : char);
VAR s : string[80];
    filepath : string[66];
    f : file;
    SRec: SearchRec;

BEGIN
  FindFirst(FileName,0,Srec);
  WHILE DosError=0 DO
    BEGIN
     Assign(f,SRec.Name);
     Case UpCase(Param) of
      'A': BEGIN show(SRec.Name,'Archive file...'); SetFAttr(f,Archive); END;
      'R': BEGIN show(SRec.Name,'Read only...'); SetFAttr(f,ReadOnly); END;
      'H': BEGIN show(SRec.Name,'Hidden...'); SetFAttr(f,Hidden); END;
      'S': BEGIN show(SRec.Name,'System file...'); SetFAttr(f,SysFile); END;
     END;
     FindNext(Srec);
    END;
END;

Procedure Main;
VAR Param    : string[2];

BEGIN
   Writeln('SetAttr v2.0 [3/28/92]: Sets file attribute of specified file.');
   Writeln('(C)1992 CollisionWare(tm) Premium SoftWare, written by Kito D. Mann');
   Writeln('Collision Theory(tm) * 24 Hours * (703)503-9441');
   Writeln;
   IF ParamCount < 2 then BEGIN
     Writeln('Usage: SetAttr [G][R][H][S] FILENAME.TYP');
     Writeln;
     Writeln('Wildcards are excepeted.');
     Writeln;
     Writeln('Examples: SetAttr R MYFILE.TYP');
     Writeln('          SetAttr A *.*');
     Writeln('          SetAttr H SECRET.*');
     Writeln;
     Writeln('Where: [A]=Archive (normal file), [R]=Read Only, [H]=Hidden, [S]=System file');
     halt;
   END;
   Param := ParamStr(1);
   IF NOT (Upcase(Param[1]) IN ['A','R','H','S']) THEN
     BEGIN
      Writeln('Incorrect parameters; type SetAttr alone for help.');
      Halt;
     END;
   ConvertFiles(ParamStr(2),Param[1]);
   Writeln;
   Writeln('Thanks for using SetAttr.');
END;

BEGIN
  Main;
END.
