#include <stdio.h>
#include <string.h>
#include <dos.h>

#include "dosstruc.h"

/*
 *	GETDPB is a routine to use the undocumented PC/MS-DOS Int 21H, Func 32H
 *		   to obtain disk information.  This function has been verified to
 *		   perform correctly in all versions of PC/MS-DOS from 2.0 through
 *		   3.3.  Since it is heavily used by DOS programs such as CHKDSK,
 *		   it will prbably continue to work correctly.  This routine is used
 *		   to avoid problems with non-standard boot sectors.
 */

 void
GetDPB (int Disk, struct DpbStruct *Dpb) {
	union REGS Regs;
	struct SREGS SRegs;

	segread(&SRegs);
	Regs.h.ah = 0x32;
	if (Disk) Disk -= '@';
	Regs.h.dl = Disk;
	intdosx(&Regs, &Regs, &SRegs);
	movedata(SRegs.ds, Regs.x.bx, FP_SEG(Dpb), FP_OFF(Dpb), 28);
	}
