//      BRECORD     . . .    List device parameter block information

#include	<dos.h>
#include    <string.h>
#include    <stdlib.h>
#include    <stdio.h>
#include    <iostream.h>                 
#include    <iomanip.h>
#include    <ctype.h>

typedef    unsigned char   byte;
typedef    unsigned int    WORD;
typedef    unsigned long   dword;

const char NUL = '\0';

class dpb {
  public:
    byte    driveno;            // Drive number (0 == default)
    byte    unit;               // Unit number within driver
    WORD    bpers;              // Bytes per sector
    byte    hisect;             // Highest sector number in cluster
    byte    shift;              // To convert clusters into sectors
    WORD    reserved;           // Reserved sectors
	byte    nfats;              // Number of FATs
    WORD    ndir;               // Number of root directory entries
    WORD    data;               // Number of first sector with user data
    WORD    ndata;              // Highest cluster number + 1
                                //   16 bit FAT if > 0ff6
    WORD    sperf;              // Sectors per FAT
    WORD    sdir;               // Number of first directory sector
    dpb     far *dhdr;          // Address of device driver header
    byte    media;              // Media ID byte
    byte    clean;              // 0 if disk accessedm else FF
    dpb     far *next;          // Pointer to next DPB
    WORD    search;             // Search start cluster, usually the last
								//  allocated
    WORD    nfree;              // Number of free clusters on drive or FFFFh

    WORD    infolevel;
    WORD    Slo;                // Serial # (low order word)
    WORD    Shi;                //          (high order word)
    char    label[11];          // Volume label
    char    ftype[8];           // File system type

    unsigned *FAT;              // Points to FAT buffer
    char    is16bit;            // Set if 16 bit FAT

	dpb(char);  	            // Constructor
    void    list();             // List dpb to cout
    void    erase();
    unsigned sector(unsigned);
    unsigned getentry(unsigned);
    void     zapentry(unsigned);
};

dpb::dpb(char drv)
{
    void far *result;           // Points to DOS copy of the dpb
asm {
    push ds
    mov dl,drv
    and dl,15
	mov ah,0x32
    int 0x21
	xor al,al
    je  okay
    xor bx,bx
	mov ds,bx
    }
okay:
asm {
	mov dx,ds
    pop ds
    }
	result = MK_FP(_DX, _BX);
    _fmemcpy((void *)this, result, 33);
    _DX = (unsigned)&infolevel;
asm {
    mov bl,drv
    and bl,15
    mov ax,0x6900
    int 0x21
    }
    is16bit = ftype[4] == '6';
    ftype[5] = NUL;
}

void dpb::list()
{
    char save = *ftype; *ftype = NUL;       // Temporary hack
    cout.setf(ios::left);
    cout << "\n\tDrive Parameter Block\n" <<
        "\n\tDrive " << (char)('A' + driveno) <<
        "\n\tBytes per sector                  " << bpers <<
        "\n\tSectors per cluster               " << (hisect + 1) <<
		"\n\tClusters to sectors shift         " << (int)shift <<
        "\n\tReserved sectors                  " << reserved <<
		"\n\tNumber of FATs                    " << (int)nfats <<
        "\n\tNumber of root directory entries  " << ndir <<
        "\n\tFirst user data sector            " << data <<
        "\n\tNumber of data clusters           " << (ndata - 1);
    if (nfree != 65535) {
cout << "\n\tNumber of free clusters           " << nfree ;}
cout << "\n\tSearch start cluster              " << search <<
        "\n\tSectors per FAT                   " << sperf <<
        "\n\tFirst directory sector            " << sdir <<
		"\n\tMedia ID byte                     " << hex << (int)media <<
        "\n\tSerial number                     " << Shi << ':' << Slo <<
        "\n\tVolume label                      " << setw(11) << label;
    *ftype = save; cout <<
        "\n\tFile system type                  " << setw(8) << ftype <<
        "\n\n";
}

void main(int, char *argv[])
{
    dpb *disk = new dpb(*argv[1]);
    disk->list();
}

