; This boot was was developed from bootany.
; The main idea was to simplify the installation
; procedure and to remove unnecessary partition type
; switching.
; Author: Serge Vakulenko, <vak@kiae.su>

F1_scancode     equ     59
Enter_scancode	equ	28
noDefault	equ	'?'		; 'no default' character
reply_interval  equ     5               ; wait up to 5 seconds for reply

BootLocation    equ     7C00h           ; Address where DOS loads us
BootSeg         equ     07C0h           ; Segment where DOS loads us
NewBootLocation equ     7A00h           ; Address where we relocate
NewBootSeg      equ     07A0h           ; Segment where we relocate
PartAddr        equ     1beh            ; offset to partition table
KeyboardFlags   equ     417h            ; Address of keyboard mask

PartitionEntry  struc
BootIndicator   db      ?
BeginHead       db      ?
BeginSector     db      ?
BeginCyl        db      ?
SystemID        db      ?
EndHead         db      ?
EndSector       db      ?
EndCyl          db      ?
RelSectorLow    dw      ?
RelSectorHigh   dw      ?
NumSectorsLow   dw      ?
NumSectorsHigh  dw      ?
PartitionEntry  ends

; -------------------------------

code            segment

		assume  cs:Code, ds:Code, es:Code, ss:Code
		org     0

Boot:
;
;               Setup the stack
;
		mov	AX,CS		; Get current segment
		mov	DS,AX		; Set DS temporarily
		cli                     ; disable interrupts
		mov     SS,AX           ; set stack segment
		mov     SP,NewBootLocation ; initialize stack pointer
		sti                     ; reenable interrupts
;
;               DOS loads this pgm at 0000:7C00. Any boot routine
;               we call also expects to execute there so the first
;               exercise is to move this code somewhere else.
;
		mov     CX,512          ; bytes to move
		mov     SI,BootLocation ; Get boot address
		les     DI,DWORD PTR SecBoot[SI] ; Load ES=07A0,DI=0000
		rep     movsb           ; Copy to new location

		lea     SI,Entry+NewBootLocation ; address relocated e.p.
		jmp	SI

; -------------------------------
;
;               A valid function key was depressed (or defaulted)
;               Attempt to boot the corresponding partition.
;
Load:
		mov     key,AL          ; save function key number
		mov	AH,16
		mul	AH		; AX = AL * 16
		lea	DI,partab-'1'*16 ; subtract '1'
		add	DI,AX
;
;               Only boot bootable partitions.
;
		lea	SI,newLine
		call    Output		; new line
		mov     AL,SystemId[DI]
		cmp	AL,0		; unused partition?
		je      Menu            ; Yes - display menu again
		cmp     AL,5		; extended DOS?
		je      Menu            ; Yes - display menu again

		mov	DL,80h		; drive 0
		mov     BootIndicator[DI],DL ; Mark partition as bootable
;
;               Read in and validate the partition's boot sector.
;
		mov     DH,BeginHead[DI] ; head from partition table
		mov     CX,WORD PTR BeginSector[DI]
		les     BX,DWORD PTR PrimBoot ; address primary boot loc
		mov     AX,201h         ; function, # of sectors
		int     13h             ; read system boot record
		jc      Menu            ; exit if error
		cmp     word ptr ES:510,0aa55h ; test signature
		jne     Menu            ; reprompt if invalid
;
;		Mark selected partition as default and active.
;
		mov     AL,key          ; get depressed key number
		mov     default,AL      ; save Function key number
;
;               Update the boot sector with new values,
;		and give control to the partitions boot program
;
		mov     AX,301h         ; write sector
		les     BX,DWORD PTR SecBoot ; buffer address
		mov     CX,1            ; cylinder 0, sector 1
		mov     DX,0080h	; drive 0, head 0
		int     13h             ; replace boot record
		cli                     ; disable interrupts
		mov     SI,BootLocation ; get address of area read
		jmp     SI              ; enter second level boot

; -------------------------------
;
;		The main entry to the boot
;
Entry:
		push	ES		; Get current segment
		pop	DS		; Set data segment
		and	BYTE PTR DS:[KeyboardFlags],11011111b ; turn off Numlock
;
;               Display the menu
;
Menu:
		lea     DI,partab	; set index
		mov     CX,4		; set loop count
		mov	key,'0'
		xor	DH,DH		; count of partitions
menuloop:
		mov     BootIndicator[DI],0 ; Clear active flag
		inc	key
		mov	AL,SystemId[DI]
		cmp	AL,0		; unused partition?
		je	next
		cmp	AL,5		; extended DOS partition?
		je	next
		inc	DH		; increment partition count

		lea     SI,FkeyMsg      ; get msg addr
		call    Output

		lea	SI,nameTable-2
nameloop:
		add	SI,2
		mov	BX,[SI]
		cmp	BH,0
		je	endnameloop
		cmp	BH,SystemId[DI]
		jne	nameloop
		xor	BH,BH
endnameloop:
		lea	SI,namtab[BX]
		call	Output
next:
		add	DI,16		; next entry address
		loop	menuloop

		cmp	DH,0
		jne	prompt		; several partitions, wait for reply
		int	18h		; no partitions, load ROM basic
		jmp	Menu
prompt:
		lea     SI,defaultMsg	; print 'Default' message
		call    Output
reprompt:
		mov     AH,1            ; SetTickCount
		xor     CX,CX           ; hi-order tick count
		xor     DX,DX           ; lo-order tick count
		int     1ah             ; BiosTimerService
;
;               Get the reply
;
waitkey:
		mov     AH,1            ; keyboard status
		int     16h             ; keybd bios service
		jnz     reply		; jump if reply
		xor     AH,AH           ; GetTickCount
		int     1ah             ; BiosTimerService
		cmp     DX,192*reply_interval/10 ; check for timeout
		jb      waitkey		; wait for scancode
loaddefault:
		mov     AL,default      ; prior system id
		jmp     testkey		; boot default system
reply:
		xor     AH,AH           ; read keyboard
		int     16h             ; keybd bios service
		mov     AL,AH           ; Copy to AL
		cmp	AL,Enter_scancode
		je	loaddefault
		add     AL,'1'-F1_scancode ; Turn into index
testkey:
		cmp     AL,'1'		; max Function key
		jb	reprompt	; Invalid code check
		cmp     AL,'4'		; max Function key
		jnbe    reprompt	; if not F1..F4, branch
		jmp     Load		; boot selected system

; -------------------------------

Output:
		cld                     ; reset direction flag
		lodsb                   ; load argument from string
		test    AL,80h          ; test for end of string
		pushf                   ; save flags
		and     AL,7fh          ; insure valid character
		mov     AH,14           ; write tty
		int     10h             ; bios video service
		popf                    ; restore flags
		jz      Output          ; do until end of string
		ret                     ; return to caller

; -------------------------------

SecBoot         dw      0,NewBootSeg    ; ES=7A0, BX=0
PrimBoot        dw      0,BootSeg       ; ES=7C0, BX=0
newLine		db	13,10+80h
FkeyMsg         db      13,10,'F'
key             db      '0 . . .',' '+80h
defaultMsg	db	13,10,10,'Default: F'
default         db      noDefault,' '+80h

nameTable	db      type01-namtab, 1
		db      type02-namtab, 2
		db      type03-namtab, 3
		db      type01-namtab, 4
		db      type01-namtab, 6
		db      type07-namtab, 7
		db	type08-namtab, 8
		db      type09-namtab, 9
		db      type0A-namtab, 0Ah
		db      type63-namtab, 63h
		db      type64-namtab, 64h
		db      type64-namtab, 65h
		db      type81-namtab, 80h
		db      type81-namtab, 81h
		db      type82-namtab, 82h
		db      type93-namtab, 93h
		db      typeA5-namtab, 0A5h
		db      typeB7-namtab, 0B7h
		db      type75-namtab, 75h
		db      typedb-namtab, 0dbh
		db      type40-namtab, 40h
		db      type52-namtab, 52h
		db      typeF2-namtab, 0F2h
		db      unknownPart-namtab, 0

namtab:
type01          db      'do','s'+80h
type03		db	'usr '
type02          db      'xeni','x'+80h
type07		db      'hpf','s'+80h
type08		db	'fs '
type09		db      'ai','x'+80h
type0A          db      'os','2'+80h
type63          db      'uni','x'+80h
type64          db      'novel','l'+80h
type81          db      'mini','x'+80h
type82          db      'linu','x'+80h
type93		db      'amoeb','a'+80h
typeA5          db      '386bs','d'+80h
typeB7          db      'bsd','i'+80h
type75		db      'pci','x'+80h
typedb		db      'cp','m'+80h
type40		db      'veni','x'+80h
type52		db      'cp','m'+80h
typeF2		db      'dosse','c'+80h
unknownPart	db	'?','?'+80h

used            equ     $ - Boot   
clearAmt        equ     PartAddr - used ; Assembly error if code too big

		db      clearAmt dup(0) ; clear rest of record

partab		PartitionEntry 4 dup(<>)

		dw	0aa55h		; magic

code            ends

		end
