/*
**	HEADER		dosstruc.h
**	PURPOSE:	Contains the structures defining DOS's PSP,
**			LIST-of-LISTs, File Tables, and memory control
**			blocks.
*/

#define DISKETTE   0X0001
#define COPR_PRES  0X0002
#define MOUSE_IN   0X0004
#define RAM_BANK   0X000C
#define VIDEO_INIT 0X0030
#define NUM_DISKS  0X00C0
#define DMA_IN     0X0100
#define RS232      0XE000
#define GAME_IO    0X1000
#define SERIAL_IO  0X2000
#define NUM_PRINT  0XC000


typedef struct dos_psp {
	int	 Int20;			/* Archaic INT20 instruction */
	unsigned top_of_mem;		/* Address of segment past program */
	char	 reserved1;
	char	 dispatch[5];		/* Long jump to DOS dispatcher */
	void far *pta;			/* Program terminate address */
	void far *cba;			/* Control Break exit address */
	void far *cea;			/* Critical Error exit address */
	unsigned ppspseg;		/* Parent's PSP or this PSP */
	unsigned char fht[20];		/* PSP file handle table */
	unsigned envseg;		/* Segment address of the Environment */
	void far *sswitch;		/* Stack switch storage */
	unsigned fh_count;		/* Max file handle entries */
	unsigned char far *fha;		/* Address of file handle array */
	char	reserved2[24];
	char	fdispatch[3];		/* Function dispatch interrupt */ 
	char	reserved3[2];
	unsigned char fcbe[7];		/* File Control Block Extension */
	unsigned char fcb1[16];		/* File Control Block #1 */
	unsigned char fcb2[16];		/* File Control Block #2 */
	char	reserved4[4];
	unsigned char comm_len;		/* Command Line Length */
	char	comm_line[127];		/* Command line following prog name */

}	PSP;

typedef struct f_tbl_hdr {
	struct f_tbl_hdr far 	*next;	/* Next file table or ??? if last */
	unsigned	 files_in_tbl;
}	FTHDR;

#ifdef DOS3
typedef struct f_tbl_entry {
	unsigned	references;	/* Number of handles referring to */
        unsigned        mode;           /* Access mode */
        unsigned char   gotme1;         /* Don't know */
	unsigned	dev_info;	/* Device info word */
	void far	*dev_cntl;	/* See INT 21 FUNC 52h */
	unsigned	clust1;		/* Starting cluster of file */
	unsigned	ftime;		/* Packed format file time */
	unsigned	fdate;		/* Packed format file date */
	unsigned long	fsize;		/* File size */
	unsigned long	offset;		/* Current offset */
	unsigned	gotme2;		/* Don't know */
	unsigned	last_clust;	/* Last cluster read */
	unsigned	dir_sect;	/* Sector containing directory */
	unsigned char	dir_offset;	/* Dir offset within sector */
	char		fname[11];	/* Filename (no path, no '.', padded */
	unsigned char	gotme3[6];		/* Don't know */
	unsigned	owner;		/* Owners PID (psp segment) */
	unsigned 	gotme4;		/* Don't know */
}	FTENTRY;
#else
typedef struct f_tbl_entry {
	unsigned	references;	/* Number of handles referring to */
        unsigned        mode;           /* Access mode */
        unsigned char   gotme1;         /* Don't know */
	unsigned	dev_info;	/* Device info word */
	void far	*dev_cntl;	/* See INT 21 FUNC 52h */
	unsigned	clust1;		/* Starting cluster of file */
	unsigned	ftime;		/* Packed format file time */
	unsigned	fdate;		/* Packed format file date */
	unsigned long	fsize;		/* File size */
	unsigned long	offset;		/* Current offset */
        unsigned        rel_cluster;    /* Relative cluster of last cluster read */
        unsigned long   dir_sect;       /* Sector containing directory */
	unsigned char	dir_offset;	/* Dir offset within sector */
        char            fname[11];      /* Filename (no path, no '.', padded */
        void far        *SFT_Previous;  /* Pointer to previous SFT */
        unsigned        net_mach_num;   /* Network machine number */
	unsigned	owner;		/* Owners PID (psp segment) */
        char            Unknown_bytes[8];/* Unknown bytes */
}       FTENTRY;
#endif

typedef struct dev_dvr_hdr {
	struct dev_dvr_hdr far	*next;	/* Next driver or 0xFFFF if last */
	unsigned	attributes;	/* Device attributes */
	unsigned	ddstrat;	/* Device strategy entry point */
	unsigned	ddinter;	/* Device interrupt entry point */
	char		*name[8];	/* Blank padded character dev name */
}	DEVDVRHDR;

typedef struct dos_lofl {
        /* THIS IS FOR DOS 3.X and above */

	/* Bytes -2 and -1 from here are the segment of the first
	** memory control block.
	*/

	/* Structures not defined for all the void pointers */
	void far 	*devcb;		/* Pointer to 1st Device Ctrl Block */
	FTHDR far	*filetbl;	/* Pointer to 1st File Table Header */
	void far	*clockdd;	/* Pointer to CLOCK$ device driver */
	void far	*condd;		/* Pointer to CON: device driver */
	unsigned	maxbytes;	/* MAX bytes/block of any block dev */
	void far	*disk_buff;	/* Pointer to 1st Disk Buffer */
	void far	*driveinfo;	/* Pointer to an array of drive info */
	void far	*fcbtable;	/* Pointer to FCB table (if FCBS= */
        unsigned        fcb_size;       /* Size of FCB table(# prot FCBS) */
	unsigned char	num_bl_dev;	/* Number of block devices */
	unsigned char  	lastdrive;	/* Value of LASTDRIVE in config.sys */
	DEVDVRHDR	nul_dd;		/* The first device (Nul) on the list */
        unsigned char   gotme;          /* Number of joined drives */

        /* This is for DOS 4.X and above */
        unsigned        *spec_names;    /* Pointer in IBMDOS to special prog names */
        void far        *unknown;       /* Pointer to ??? */
        void far        *IFS_chain;     /* Pointer to chain IFS(installable file system) drivers */
        unsigned        Buffer_X;       /* The x in BUFFERS x,y */
        unsigned        Buffer_Y;       /* The y in BUFFERS x,y */
        unsigned char   boot_drive;     /* The boot drive (1=A:) */
        unsigned char   unknown_zero;   /* Allways seems to be zero */
        unsigned char   unknown_flags;  /* flags??? (bit 7: MCA???) */
        unsigned char   unknown_byte;   /* ???? */
} 	LIST_OF_LISTS;

#define CHAINED  0x4D
#define CHAINEND 0x5A

typedef struct mem_block {
	unsigned char	type;		/* Either 0x4D or 0x5A for last */
	unsigned	pid;		/* PID; the segment of the PSP */
	unsigned	psize;		/* Size in 16 byte paragraphs */
	unsigned char	undef[11];	/* Undefined bytes */
}       MEM_BLOCK;


/*
*  To use this structure assign a variable of type pointer to BIOS_DATA
*  and then assign that to hex address 0x0040:0x0000
*
*  Example:
*           BIOS_DATA    *b_data
*
*
*           b_data  =  MK_FP(0x0040, 0x0000)
*
*
*/

typedef struct bios_area {
        unsigned        Com_Port_1;     /* Comm port 1 address */
        unsigned        Com_Port_2;     /* Comm port 2 address */
        unsigned        Com_Port_3;     /* Comm port 3 address */
        unsigned        Com_Port_4;     /* Comm port 4 address */
        unsigned        LPT_1;          /* Lpt 1 address */
        unsigned        LPT_2;          /* Lpt 2 address */
        unsigned        LPT_3;          /* Lpt 3 address */
        unsigned        LPT_4;          /* Lpt 4 address */
        unsigned        Equip_Flag;     /* Equipment flag (see INT 11) */
        unsigned char   byte1;          /* Unknown byte */
        unsigned long   Mem_Size;       /* Memory size in Kbytes */
        unsigned char   Key_Flag_0;     /* Keyboard flag byte 0 (see INT 9) */
        unsigned char   Key_Flag_1;     /* Keyboard flag byte 1 (see INT 9) */
        unsigned char   Alt_Key_Entry;  /* Alternate keypad entry storage */
        unsigned        Key_Buf_Head;   /* Pointer to keyboard buf head */
        unsigned        Key_Buf_Tail;   /* Pointer to keyboard buf tail */
        unsigned char   Key_Buffer[32]; /* KeyBoard Buffer */
        unsigned char   Drv_Rec_Status; /* Drive recalibration status */
        unsigned char   Motor_Status;   /* Motor status */
        unsigned char   Motor_Off_Cntr; /* Motor off counter (-- by timer) */
        unsigned char   Disk_Op_Last;   /* Status of last diskette operation */
        unsigned char   NEC_Status[7];  /* NEC Status */
        unsigned char   CRT_Mode_Curr;  /* Current CRT Mode */
        unsigned        Screen_Col;     /* Number of columns on screen */
        unsigned        Reg_Buf_Len;    /* Regen buffer length in bytes */
        unsigned        Reg_Buf_Off;    /* Regen buffer starting offset */
        unsigned        Cur_Pos[8];     /* Cursor position pages 1-8 */
        unsigned char   End_Line_Cur;   /* End line for cursor */
        unsigned char   Strt_Line_Cur;  /* Start line for cursor */
        unsigned char   Page_Curr;      /* Current page being displayed */
        unsigned        Base_Addr_Dis;  /* Base port address for display */
        unsigned char   Cur_Set_38;     /* Current setting for 3x8 register */
        unsigned char   Cur_Palette;    /* Current palette setting */
        void far        *Temp_SSSP;     /* Temp. storage SS:SP dur. shutdown */
        unsigned char   byte2;          /* unknown byte */
        unsigned long   Timer_Counter;  /* Timer Counter low word, high word */
        unsigned char   Day_Time_Ovfl;  /* 24 hour timer overflow */
        unsigned char   Break_Flag;     /* Bios Brk Flag(bit 7 = Brk key hit) */
        unsigned        Reset_Flag;     /* Reset flag (1234 = soft reset) */
        unsigned char   Last_Hard_Op;   /* Status of last hrd drv operation */
        unsigned char   Hrd_Files_Att;  /* Number of hard files attached */
        unsigned char   byte3;          /* unknown byte */
        unsigned char   Offset_HFAdap;  /* Offset of curr HF Adapter */
        unsigned char   LPT_Timeout[4]; /* Timeout value for LPT 1-4 */
        unsigned char   COM_Timeout[4]; /* Timeout value for COMM 1-4 */
        unsigned        Key_Buf_Strt;   /* Keyboard buffer start offset(seg=40) */
        unsigned        Key_Buf_End;    /* Keyboard buffer end offset(seg=40) */
        unsigned char   Rows_on_Scrn;   /* Rows on the screen (EGA only) */
        unsigned        Bytes_Per_Char; /* Bytes per character (EGA only) */
        unsigned char   Mode_Options;   /* Mode options (EGA only) */
        unsigned char   Feat_Bit_Swit;  /* Feature bit switches (EGA only) */
        unsigned        word2;          /* unknown word */
        unsigned char   Disk_Data_Rate; /* Last diskette data rate selected */
        unsigned char   HFS_Controller; /* Hard file status from controller */
        unsigned char   HFE_Controller; /* Hard file error from controller */
        unsigned char   HF_INT;         /* Hard file interrupt (bit 7=working int) */
        unsigned char   byte4;          /* unknown byte */
        unsigned char   Med_Sta_Drv[4]; /* Media state drive 0,1,2,3 */
        unsigned char   Cur_Track[2];   /* Current Track Seeked to Drv 0,1 */
        unsigned char   Key_Flag_3;     /* Keyboard flag byte 3 (see INT 9) */
        unsigned char   Key_Flag_2;     /* Keyboard flag byte 2 (see INT 9) */
        void far        *User_Wait_Flg; /* Users wait flag */
        unsigned long   User_Timeout;   /* Users timeout value in microsec. */
        unsigned char   RTC_Wait;       /* RTC wait function in use */
        unsigned char   LANA_DMA_Ch;    /* Lana DMA channel flags */
        unsigned char   LANA_Status[2]; /* Status Lana 0,1 */
        void far        *HF_INT_VECT;   /* Saved hard file int vector */
        void far        *EGA_Param_Tbl; /* Pointer to EGA Param table */
        unsigned char   Key_NMI_Flags;  /* Keyboard NMI control flags(convert) */
        unsigned long   Key_Brk_Pend;   /* Keyboard brk pending flags(convert) */
        unsigned char   Port_60_Que;    /* Port 60 single byte queue(convert) */
        unsigned char   Last_Key;       /* Scan code of last key(convert) */
        unsigned char   NMI_Buf_Head;   /* Pointer to NMI buf head(convert) */
        unsigned char   NMI_Buf_Tail;   /* Pointer to NMI buf tail(convert) */
        unsigned char   NMI_Scan_Buf[22]; /* Pointer to NMI scan code buf(convert) */
        unsigned        Day_Counter;    /* Day counter (convert and after) */
        unsigned char   Ptr_Scr;        /* Print screen byte */
}       BIOS_DATA;

/*
**   End of DOS Data Structures
*/

