
#include <bios.h>
#include <dos.h>

#ifdef  __TURBOC__
  #define  bioskey    bioskey(0)
#else
  #define  bioskey    _bios_keybrd(0)
#endif

union  REGS   key_regs;

int    getkey(void)
/* Use the BIOS function to read the next keyboard character */
{

 int key, lo, hi;

#ifdef XT
 key = bioskey;
#else
 key_regs.h.ah = 0x10;
 int86(0x16, &key_regs, &key_regs);
 key = key_regs.x.ax;
#endif

 lo = key & 0X00FF;
 hi = (key & 0XFF00) >> 8;
 return((lo == 0) ? hi + 256 : lo);
} /* getkey */
