/*****************************************************************************
*
*   Program        : setf.c
*   Author         : Bob Willoughby
*   Description    : Allows setting of all 48 DOS function keys
*   Caveats        : Keys F1,F3 and F9 are used by DOS and 4Dos
*                    Changing these keys can cause serious repercusions
*   Class          : CPSC 294 - S50
*
*****************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <keydefs.h>

#ifdef TRC
  #include  <trace.h>
#endif

#define TRUE         -1

typedef struct ConfigKeys {
        int      funckey;
        char     funcstring[70];
} CONFIGKEYS;

            /*  Define some variables */

static char          Change;
static int           KeyHit, Count, Ansi_OK, V_Mode, Fkey;
static char          *Response;
static char          Resp;
static char          Command;
static char          ch;
static FILE          *fp;
static char          File_Name[50];
static char          SCCSID[]  =
                     "@(#)setf.c  Rev. 3.0  010191\n";

static char          *op_arg_list = "CcIiDdRrLlF:f:Hh?";

union  REGS          regs;

CONFIGKEYS   FkeyConfig[48] = {
    {59,NULL}, {60,NULL}, {61,NULL}, {62,NULL}, {63,NULL}, {64,NULL},
    {65,NULL}, {66,NULL}, {67,NULL}, {68,NULL},
    {84,NULL}, {85,NULL}, {86,NULL}, {87,NULL}, {88,NULL}, {89,NULL},
    {90,NULL}, {91,NULL}, {92,NULL}, {93,NULL},
    {94,NULL}, {95,NULL}, {96,NULL}, {97,NULL}, {98,NULL}, {99,NULL},
    {100,NULL}, {101,NULL}, {102,NULL}, {103,NULL},
    {104,NULL}, {105,NULL}, {106,NULL}, {107,NULL}, {108,NULL}, {109,NULL},
    {110,NULL}, {111,NULL}, {112,NULL}, {113,NULL},
    {133,NULL}, {134,NULL}, {135,NULL}, {136,NULL},
    {137,NULL}, {138,NULL}, {139,NULL}, {140,NULL}
};

extern int  getopt(int ac, char *av[], char *opt, int printerr);
extern int  getkey(void);       /*  define external module */
extern char *get_string(int count);
extern int  optind;
extern char *optarg;

              /*  Define Prototypes for functions  */

void         PrintHelp(void);
void         Print_Small_Help(void);
void         ProcessParams(char);
void         SetFunctions(char);
void         GetFileName(char);
void         DispFunctions(void);
void         ConfigureKeys(void);

char         Compiler[30] = "TurboC++ Version 2.0";
#ifdef XT
  char       cpu_type[30] = "8088";
#else
  char       cpu_type[30] = "80286";
#endif

/*  =====================================================================  */

void    main(argc,argv)           /*    Main Program Module    */
int argc;
char *argv[];
{

    char   filename[9];
    char   fileext[5];
    char   filedir[66];
    char   filedrive[3];

    fnsplit(argv[0],filedrive, filedir, filename, fileext);
    fnmerge(File_Name,filedrive,filedir,"SETF",".CFG");

    regs.x.ax = 0x1A00;
    int86(0x2F, &regs, &regs);             /* check for ansi */
    regs.h.ah = 0;
    Ansi_OK = regs.x.ax;
    regs.x.ax = 0x0F00;                    /* and monitor type */
    int86(0x10, &regs, &regs);
    regs.h.ah = 0;
    V_Mode = regs.x.ax;

    if ((V_Mode >= 0) && (V_Mode <= 3))    /* check snow if CGA */
        directvideo = 0;

    if (Ansi_OK) {                   /*  can't deal with DOS ansi */
       printf("\nCan't interface with this ANSI driver.\n");
       exit(4);
    }


    #ifdef TRC
      Trace_Init(argc, argv, 1, op_arg_list);
      optind  = 1;
    #endif

    Command = 'X';

                  /*  No arguments, tell them how to use it  */

    while((ch = getopt(argc, argv, op_arg_list, 1)) != EOF)

       switch(ch) {

         case 'c':
         case 'C':  if(Command == 'X') {
                      Command = 'c';
                      break;
                    } else {
                      Print_Small_Help();
                      exit(0);
                    }

         case 'l':
         case 'L':  if(Command == 'X') {
                      Command = 'l';
                      break;
                    } else {
                      Print_Small_Help();
                      exit(0);
                    }

         case 'd':
         case 'D':  if(Command == 'X') {
                      Command = 'd';
                      break;
                    } else {
                      Print_Small_Help();
                      exit(0);
                    }

         case 'i':
         case 'I':  if(Command == 'X') {
                      Command = 'i';
                      break;
                    } else {
                      Print_Small_Help();
                      exit(0);
                    }

         case 'r':
         case 'R':  if(Command == 'X') {
                      Command = 'r';
                      break;
                    } else {
                      Print_Small_Help();
                      exit(0);
                    }

         case 'f':
         case 'F':  {
                     strcpy(File_Name, optarg);
                       fnsplit(File_Name,filedrive,filedir,filename,fileext);
                       if(strcmp(fileext, NULL) == 0)
                         fnmerge(File_Name,filedrive,filedir,filename, ".cfg");
                    }
                    break;

         case '?':
         case 'h':
         case 'H':  PrintHelp();
                    exit(0);

         case ' ':  Print_Small_Help();
                    exit(0);

       }          /* endcase  ch  */

    if(Command == 'X') {
       Print_Small_Help();
              exit(0);
    } else
       ProcessParams(Command);

    #ifdef TRC
      Trace_Init(argc, argv, 0, op_arg_list);
    #endif

}

/* ========================================================================= */

/*   This procedure tests the paramaters and processes command accordingly   */

/* ========================================================================= */
void         ProcessParams(Cmnd)
char         Cmnd;

{

    if((Cmnd != 'i') && (Cmnd != 'r'))
      GetFileName(Cmnd);    /* go get the config file */

    switch(Cmnd) {

        case 'l':
        case 'r':  SetFunctions(Cmnd);     /* Load or Reset the keys */
                   break;

        case 'd':  DispFunctions();        /*  Display the functions  */
                   break;

        case 'i': {                        /*  Initialize a file  */
                    printf("\n\nThis will destroy any data in [%s] if it exists\n", File_Name);
                    printf("Do you wish to continue ? ");
                    Resp = getkey();
                    printf("%c\n",Resp);
                    if (toupper(Resp) == 'Y') {
                      GetFileName(Cmnd);
                      fwrite(FkeyConfig, sizeof(FkeyConfig), 1, fp);
                      printf("%s initialized\n",File_Name);
                    }
                  break;
                  }


        case 'c': {                         /*  Configure the keys  */
                    ConfigureKeys();
                    if (Change == TRUE) {
                       printf("\n\nSave the file ? ");
                       Resp = getkey();
                       if (toupper(Resp) == 'Y') {
                          fseek(fp, 0L, 0);
                          fwrite(FkeyConfig, 1, sizeof(FkeyConfig), fp);
                       }
                       printf("\n\nLoad function keys now ? ");
                       Resp = getkey();
                              printf("\n");   /* Save and set keys if he wants to */
                       if (toupper(Resp) == 'Y')
                          SetFunctions(Cmnd);
                       }
                  break;
                  }

    }                    /* end switch(Cmnd)  */

    fclose(fp);

}

/* ========================================================================= */

/*  This procedure is used to display a help screen under cetain conditions  */

/* ========================================================================= */

void         PrintHelp()

{
    clrscr();
    printf("\nusage:  setf [ - idcrlh?] [ -f filename ]\n");
    printf("\nwhere:    c - configure function keys\n");
    printf("          i - initialize a file\n");
    printf("          l - load the function keys\n");
    printf("          d - display function key settings\n");
    printf("          r - reset function keys\n");
    printf("        ?/h - print this help screen\n");
    printf("options:\n");
    printf("          f - filename of configuration file to use\n");
    printf("              (Default is SETF.CFG in SETF.EXE home directory)\n");
    printf("              (DEFAULT extension is .CFG)\n\n");
    printf("NOTE: An Extended ANSI driver must be installed\n");
    printf("      for this program to work properly.\n");
    printf("      I suggest FCONSOLE or NANSI\n\n");
    printf("  Version  -  4.0 for %s\n",cpu_type);
    printf("  Compiler -  %s\n",Compiler);
    printf("  Purpose  -  Provides means for setting all 48 DOS function keys\n");

}

/* ========================================================================= */

/*  This procedure is used to printout a small help message.                 */

/* ========================================================================= */

void         Print_Small_Help()
{
    printf("\nusage:  setf [ - idcrlh?] [ -f filename ]\n");
    printf("         ( /h or /? for HELP )\n");
}

/* ========================================================================= */

/*  This procedure is used to configure the keys in the configuration file.  */

/* ========================================================================= */

void          ConfigureKeys()
{

    int   i;

    strcpy(Response, "");

    while (toupper(Response[0]) != 'Q') {     /* Do until he quits */
      clrscr();
      printf("Enter a Function Key to setup or Q to quit : ");
        Fkey = getkey();
        if ((toupper(Fkey) == 'Q') && (Fkey < 256))
           return;
        if (Fkey >= F1) {
           KeyHit = Fkey - 314;

         if (KeyHit > 10)         /* if key is not 10 or below */
            KeyHit = KeyHit - 15;  /* take away another 15 */

         if (KeyHit > 40)        /* key is extended F11 or F12 */
               KeyHit = KeyHit - 19;

                   /* Display key hit and present value */

         if (KeyHit <= 10) {
            printf("F%d\n",KeyHit);
         } else if (KeyHit <= 20) {
            printf("Shift F%d\n",KeyHit-10);
         } else if (KeyHit <= 30) {
            printf("Ctrl F%d\n",KeyHit-20);
         } else if (KeyHit <= 40) {
            printf("Alt F%d\n",KeyHit-30);
         } else if (KeyHit < 43) {
            printf("F%d\n",KeyHit - 30);
         } else if (KeyHit < 45) {
            printf("Shift F%d\n",KeyHit - 32);
         } else if (KeyHit < 47) {
            printf("Ctrl F%d\n",KeyHit - 34);
         } else
            printf("Alt F%d\n",KeyHit - 36);

         printf("%s\n\n",FkeyConfig[KeyHit-1].funcstring);
         printf("Enter the command you wish to perform\n");
         printf("- = Delete, C/R = leave unchanged, ESC to abort\n");

         Response = get_string(69);

         if (Response[0] == CR)
            strcpy(Response, NULL);

         if ((strcmp(Response, "-") != 0) && (toupper(Response[0]) != ESC)) {
            if (strcmp(Response, NULL) != 0) {
               Change = TRUE;
               strcpy(FkeyConfig[KeyHit-1].funcstring, Response);
               strcpy(Response, NULL);
            }

         } else if (strcmp(Response, "-") == 0) {
            Change = TRUE;
            for(i=0; FkeyConfig[KeyHit-1].funcstring[i]; i++)
               FkeyConfig[KeyHit-1].funcstring[i] = NULL;

         } else if (toupper(Response[0]) == ESC) {   /***** QUIT *****/
            strcpy(Response, "Q");
         }

        }   /*  End Fkey >= F1  */

    }  /*  End While  */

}                      /*  End Function Configure Keys  */

/* ========================================================================= */

/*  This procedure reads the configuration file and loads the fkey functions */

/* ========================================================================= */

void         SetFunctions(Cmnd)
char         Cmnd;
{
    for (Count = 0; Count < 48; Count++)
    if (strcmp(FkeyConfig[Count].funcstring, NULL) != 0) {
       fprintf(stderr,"\x1b[0;%d;\"%s\";13p",FkeyConfig[Count].funckey,
              FkeyConfig[Count].funcstring);
    } else {
       fprintf(stderr,"\x1b[0;%d;0;%d;p",FkeyConfig[Count].funckey,
              FkeyConfig[Count].funckey);
    }

    if (Cmnd == 'r')
        printf("\nFunction keys reset.\n");
      else
        printf("\nFunction keys set via %s\n",File_Name);
}

/* ========================================================================= */

/*   This procedure displays the function key settings.   */

/* ========================================================================= */

void         DispFunctions()
{

    printf("\nConfiguration file = %s\n\n",File_Name);

                    /*  Search and display Funtion Keys  */

    for (Count = 0; Count < 48; Count++)

        if (strcmp(FkeyConfig[Count].funcstring, NULL) != 0) {
            if (Count < 10)
               printf(" F%2d = ",Count + 1);
             else if (Count < 20)
               printf("SF%2d = ",Count - 9);
             else if (Count < 30)
               printf("CF%2d = ",Count - 19);
             else if (Count < 40)
               printf("AF%2d = ",Count - 29);
             else if (Count < 42)
               printf(" F%2d = ",Count - 29);
             else if (Count < 44)
               printf("SF%2d = ",Count - 31);
             else if (Count < 46)
               printf("CF%2d = ",Count - 33);
             else 
               printf("AF%2d = ",Count - 35);

               /*  Display Function Key Found  */

            printf("%s\n",FkeyConfig[Count].funcstring);

         }

         printf("\n");
}

/* ======================================================================== */

/* Used to get the filename of the configuration file.  Defaults to fkeys.cfg */

/* ======================================================================== */

void         GetFileName(Cmnd)
char         Cmnd;
{
    if (Cmnd == 'i') {
       if ((fp = fopen(File_Name, "wb+")) == NULL) {
          fprintf (stderr,"\n%s : %s \n",sys_errlist[errno], File_Name);
          exit(1);
       }
    } else if ((fp = fopen(File_Name,"rb+")) == NULL) {
       fprintf (stderr,"\n%s : %s \n",sys_errlist[errno], File_Name);
       exit(1);
    }

    if ((Cmnd != 'i') && (Cmnd != 'r'))
       fread(FkeyConfig, sizeof(FkeyConfig), 1, fp);
}
/* ========================================================================= */
