/*****************************************************************************
*
*    Program:   trace.c
*
*    Purpose:   provides means of tracing program execution real-time
*               storing results in a trace file
*
*    Author :   Bob Willoughby
*
*    Date   :   5/14/91
*
*    Usage  :   Include trace.c and tr_init.c in compilation including 
*               trace.h in main source.
*               Call tr_init(argc, argv, start/stop, optionlist)
*                    argc - normal c standard argc
*                    argv - normal c standard argv
*               start/stop - 1 for start, 0 for stop
*               optionlist - list of valid command line options
*               There after, call:
*                     trace(tracelevel, standard printf format ...)
*               You must also include getopt.c in you compilation and
*               parse the command line with it.
*
**************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <dos.h>
#include <io.h>
#define  TRACEDEF
#include <trace.h>

void trace(long mask, const char *format, ...)

{
#ifdef TRC
    va_list args;
    char    va_buffer[8192];
    char    more_args[10240];
    time_t  t;

    Trace_level = Trace_level | T_ALWAYS;

    t = time(NULL);

    if (Trace_level & mask) {
      va_start(args, format);
      vsprintf(va_buffer, format, args);
      sprintf(more_args, "\n%s", ctime(&t));
      strcat(more_args, va_buffer);
      if(fwrite(more_args, strlen(more_args), 1, trace_file) == 0) {
        fprintf(stderr,"Tracefile not open ... aborting");
        exit(1);
      }
      fflush(trace_file);
    }
    va_end(args);
#endif
}
