; This program fills memory from the end of the program to 9FFFF with
;  specified values.  This can help when trying to track down uninitialized
;  variable problems.  The syntax is:
;  SETMEM [{hex number of any even length} {"any string"}]...
;   if a number is specified, memory is filled with that pattern, otherwise
;    memory is set to zeros.  Example: SETMEM 01 ff "j" 1523 fills memory
;     with a repeating 01 ff 6a 15 23 pattern.
; This program is public domain.
;  Joe Ahlgren  92/04/03  BBS 703-241-7980  CSID 70461,2340
;
;
 assume cs:cseg,ds:cseg,es:cseg,ss:cseg
cseg segment para public 'code'
setmem proc near
 mov si,81h
 mov di,si
 mov cl,ds:[80h]
 mov ch,0
 xor ax,ax
 xor bx,bx
 cld
 jcxz checklist
setloop:
 lodsb
 test bx,08000h
 jnz QuoteString
 cmp al,022h
 je StartQuote
 sub al,'0'
 jb nochar
 cmp al,9
 jbe gotchar
 sub al,'A'-'0'
 jb nochar
 cmp al,5
 jbe gotalpha
 sub al,'a'-'A'
 jb nochar
 cmp al,5
 ja nochar
gotalpha:
 add al,10
gotchar:
 test bx,1
 jz nopair
 or al,ah
 stosb
 mov al,0
nopair:
 shl al,1
 shl al,1
 shl al,1
 shl al,1
 mov ah,al
 inc bx
 jmp short nochar
StartQuote:
 or bx,08000h
 jmp short nochar
QuoteString:
 cmp al,022h
 jne QuoteOK
 and bx,07ffeh
 jmp short nochar
QuoteOK:
 stosb
 inc bx
 inc bx
nochar:
 loop setloop
;
checklist:
 and bx,07ffeh
 shr bx,1
 jnz ParamSpec
 xor ax,ax
 stosb
 inc bx
ParamSpec:
 mov si,81h
 add bx,si
 mov cx,es
 add cx,(LastByte-Setmem+255+15)/16
NextPara:
 xor di,di
 mov es,cx
OnePara:
 movsb
 cmp si,bx
 jb MoreSource
 mov si,81h
MoreSource:
 cmp di,16
 jb OnePara
 inc cx
 cmp cx,0a000h
 jb NextPara
;
 mov ax,4c00h
 int 21h
LastByte dw 0
setmem endp
cseg ends
 end



