;
;
TITLE PORTS.ASM
;
;       Purpose: Diagnostic tool to monitor up to 16 ports and display
;                data being received from them.
;
;       Created: 02-OCT-1987    Richard B. Johnson
;
;       Note(s): This program must be assembled as a '.COM' file.
;                MASM PORTS;
;                LINK PORTS;
;                EXE2BIN PORTS.EXE PORTS.COM
;                DEL PORTS.EXE
;
;       Modified:
;               Added provision to write a fixed byte to the ports before
;               reading the port.                       03-OCT-1987 (RBJ)
;
CR      EQU     0DH
LF      EQU     0AH
MS_DOS  EQU     21H                     ; DOS SOFTWARE INTERRUPT
VIDEO   EQU     10H                     ; VIDEO ROM BIOS INTERRUPT
KBD     EQU     16H                     ; KEYBOARD ROM BIOS INTERRUPT
;
PSEG    SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:PSEG, DS:PSEG, ES:PSEG, SS:NOTHING
        ORG     100H
MAIN    PROC    NEAR
        CALL    CLS                             ; CLEAR THE SCREEN
        MOV     SI,OFFSET PRP1                  ; POINT TO PROMPT
        MOV     DI,OFFSET PORTS                 ; WHERE ARE PORT LOCATIONS
GETINP: CALL    DISPLAY                         ; DISPLAY PROMPT
        CALL    CONIN                           ; GET INPUT ASCII
        JZ      NOMORE                          ; NO MORE INPUT
        CALL    PARSE                           ; PARSE INPUT STRING
        STOSW                                   ; SAVE PORT ADDRESS
        INC     BYTE PTR [NUM_PRT]              ; NEXT
        MOV     SI,OFFSET PRP2                  ; POINT TO SECOND PROMPT
        JMP     SHORT GETINP                    ; AND CONTINUE GETTING DATA
NOMORE: MOV     SI,OFFSET PRP4                  ; POINT TO WANT TO WRITE?
        CALL    DISPLAY                         ; PRINT TO SCREEN
        CALL    CONIN                           ; GET BUFFERED RESPONSE
        JZ      NOWRT                           ; NOTHING TYPED
        MOV     AL,BYTE PTR [CONBUF+2]          ; GET TYPED BYTE
        AND     AL,95                           ; MAY TO UPPER CASE
        CMP     AL,'Y'                          ; WAS IT WRITE?
        JNZ     NOWRT                           ; NO
        MOV     BYTE PTR [WFLAG],-1             ; YES, SET THE FLAG
        MOV     SI,OFFSET PRP6                  ; POINT TO 'ENTER BYTE'
        CALL    DISPLAY                         ; PRINT TO SCREEN
        CALL    CONIN                           ; GET EDITED STRING
        CALL    PARSE                           ; RETURN BINARY FROM HEX
        MOV     BYTE PTR [OBYTE],AL             ; SAVE THE BYTE FOR WRITE
NOWRT:  CALL    CLS                             ; CLEAR THE SCREEN
        CALL    KIL_CUR                         ; KILL CURSOR
        MOV     SI,OFFSET PRP5                  ; POINT TO 'HIT ANY KEY'
        CALL    DISPLAY                         ; PRINT TO SCREEN
AGAIN:  CALL    DPORTS                          ; DISPLAY PORTS
        MOV     AH,1                            ; CHECK FOR ABORT
        INT     KBD
        JZ      AGAIN                           ; NO ABORT
        MOV     AH,0                            ; GET INPUT BYTE
        INT     KBD                             ; FLUSH AND EXIT
        JMP     FINIS
MAIN    ENDP
;
;       Convert HEX word in AX to string addressed by DI.
;
HEXW    PROC    NEAR
        PUSH    AX                              ; SAVE WORD
        MOV     AL,AH                           ; HIGH BYTE INTO AL
        CALL    HEX                             ; CONVERT
        POP     AX                              ; FALL THROUGH
;
;       Convert binary in AL to hexadecimal string addressed by DI
;
HEX     PROC    NEAR                            ; CONVERT BYTE IN AL TO HEX
        MOV     AH,AL                           ; SAVE A COPY
        ROL     AL,1                            ; SHIFT OVER FOUR BITS
        ROL     AL,1
        ROL     AL,1
        ROL     AL,1
        CALL    HEX2
        MOV     AL,AH                           ; GET BYTE BACK
HEX2:   AND     AL,0FH                          ; MASK HIGH BITS
        ADD     AL,90H                          ; MAKE LIKE PACKED DECIMAL
        DAA                                     ; ADJUST (OLD INTEL TRICK)
        ADC     AL,40H                          ; ISOLATE A-F
        DAA                                     ; 0 - A REMOVED
        STOSB                                   ; SAVE ASCII
        RET
HEX     ENDP
HEXW    ENDP
;
;       Return Binary in AX from HEX ASCII string addressed by SI.
;
PARSE   PROC    NEAR
        MOV     SI,OFFSET CONBUF + 1            ; POINT TO BYTE COUNT
        LODSB                                   ; GET BYTES TYPED
        MOV     CL,AL                           ; USE AS COUNT
        XOR     CH,CH                           ; ZERO HIGH BYTE
        XOR     BX,BX                           ; START WITH ZERO
        XOR     AH,AH                           ; SAME HERE
PAR1:   SHL     BX,1                            ; * 2
        SHL     BX,1                            ; * 4
        SHL     BX,1                            ; * 8
        SHL     BX,1                            ; * 16
        LODSB                                   ; GET BYTE
        SUB     AL,'0'                          ; ASCII BIAS
        JC      EXIT                            ; CHECK RANGE
        CMP     AL,10                           ; LESS THAN 10?
        JC      LRANGE                          ; YES, LOW RANGE
        AND     AL,95                           ; MAP TO UPPER CASE
        SUB     AL,7                            ; MUST BE A-F
        CMP     AL,16                           ; MORE THAN 15?
        JNC     EXIT                            ; YES, BAD
LRANGE: ADD     BX,AX                           ; ACCUMULATE
        LOOP    PAR1                            ; PICK UP ALL INPUT
EXIT:   MOV     AX,BX                           ; GET RESULT
        RET
PARSE   ENDP
;
;       Put edited console text in a buffer called CONBUF
;
CONIN   PROC    NEAR
        MOV     BYTE PTR [CONBUF],5             ; MAX CHARACTERS
        MOV     DX,OFFSET CONBUF                ; POINT TO BUFFER
        MOV     AH,0AH                          ; BUFFERED INPUT
        INT     MS_DOS
        CMP     BYTE PTR [CONBUF+1],0           ; CHECK FOR ANYTHING TYPED
        RET
CONIN   ENDP
;
;       Print on the screen ASCII characters addressed by SI until a null.
;
DISPLAY PROC    NEAR
        MOV     BX,1Eh                          ; ATTRIBUTE (yellow/blue)
DISP:   LODSB                                   ; GET BYTE
        OR      AL,AL                           ; TEST FOR NULL
        JZ      DONE                            ; END OF STRING
        MOV     AH,14                           ; DUMB TERMINAL MODE
        INT     VIDEO                           ; ROM BIOS
        JMP     SHORT DISP                      ; CONT
DONE:   RET
DISPLAY ENDP
;
;       Display all the selected ports.
;
DPORTS  PROC    NEAR
        MOV     AH,2                            ; SET CURSOR POSITION
        XOR     BX,BX                           ; PAGE ZERO
        MOV     DX,0500H                        ; ROW FIVE/COL ZERO
        INT     VIDEO
        MOV     CL,BYTE PTR NUM_PRT             ; GET NUMBER OF PORTS
        XOR     CH,CH                           ; ZERO HIGH BYTE
        JCXZ    NONE                            ; NO PORTS
        MOV     SI,OFFSET PORTS                 ; POINT TO PORT LOCATIONS
DPOR:   LODSW                                   ; GET PORT ADDRESS
        PUSH    CX                              ; SAVE COUNT
        PUSH    SI                              ; SAVE PORT ADDRESS
        MOV     DX,AX                           ; SAVE IN DX
        MOV     DI,OFFSET HPORT                 ; POINT TO ASCII STRING SPACE
        CALL    HEXW                            ; CONVERT HEX WORD
        CMP     BYTE PTR [WFLAG],0              ; WANT TO WRITE?
        JZ      NOWAY                           ; DON'T WRITE
        MOV     AL,BYTE PTR [OBYTE]             ; GET OUTPUT BYTE
        OUT     DX,AL                           ; OUTPUT THE BYTE
        PUSH    AX                              ; EXERCISE
        POP     AX
NOWAY:  IN      AL,DX                           ; GET BYTE AT PORT
        MOV     DI,OFFSET VPORT                 ; POINT TO VALUE IN STRING
        CALL    HEX                             ; CONVERT TO HEX
        MOV     SI,OFFSET PRP3                  ; POINT TO STRING
        CALL    DISPLAY                         ; DISPLAY ON SCREEN
        POP     SI                              ; RESTORE PORT LOC
        POP     CX                              ; RESTORE COUNT
        LOOP    DPOR                            ; CONTINUE
NONE:   RET
DPORTS  ENDP
;
;       Clear the screen.
;
CLS     PROC    NEAR
        MOV     AX,0600H                ;ERASE/SCROLL SCREEN
        MOV     DH,24                   ;25TH ROW
        MOV     DL,79                   ;80TH COLUMN
        XOR     CX,CX                   ;HOME POSITION
        MOV     BH,7
        INT     VIDEO
        MOV     AH,2                    ;SET CURSOR POSITION
        XOR     DX,DX                   ;UPPER LEFT HAND CORNER
        MOV     BH,0                    ;PAGE ZERO
        INT     VIDEO
        RET
CLS     ENDP
;
FINIS   PROC    NEAR
        MOV     SI,OFFSET PEXIT         ; POINT TO 'EXIT' STRING
        CALL    DISPLAY                 ; PRINT TO SCREEN
        CALL    RES_CUR                 ; RESTORE CURSOR
        MOV     AX,4C00H                ; RETURN TO DOS EXIT CODE 00
        INT     MS_DOS
        CLI                             ; IN CASE ITS BROKE
        HLT                             ; HARD STOP
FINIS   ENDP
;
;       Save cursor type and then remove it.
;
KIL_CUR PROC    NEAR
        MOV     AH,3                            ; CURSOR POOSITION/TYPE
        XOR     BX,BX                           ; PAGE ZERO
        INT     VIDEO
        MOV     WORD PTR [CURSOR],CX            ; SAVE CURSOR TYPE
        MOV     CX,-1                           ; MAKE DISAPPEAR
        MOV     AH,1                            ; SET CURSOR TYPE
        INT     VIDEO
        RET
KIL_CUR ENDP
;
;       Restore cursor.
;
RES_CUR PROC    NEAR
        MOV     CX,WORD PTR [CURSOR]            ; MAKE NEW AGAIN
        MOV     AH,1                            ; SET CURSOR TYPE
        INT     VIDEO
        RET
RES_CUR ENDP
;
NUM_PRT DB      0                               ; NUMBER OF PORTS
WFLAG   DB      0                               ; WRITE FLAG
OBYTE   DB      0                               ; OUTPUT BYTE
PORTS   DW      16 DUP(0)
;
PRP1    DB      CR,LF
HEAD    DB      27 DUP(' ')
        DB      '-  Port diagnostic tool  -'
        DB      CR,LF
        DB      CR,LF,'Enter [Return] only to complete address list.'
PRP2    DB      CR,LF,'Enter port address(s) (HEX) : ',0
PRP3    DB      CR,LF,'Port '
HPORT   DB      'FFFF = '
VPORT   DB      'FF',0
LEN     EQU     $ - PRP3
PRP4    DB      CR,LF,'Write to the port(s)  Y/N ? ',0
PRP6    DB      CR,LF,'Enter byte to write (HEX) : ',0
PRP5    DB      CR,LF,'Hit any key to quit.',0
PEXIT   DB      CR,LF,LF,'End.',CR,LF,0
CURSOR  DW      ?
CONBUF  LABEL   BYTE
;
PSEG    ENDS
        END     MAIN
       DB      CR,LF,'Hit any key to quit.',0
PEXIT   DB      CR,LF,LF,'End.',CR,LF,0
CURSOR
