@echo off

echo !
echo ! ACTRPT - System Activity Report Generator v1.3 (3/6/92 SHS)
echo !

if '%TEMP%' == '' set TEMP=C:\TMP

if exist \sysact.log goto begin
echo ! There is no \SYSACT.LOG file on the default drive!
goto keep

:begin
echo ! Sorting activity log...
echo !
qsort <\sysact.log >%TEMP%\sysact.srt
echo !
echo !     Sorted activity log written to SYSACT.SRT

:top
echo !
askyn ! Do you want a standard system activity report
if errorlevel 1 goto standard

echo !
echo ! Do you want a system activity report that includes lines for
askyn ! commands executed only once
if errorlevel 1 goto detail

echo !
askyn ! Do you want a system activity report without the I/O counts
if errorlevel 1 goto noio

echo !
echo ! Do you want to replace the activity log with a summary
askyn ! of it's current contents
if errorlevel 1 goto summary
goto another


:summary
echo !
echo ! Generating summary data...
safmt <%TEMP%\sysact.srt -s >%TEMP%\activity.sum
echo !
echo !     Activity Summary written to ACTIVITY.SUM
copy \sysact.log \sysact.old >nul
echo !
echo !     Old activity log copied to SYSACT.OLD
copy %TEMP%\activity.sum \sysact.log >nul
echo !
echo !     Activity log replaced with summary data.
goto another


:noio
echo !
echo ! Generating activity report... (without I/O counts)
echo !
safmt <%TEMP%\sysact.srt -j -i >%TEMP%\activity.cmd
echo !     Activity by Command Name   written to ACTIVITY.CMD
echo !
sort /+23 /r <%TEMP%\activity.cmd >%TEMP%\activity.num
echo !     Activity by Number of Runs written to ACTIVITY.NUM
echo !
sort /r <%TEMP%\activity.cmd >%TEMP%\activity.tim
echo !     Activity by Total Time     written to ACTIVITY.TIM
echo !
goto output


:detail
echo !
echo ! Generating activity report... (with single run details)
echo !
safmt <%TEMP%\sysact.srt >%TEMP%\activity.cmd
echo !     Activity by Command Name   written to ACTIVITY.CMD
goto continue

:standard
echo !
echo ! Generating activity report... (standard)
echo !
safmt <%TEMP%\sysact.srt -j >%TEMP%\activity.cmd
echo !     Activity by Command Name   written to ACTIVITY.CMD

:continue
echo !
sort /+48 /r <%TEMP%\activity.cmd >%TEMP%\activity.num
echo !     Activity by Number of Runs written to ACTIVITY.NUM
echo !
sort      /r <%TEMP%\activity.cmd >%TEMP%\activity.tim
echo !     Activity by Total Time     written to ACTIVITY.TIM
echo !

:output
echo !
askyn -R ! Display system activity by Command
if errorlevel 1 goto out2
list %TEMP%\activity.cmd

:out2
echo !
askyn -R ! Display system activity by Number of Runs
if errorlevel 1 goto out3
list %TEMP%\activity.num

:out3
echo !
askyn -R ! Display system activity by Total Run Time
if errorlevel 1 goto out4
list %TEMP%\activity.tim

:out4
echo !
askyn -R ! Report system activity by Command to PRINTER
if errorlevel 1 goto prn2
type %TEMP%\activity.cmd >prn

:prn2
echo !
askyn -R ! Report system activity by Number of Runs to PRINTER
if errorlevel 1 goto prn3
type %TEMP%\activity.num >prn

:prn3
echo !
askyn -R ! Report system activity by Total Run Time to PRINTER
if errorlevel 1 goto another
type %TEMP%\activity.tim >prn

:another
echo !
askyn ! Do you want to run another activity report
if errorlevel 1 goto top

:end
echo !
askyn -R ! Do you want me to delete the scratch files
if errorlevel 1 goto keep

echo !
echo !    Cleaning up...
if exist %TEMP%\activity.num  del %TEMP%\activity.num
if exist %TEMP%\activity.cmd  del %TEMP%\activity.cmd
if exist %TEMP%\activity.tim  del %TEMP%\activity.tim
if exist %TEMP%\activity.sum  del %TEMP%\activity.sum
if exist %TEMP%\sysact.srt    del %TEMP%\sysact.srt
if exist %TEMP%\activity.num  del %TEMP%\activity.num

:keep
echo !
echo ! Returning to DOS.
echo !
