
page 60,132
title System Activity Monitor v1.1 2/2/87

;
; SysAct - System Activity Monitor for DOS
;
; S.H.Smith, 31-jan-87
;
; This system activity facility is provided free of charge.  You may
; copy and distribute this package for any non-commercial purpose.
; Please contact the author for licensing for other applications.
;
; This document and the associated programs are copyright material
; and should not be modified or sold.
;
; Copyright (C) 1987 Samuel H. Smith,
; All commercial rights reserved.
;
; Address all inquiries to:
;        S.H.Smith
;        5119 N. 11th Ave 332
;        Phoenix, Az 85013
;

cseg segment 'code'
   assume cs:cseg,ds:nothing,es:nothing,ss:nothing
   org 100h

entry:
   jmp startup


page
subttl Working Storage Section
;=========================================

;pointers to original interrupt handlers
old_int_20      dd 0
old_int_21      dd 0

;the activity log filename
log_filename    db 'C:\SYSACT.LOG',0

;the program that was executed
exec_name       db 0
                db 13,10,'SysAct (C) 1987 Samuel H. Smith, '
                db 'all commercial rights reserved.',13,10

;the time when the program was started
exec_hour       db 0
exec_min        db 0
exec_sec        db 0
exec_hund       db 0

;the time when it terminated
stop_hour       db 0
stop_min        db 0
stop_sec        db 0
stop_hund       db 0

;some resource usage statistics
exec_reads      dw 0
exec_writes     dw 0
exec_others     dw 0


;-----------------------------------------
; record layout for the log file
;

log_record = log_ident      ;start of the logging record

log_length = (offset signature-offset log_record)    
                            ;total bytecount of the log entry

;filename of the program
   log_ident      db 'filename.ext '

;date of execution
   log_year       db 'yy-'             ;year - 80=1980
   log_month      db 'mm-'             ;month - 01=jan
   log_day        db 'dd '             ;day of month

;time of execution
   log_hour       db 'hh:'
   log_min        db 'mm:'
   log_sec        db 'ss '

;runtime
   log_runhour    db 'hh:'
   log_runmin     db 'mm:'
   log_runsec     db 'ss.'
   log_runhund    db 'hh '

;resource usage counts
   log_reads      db 'rrrr '
   log_writes     db 'wwww '
   log_others     db 'oooo'

                  db 13,10

;installation signature - this pattern is checked to decide if sysact
;is already resident.
signature         dw 'Sa'

;eof marker to stop garbage (in case somebody types the .com file)
                  db 26


page
subttl Subroutine Section
;=========================================

;----------------------------------------
; push all registers macro
;
pushall macro
   push dx
   push cx
   push bx
   push ax
   push bp
   push si
   push di
   push es
   push ds
   endm


;----------------------------------------
; pop all registers macro
;
popall macro
   pop ds
   pop es
   pop di
   pop si
   pop bp
   pop ax
   pop bx
   pop cx
   pop dx
   endm


page
;-----------------------------------------
; convert word to hex
;
; usage:  wtoh destination,source
;
   assume ds:cseg

wtoh macro destination,source
   ifdif <cx>,<source>
      mov cx,source
   endif
   mov di,offset destination
   call wtohs                  ;conversion subroutine
   endm

;
;convert byte in ah to hex digits
;
wtohs proc near
   call wtoh2       ;do high byte
   mov ch,cl        ;fall through to low byte

wtoh2:
   mov al,ch
   ror al,1
   ror al,1
   ror al,1
   ror al,1         ;do high nibble
   call wtoh1
   mov al,ch        ;fall through to low nibble

wtoh1:
   and al,15        ;mask unused bits
   add al,'0'       ;convert to decimal
   cmp al,'9'       ;check for a..f
   jbe wtoh0

   add al,39        ;adjust for a..f
wtoh0:
   mov cs:[di],al   ;place the digit
   inc di
   ret

   assume ds:nothing
wtohs endp


page
;-----------------------------------------
; convert integer to digits
;
; format:  itod destination,source
; exit:    ax changed
;
   assume ds:cseg

itod macro destination,source
   ifdif <al>,<source>
      mov al,source
   endif
   mov di,offset destination
   call itods                  ;convert integer to digits subroutine
   endm

;
;integer to 2 digit ascii conversion
;
itods proc near
   push cx
   mov ah,0
   mov cl,10

itods1:
   sub al,cl
   inc ah
   jnb itods1

   add al,cl
   dec ah

   add ax,'00'
   mov ds:[di],ah
   inc di
   mov ds:[di],al
   pop cx
   ret

   assume ds:nothing
itods endp


page
;-----------------------------------------
; null terminated string copy
;
; entry:  ds:si - source
;         cs:di - destination
;
strcpy proc near
   mov al,ds:[si]
   mov cs:[di],al
   inc si
   inc di
   cmp al,0
   jnz strcpy
   ret
strcpy endp


;-----------------------------------------
; see if a file can be accessed
;
; entry:   ds:dx     - filename
; exit:    cy        - set if file is missing
;
access_file proc near
   mov ax,3d00h               ;open file in read mode
   int 21h
   jb cant_open

   mov bx,ax
   mov ax,3e00h               ;close file
   int 21h

cant_open:
   ret
access_file endp


page
subttl Interrupt Service Section
;=========================================

   assume ds:nothing

;-----------------------------------------
; catch int20 vector - program terminate
;
catch_20:
   call log_activity
   jmp old_int_20


;-----------------------------------------
; catch the int21 vector - dos services
;
catch_21:

;check for functions that control logging
   cmp ah,4bh
   jz handle_exec
   cmp ah,4ch
   jz handle_terminate
   cmp ah,0
   jz handle_terminate

;check functions that are counted
   cmp ah,3fh
   jz handle_read
   cmp ah,40h
   jz handle_write

use_old_21_other:
   inc exec_others

use_old_21:
   jmp old_int_21


;-----------------------------------------
; handle read requests
;
handle_read:
   inc exec_reads
   jmp use_old_21


;-----------------------------------------
; handle write requests
;
handle_write:
   inc exec_writes
   jmp use_old_21

page
;-----------------------------------------
; process terminate calls
;
handle_terminate:
   call log_activity
   jmp use_old_21


;-----------------------------------------
; process exec calls
;
handle_exec:
   cmp al,0                    ;make sure this is not an overlay exec
   jnz use_old_21_other        ;don't log overlays

   pushall

   call access_file            ;see if the exec is going to be possible
   jc bad_exec                 ;don't bother logging if not.  many programs
                               ;search PATH= with multiple bad execs.

   call log_activity           ;log current process in case of process
                               ;nesting.  this should be improved to
                               ;allow a stack of nested processes.

   mov si,dx
   mov di,offset exec_name     ;save filename
   call strcpy

   push cs
   pop ds
   assume ds:cseg

   mov ah,2ah
   int 21h                     ;get start date from dos
   sub cx,1900
   itod log_year,cl
   itod log_month,dh
   itod log_day,dl

   mov ah,2ch
   int 21h                     ;get start time from dos
   mov exec_hour,ch
   mov exec_min,cl
   mov exec_sec,dh
   mov exec_hund,dl
   itod log_hour,ch
   itod log_min,cl
   itod log_sec,dh

   mov exec_reads,0            ;clear the resource accumulators
   mov exec_writes,0
   mov exec_others,0

bad_exec:
   popall
   assume ds:nothing

   jmp use_old_21

page
;-----------------------------------------
; place the ident into the log record
;
place_ident proc near
   assume ds:cseg

   mov si,offset exec_name   ;where to get next char from

place_again:
   mov cx,12                 ;count of chars to be placed
   mov di,offset log_ident   ;where to place the next char

place_next:
   mov al,ds:[si]
   inc si

   cmp al,0
   jz place_filler      ;check for terminators
   cmp cx,0             ;or overlong filenames
   jz place_filler

   cmp al,'\'
   jz place_again
   cmp al,'/'           ;check for separators - reset to start of name
   jz place_again       ;on any of these
   cmp al,':'
   jz place_again

   cmp al,'Z'
   ja place_char
   cmp al,'A'           ;is the character upper case?
   jb place_char

   add al,' '           ;map it to lower case if needed

place_char:
   mov ds:[di],al       ;place the character
   inc di
   dec cx
   jmp place_next

;fill rest of filename field with blanks
place_filler:
   cmp cx,0
   jz end_ident

   mov byte ptr ds:[di],' '
   inc di
   dec cx
   jmp place_filler

end_ident:
   ret
place_ident endp


page
;-----------------------------------------
; place the programs running time into the log
;
place_runtime proc near
      mov ah,2ch
      int 21h               ;get termination time from dos
 
      mov al,dl  ;stop_hund
      sub al,exec_hund
      pushf
      jnc r0

      add al,100           ;borrow 1 second  (100/100)
r0:   itod log_runhund,al
      mov al,dh  ;stop_sec
      popf
      sbb al,exec_sec
      pushf
      jnc r1

      add al,60            ;borrow 1 minute  (60 seconds)
r1:   itod log_runsec,al
      mov al,cl  ;stop_min
      popf
      sbb al,exec_min
      pushf
      jnc r2

      add al,60            ;borrow 1 hour  (60 mins)
r2:   itod log_runmin,al
      mov al,ch  ;stop_hour
      popf
      sbb al,exec_hour
      jnc r3

      add al,24           ;borrow 1 day  (24 hours)
r3:   itod log_runhour,al
      ret
place_runtime endp



;-----------------------------------------
; place the programs resource usage counts into the log
;
place_counts proc near
      wtoh log_reads,exec_reads
      wtoh log_writes,exec_writes
      wtoh log_others,exec_others
      ret
place_counts endp

page
;-----------------------------------------
; write the current log entry to the logfile
;
write_log_entry proc near
   mov ax,3d02h               ;open file in update mode
   mov dx,offset log_filename
   int 21h
   jnb log_open

;couldn't open the logfile, try to create it instead
   mov ax,3c00h               ;create file
   mov cx,0                   ;attributes
   mov dx,offset log_filename
   int 21h

log_open:
   mov bx,ax
   mov ax,4202h               ;seek to end of file
   mov cx,0
   mov dx,cx
   int 21h

   mov ax,4000h               ;write to file
   mov dx,offset log_record   ;what to write
   mov cx,log_length          ;how much to write
   int 21h                    ;perform the write

   mov ax,3e00h               ;close file
   int 21h
   ret
write_log_entry endp


;-----------------------------------------
; make an activity log entry
;
log_activity proc near
   pushall
   push cs
   pop ds

;see if there is anything to log
   cmp byte ptr exec_name,0
   jz logex

;place filename
   call place_ident

;place running time
   call place_runtime

;place the resource counts
   call place_counts

;write the completed log entry to the logfile
   call write_log_entry

   mov byte ptr exec_name,0      ;remove filename from memory

logex:
   popall
   ret

   assume ds:nothing
log_activity endp


page
subttl Program Startup and Initialization Section
;=========================================

;-----------------------------------------
; all of the following code is over-written after startup
;
last_resident db 0

;
; startup entry point
;
startup:
   push cs
   pop ds
   assume ds:cseg

;
; install the dos-services vector
;
   mov ax,3521h
   int 21h                       ;get old int21h vector
   mov word ptr old_int_21,bx
   mov word ptr old_int_21[2],es

   mov ax,es:signature
   cmp ax,cs:signature
   jnz new_installation           ;check for re-installation
   jmp already_resident

new_installation:
   mov ax,2521h
   mov dx,offset catch_21        ;set new 21h vector
   int 21h

;
; install the terminate process vector
;
   mov ax,3520h
   int 21h                       ;get old int20h vector
   mov word ptr old_int_20,bx
   mov word ptr old_int_20[2],es
   mov ax,2520h
   mov dx,offset catch_20        ;set new 20h vector
   int 21h

;
; terminate and stay resident
;
go_resident:
   mov ah,9
   mov dx,offset signon_str
   int 21h

   mov dx,offset last_resident
   mov cl,4
   shr dx,cl
   inc dx
   mov ah,31h
   int 21h

signon_str:
   db 13,10,'System Activity Logger v1.1 (2/2/87 SHS)',13,10,'$'
   db 13,10,'(C) 1987 Samuel H. Smith, all commercial rights reserved.',13,10,26

;
; looks like we are already resident
;
already_resident:
   mov ah,9
   mov dx,offset errormsg_str
   int 21h

   mov ah,0
   int 21h

errormsg_str:
   db 13,10,'SysAct is already resident.',13,10,'$'

cseg ends
end entry


