/*
ͻ
 Header......: LJPRTIII.CH                                                  
                                                                            
 System......: HP LaserJet Series III / PCL print driver                    
                                                                            
 Author......: Kevin Loucks                                                 
             : Box 15303                                                    
             : Minneapolis  MN  55415-0303                                  
             :                                                              
             : (612) 871-9461                                               
             :                                                              
             : CI$ 76276,1333                                               
                                                                            
         Copyright 1992, Kevin Loucks   All rights reserved worldwide.      
                                                                            
Last modified: August 9, 1992                                               
                                                                            
 Req Hardware: HP LaserJet Series III Printer / fully PCL 5 compatible Laser
             : Printer - I haven't tested this on PCL 4 Printers but if they
             : are HP compatible they should just ignore what they can't    
               support                                                      
                                                                            
 Req Software: Clipper 5.01                                                 
                                                                            
 Compilation.: Clipper LJPRTIII /A /M /N /P /W                              
                                                                            
                                                                            
ͼ
*
ͻ
    these define statements establish a bunch of manifest constants that     
    get used pretty extensively in the process of controling the printer     
                                                                             
    they are case sensitive - if you tamper with them be careful!            
                                                                             
    oh - definetly do not use "simpleio.ch" with this code it will cause     
    highly interesting but unsatisfactory behavior                           
                                                                             
    some of these features don't work on some printers (simplex/duplex etc)  
ͼ
*/

   #define ESC              chr(27)

//--- JOB CONTROL COMMANDS
   #define PRINTER_RESET            1
   #define NUMBER_OF_COPIES         2
   #define LEFT_OFFSET              3  // offset registration in decipoints
   #define TOP_OFFSET               4  // offset registration in decipoints
   #define SIMPLEX_DUPLEX           5  // for duplex printers only
   #define DUPLEX_PAGE_SIDE         6  // for duplex printers only
   #define JOB_SEPARATION           7  // for series 2000 ?   only

     // duplex mode selection (for duplex printers only)
   #define SIMPLEX                  0
   #define DUPLEX_ON_LONG_EDGE      1
   #define DUPLEX_ON_SHORT_EDGE     2

     // page side selection  (duplex mode only)
   #define NEXTSIDE                 0
   #define FRONT_SIDE               1
   #define BACK_SIDE                2


// PAGE CONTROL COMMANDS
     // Page Control options
   #define PAGE_SIZE                1
   #define PAGE_LENGTH              2
   #define PAPER_SOURCE             3
   #define LOGICAL_PAGE_ORIENT      4
   #define PRINT_DIRECTION          5
   #define LEFT_MARGIN              6
   #define RIGHT_MARGIN             7
   #define TOP_MARGIN               8
   #define TEXT_LENGTH              9
   #define PERFORATION_REGION      10
   #define HMI                     11
   #define VMI                     12
   #define LINE_SPACING            13
   #define CLEAR_MARGINS           14
   #define PAPER_DESTINATION       15

   #define FORM_FEED               chr(12)

// #define CLEAR_HORIZONTAL_MARGIN  0


     //  page size - PAPER
     // - correct paper tray must be installed for paper size
   #define EXECUTIVE                1   // 7.25 x 10.5
   #define LETTER                   2   // 8.5  x 11
   #define LEGAL                    3   // 8.5  x 14
   #define A4                      26   // 210mm x 297mm

     // page size - ENVELOPES
     // - correct Envelopes must be installed for accurate registration
   #define MONARCH                 80   // commercial envelope (3 7/8 x 7 1/2)
   #define COMMERCIAL_10           81   // commercial envelope (4 1/8 x 9 1/2)
   #define INTERNATIONAL_DL        90   // 110mm x 220mm
   #define INTERNATIONAL_C5        91   // 162mm x 229mm

     // Page Length
     // # lines per page portrait & landscape
   #define EXECUTIVE_6_LPI_PORT    63
   #define EXECUTIVE_8_LPI_PORT    84
   #define EXECUTIVE_6_LPI_LAND    43
   #define EXECUTIVE_8_LPI_LAND    58
   #define LETTER_6_LPI_PORT       66
   #define LETTER_8_LPI_PORT       88
   #define LETTER_6_LPI_LAND       51
   #define LETTER_8_LPI_LAND       68
   #define LEGAL_6_LPI_PORT        84
   #define LEGAL_8_LPI_PORT       112
   #define LEGAL_6_LPI_LAND         0
   #define LEGAL_8_LPI_LAND         0
   #define A4_6_LPI_PORT           70
   #define A4_8_LPI_PORT           93
   #define A4_6_LPI_LAND           49
   #define A4_8_LPI_LAND           66

     // paper source selection
   #define EJECT_PAGE               0
   #define UPPER_TRAY               1
   #define MANUAL_IMPUT             2
   #define MANUAL_ENVELOPE_IMPUT    3
   #define LOWER_TRAY               4
   #define ENVELOPE_FEEDER          6

     // paper destination selection
   #define UPPER_OUTPUT_BIN         1
   #define LOWER_OUTPUT_BIN         2

     // logical page orientation
   #define PORTRAIT                 0
   #define LANDSCAPE                1
   #define REVERSE_PORTRAIT         2
   #define REVERSE_LANDSCAPE        3

     // logical page print direction
   #define PD_PORTRAIT              0
   #define PD_LANDSCAPE             90
   #define PD_REVERSE_PORTRAIT      180
   #define PD_REVERSE_LANDSCAPE     270


     // logical page MARGIN & TEXT SET
   #define CLEAR_HORIZONTAL_MARGIN  0

     // logical perforation SET
   #define DISABLE                  0
   #define ENABLE                   1

     // Horizontal / Vertical Motion Indicator Set
// #define HMI                      0
// #define VMI                      1

     // LINES PER INCH
   #define LPI_1                    1
   #define LPI_2                    2
   #define LPI_3                    3
   #define LPI_4                    4
   #define LPI_6                    6
   #define LPI_8                    8
   #define LPI_12                  12
   #define LPI_16                  16
   #define LPI_24                  24
   #define LPI_48                  48




//-- CURSOR POSITIONING COMMANDS



//-- FONT CONTROL COMMANDS

     // font parameters
   #define SYMBOL_SET               0
   #define SPACING                  1
   #define PITCH                    2
   #define POINT_SIZE               3
   #define STYLE                    4
   #define STROKE_WEIGHT            5
   #define TYPEFACE_FAMILY          6


     // soft font control
   #define DELETE_ALL               0
   #define DELETE_ALL_TEMP          1
   #define DELETE_LAST_FONT         2
   #define DELETE_CHAR_CODE         3
   #define MAKE_TEMPORARY           4
   #define MAKE_PERMANENT           5
   #define COPY_FONT_AS_TEMP        6
   #define SELECT_FONT_PRIM         7
   #define SELECT_FONT_SECOND       8
   #define SELECT_DFLT_PRIM         9
   #define SELECT_DFLT_SECOND      10
   #define TRANSPARENT_PRINT_DATA  11


     // macro control
   #define START_DEFINITION         0
   #define STOP_DEFINITION          1
   #define EXECUTE_MACRO            2
   #define CALL_MACRO               3
   #define ENABLE_AUTO_OVERLAY      4
   #define DISABLE_AUTO_OVERLAY     5
   #define DELETE_ALL_MACROS        6
   #define DELETE_ALL_TEMP_MACROS   7
   #define DELETE_MACRO_LAST        8
   #define MAKE_MACRO_TEMPORARY     9
   #define MAKE_MACRO_PERMANENT    10


     // SOURCE / PATTERN Transparency Options
   #define TRANSPARENT              0
   #define OPAQUE                   0

     // Select current Pattern Options
   #define SOLID_BLACK              0
   #define SOLID_WHITE              1
   #define HP_SHADING_PATTERN       2
   #define HP_CROSSHATCH_PATTERN    3


     // Area Shade fill patterns
     // you can use different numbers
     // but it won't make a difference
   #define SHADE_2_PERCENT            2
   #define SHADE_10_PERCENT          10
   #define SHADE_20_PERCENT          20
   #define SHADE_35_PERCENT          35
   #define SHADE_55_PERCENT          55
   #define SHADE_80_PERCENT          80
   #define SHADE_99_PERCENT          99
   #define SHADE_100_PERCENT        100

     // Area Pattern fill patterns
   #define PATTERN_1                           1
   #define PATTERN_2                           2
   #define PATTERN_3                           3
   #define PATTERN_4                           4
   #define PATTERN_5                           5
   #define PATTERN_6                           6



     // Fill Rectangular Area Options
   #define BLACK_FILL                          0
   #define WHITE_FILL                          1
   #define SHADED_FILL                         2
   #define CROSSHATCH_FILL                     3
   #define CURRENT_PATTERN_FILL                5

     // printer cursor positioning methods
   #define INCHES                              1
   #define DOTS                                2
   #define ROWCOL                              3
   #define MILLIMETER                          4
   #define COL_POSITION                        5
   #define ROW_POSITION                        6


   #define FIXED_SPACING                       0
   #define PROPORTIONAL_SPACING                1

     // line termination command  read tech manual for further definition
   #define DEFAULT                             0
   #define CR_CRLF                             1
   #define LF_CRLF_CRFF                        2
   #define CR_CRLF_CRLF_CRFF                   3


     // printer cursor stack positioning methods
   #define PUSH                                0
   #define POP                                 1


// fonts processing

     // underline command control

   #define FIXED_UNDERLINE_ON                  0
   #define FLOATING_UNDERLINE_ON               3
   #define UNDERLINE_OFF                       9


     // Symbol Set Font Assignment
   #define PRIMARY_SYMBOL_SET                  0
   #define SECONDARY_SYMBOL_SET                1

     // symbol sets
   #define ISO_60_NORWEGIAN_1                  1
   #define ISO_4_UNITED_KINGDOM                2
   #define ISO_69_FRENCH                       3
   #define ISO_21_GERMAN                       4
   #define ISO_15_ITALIAN                      5
   #define MICROSOFT_PUBLISHING                6
   #define DESKTOP                             7
   #define PS_TEXT                             8
   #define VENTURA_INTERNATIONAL               9
   #define VENTURA_US                         10
   #define VENTURA_ITC_ZAPF_DINGBATS          11
   #define PS_ITC_ZAPF_DINGBATS               12
   #define ITC_ZAPF_DINGBATS_SERIES_100       13
   #define ITC_ZAPF_DINGBATS_SERIES_200       14
   #define ITC_ZAPF_DINGBATS_SERIES_300       15
   #define PS_MATH                            16
   #define VENTURA_MATH                       17
   #define MATH_8                             18
   #define ECMA_94_LATIN_1                    19
   #define ISO_11_SWEDISH                     20
   #define ISO_17_SPANISH                     21
   #define ISO_6_ASCII                        22
   #define LEGAL_SYMBOL                       23
   #define ROMAN_8                            24
   #define WINDOWS                            25
   #define PC_8                               26
   #define PC_8_DN                            27
   #define PC_850                             28
   #define PI_FONT                            29

     // style selections
   #define UPRIGHT_SOLID                       1
   #define ITALIC                              2
   #define CONDENSED                           3
   #define CONDENSED_ITALIC                    4
   #define COMPRESSED_EXTRA_CONDENSED          5
   #define EXPANDED                            6
   #define OUTLINE                             7
   #define INLINE                              8
   #define SHADOWED                            9
   #define OUTLINE_SHADOWED                   10


     // Stroke weight selections
   #define ULTRA_THIN                          1
   #define EXTRA_THIN                          2
   #define THIN                                3
   #define EXTRA_LIGHT                         4
   #define LIGHT                               5
   #define DEMI_LIGHT                          6
   #define SEMI_LIGHT                          7
   #define MEDIUM_BOOK_OR_TEXT                 8
   #define SEMI_BOLD                           9
   #define DEMI_BOLD                          10
   #define BOLD                               11
   #define EXTRA_BOLD                         12
   #define BLACK                              13
   #define EXTRA_BLACK                        14
   #define ULTRA_BLACK                        15


     // typeface family selections
   #define COURIER                             1
   #define LINEPRINTER                         2
   #define UNIVERS                             3
   #define CG_TIMES                            4
   #define ANTIQUE_OLIVE                       5
   #define ITC_AVANT_GARDE                     6
   #define BASKERVILLE                         7
   #define ITC_BENGUIAT                        8
   #define CG_BODONI                           9
   #define ITC_BOOKMAN                        10
   #define BRUSH                              11
   #define CG_CENTURY_SCHOOLBOOK              12
   #define ITC_CHELTENHAM                     13
   #define ITC_CLEARFACE                      14
   #define COOPER                             15
   #define DOM_CASUAL                         16
   #define ITC_ERAS                           17
   #define FUTURA_II                          18
   #define ITC_GALLIARD                       19
   #define GARAMOND                           20
   #define GILL_SANS                          21
   #define CG_GAUDY_OLD_STYLE                 22
   #define ITC_KORINA                         23
   #define ITC_LUBALIN_GRAPH                  24
   #define CG_MELLIZA                         25
   #define MICROSTYLE                         26
   #define CG_OMEGA                           27
   #define CG_PALACIO                         28
   #define PARK_AVENUE                        29
   #define REVUE                              30
   #define ROCKWELL                           31
   #define ITC_SOUVENIR                       32
   #define ITC_TIFFANY                        33
   #define CG_TRIUMVIRATE                     35
   #define UNCIAL                             36



// raster graphics options
   #define GRAPHICS_RESOLUTION                 1
   #define PRESENTATION_MODE                   2
   #define RASTER_HEIGHT                       3
   #define RASTER_WIDTH                        4
   #define START_RASTER_GRAPHICS               5
   #define END_RASTER_GRAPHICS                 6
   #define RASTER_Y_OFFSET                     7
   #define COMPRESSION_MODE                    8

   #define DPI_75                             75
   #define DPI_100                           100
   #define DPI_150                           150
   #define DPI_300                           300

   #define LOGICAL_PAGE_MODE                   0
   #define PHYSICAL_PAGE_MODE                  3

   #define LEFT_MARGIN_X_0                     0
   #define LEFT_MARGIN_X_CURRENT               1

    // compression
   #define UNENCODED                           0
   #define RUN_LENGTH_ENCODED                  1
   #define TAGGED_IMAGED_FILE_FORMAT           2
   #define DELTA_ROW_COMPRESSION               3


   // box related manifest constants

   static aBoxParams[9]

   #define BOX_PARAM_format      aBoxParams[ 1 ]     //nXYfmt
   #define BOX_top_line          aBoxParams[ 2 ]     //nYt
   #define BOX_left_side         aBoxParams[ 3 ]     //nXl
   #define BOX_bottom_line       aBoxParams[ 4 ]     //nYb
   #define BOX_right_side        aBoxParams[ 5 ]     //nXr
   #define BOX_line_thickness    aBoxParams[ 6 ]     //nT
   #define BOX_RAF_option        aBoxParams[ 7 ]     //nRAF
   #define BOX_line_pattern      aBoxParams[ 8 ]     //nPattern
   #define BOX_shadow            aBoxParams[ 9 ]     //nShadow

   #define   SHADOW_NONE         0
   #define   SHADOW_NE           1
   #define   SHADOW_SE           2
   #define   SHADOW_NW           3
   #define   SHADOW_SW           4



