
//file classes for the different formats
//main class is a virtual class since it contains stuff
//common to all file formats


class graphics_file
{
public:

	//constructor
	graphics_file(char *filename);

	virtual void print_file(void){}  //different print files for different
									//file types

protected:
	FILE * file_ptr;   //file pointer
	char * grey_buffer_ptr;  //the grey scale line to be passed to
							//the printer ob. same for any type file
	int num_bytes_in_grey_buffer;  //length of the buffer

	graphics_printer *printer; //holds a pointer to the printer ob
};


//define the pcx header type struct
typedef struct
{
	char manufacturer;
	char version;
	char encoding;
	char bits_per_pixel;
	int xmin,ymin;
	int xmax, ymax;
	int hres;
	int vres;
	unsigned char palette[48];
	char reserved;
	char color_planes;
	int bytes_per_line;
	int palette_type;
	char filler[58];
}PCX_HEAD;

//derived class from the above class, for PCX files rather
//than screen images
class pcx_graphics_file:public graphics_file
{
public:
	//constructor
	pcx_graphics_file(char *filename);

	//This time it's not virtual but real.
	void print_file(void); //main entry

protected:
	PCX_HEAD pcx_header;  //place for the file header info1
	int pixels_per_line;

	//methods (protected)
	void print_256_body(void);  //prints out the file
	void print_16_body(void);  //prints out the file
	unsigned char palette_256[256];  //the palette (in grey scale)
	unsigned char palette_16[16];  //the palette (in grey scale)
	int read_256_palette(void);  //reads the palette from the file
	int read_16_palette(void);  //reads the palette from the file
	int grey_convert_256(int convert_char); //converts a palette index
							//to a grey scale value
	int grey_convert_16(char * temp_buffer[4]);
							//to a grey scale value

};




//error handler stuff
int error_message(char *message, int fatal_or_nonfatal);
#define FATAL 0
#define NONFATAL 1
