
//Copyright 1991-1992 Roger Bedell All rights reserved
//See the attached readme file for licensing information.

#include "io.h"
#include "time.h"
#include "stdio.h"
#include "dos.h"
#include "string.h"
#include "bios.h"
#include "mem.h"

#define NONFATAL 1
#define FATAL 0
#define EJECT 1

int send_cmd( char *line_buffer, int length );
int opn_prt(char * path ,int i);
int cls_prt(int flag);
int flush_buf(void);

int printer_error_message(char *, int);
int error_message(char *, int);

//lpt1 file descriptor
int lpt1_fd;

int bbprinter_number; //needs to be set before entering routines

int opn_prt(char * path ,int i)
{

	//use the bios routines
	//try to init it (actually, just get its status)
	int status = _bios_printer(2 , bbprinter_number, 0);

	if(status & 0x01 )
	{   //time out
		printer_error_message("Couldnt open printer - Timed out.",NONFATAL);
		return -1;
	}
	if(status & 0x20 )
	{   //paper out
		printer_error_message("Couldnt open printer - Paper out.",NONFATAL);
		return -1;
	}

	if(status & 0x08 )
	{   //IO error
		printer_error_message("Couldnt open printer - Not on line.",NONFATAL);
		return -1;
	}


	return 1;
}

int cls_prt(int flag)
{
	char * buffer = "\f";
	int count;

	count = strlen(buffer);


	if(flag == EJECT)
	{
		//send a line feed
		send_cmd(buffer, count);

	}

	return 1;
}


int send_cmd( char *line_buffer, int length )
{

	int i;
	while( length > 0)
	{
		//make sure the printer is ready
		int status = _bios_printer(2 , bbprinter_number, 0);

		if(status  & 0x80 )
		{   //not busy
			//print
			_bios_printer(0 , bbprinter_number, *line_buffer++);

			length--;
		}
		if(status & 0x01 )
		{   //time out
			printer_error_message("Couldnt print - Timed out.",NONFATAL);
			return -1;
		}
		if(status & 0x20 )
		{   //paper out
			printer_error_message("Couldnt print - Paper out.",NONFATAL);
			return -1;
		}

		if(!(status & 0x10) )
		{   //not selected
			printer_error_message("Couldnt print - Not Selected.",NONFATAL);
			return -1;
		}

		if(status & 0x08 )
		{   //IO error
			printer_error_message("Couldnt print - Not on line.",NONFATAL);
			return -1;
		}


	}

	return 1;
}

int flush_buf(void)
{
//dont need to
	return 1;
}

#ifdef testprint
void main()
{
	opn_prt("lpt1", 0);
	send_cmd("Hello",5);
	cls_prt(EJECT);
}


#endif

//global printer error flag
int printer_error_flag = 0;

int printer_error_message(char *junk, int j)
{
	error_message(junk,j);
	printer_error_flag = 1;
return 0;
}
