Program LaserjetII;

Uses CRT, DOS, Printer, FastTTT5, WinTTT5, ListTTT5;

const
    ListWidth = 40;

type
    StrList  = string[ListWidth];

var
    MyList   : array[1..31] of StrList;

const on  = true;
      off = false;
      esc = #27;

function formFeed :string;      begin formFeed := #12; end;
function lineFeed :string;      begin lineFeed := #10; end;
function reset :string;         begin reset    := ESC+'E'; end;
function _80x66 :string;
         begin _80x66 := ESC+'&l0o12c1e7.64c66F'+ESC+'&k0S'+ESC+'(10U'; end;
function _132x66 {condensed} :string;
         begin _132x66 := ESC+'&l0o12c1e7.64c66F'+ESC+'&k2S'+ESC+'(10U'; end;
function _176x66 {spreadsheet} :string;
         begin _176x66 := ESC+'&l1o2e5.647c66F'+ESC+'&k2S'+ESC+'(s0T'+ESC+'(10U'; end;
function portrait :string;      begin portrait := ESC+'&l0O'; end;
function landscape :string;     begin landscape := ESC+'&l1O'; end;
function _6LPI :string;         begin _6LPI := ESC+'&l6D'; end;
function _8LPI :string;         begin _8LPI := ESC+'&l8D'; end;
function LinePrinter :string;   begin LinePrinter := ESC+'(s0p0T'; end;
function Courier :string;       begin Courier := ESC+'(s0p3T'; end;
function Helvetica :string;     begin Helvetica := ESC+'(s1p4T'; end;
function TimesRoman :string;    begin TimesRoman := ESC+'(s1p5T'; end;
function LetterGothic :string;  begin LetterGothic := ESC+'(s0p6T'; end;
function Prestige :string;      begin Prestige := ESC+'(s0p8T'; end;
function Presentation :string;  begin Presentation := ESC+'(s0p11T'; end;
function Roman8 :string;        begin Roman8 := ESC+'(8U'; end;
function PC8 :string;           begin PC8 := ESC+'(10U'; end;
function Medium {normal} :string; begin Medium :=ESC+'(s0B'; end;
function Bold :string;          begin Bold :=ESC+'(s3B'; end;
function Upright :string;       begin Upright := ESC+'(s0S'; end;
function Italic :string;        begin Italic := ESC+'(s1S'; end;
function _10pitch :string;      begin _10pitch := ESC+'(s10H'; end;
function _12pitch :string;      begin _12pitch := ESC+'(s12H'; end;
function _17pitch :string;      begin _17pitch := ESC+'(s16.66H'; end;
function _14point :string;      begin _14point := ESC+'(s14V'; end;
function _12point :string;      begin _12point := ESC+'(s12V'; end;
function _10point :string;      begin _10point := ESC+'(s10V'; end;
function _8point :string;       begin  _8point := ESC+'(s8V'; end;
function _6point :string;       begin  _6point := ESC+'(s6V'; end;

Procedure Fill_MyList;
 begin
     MyList[1]  := 'Form Feed';
     MyList[2]  := 'Line Feed';
     MyList[3]  := 'Reset Printer';
     MyList[4]  := '66 lines';
     MyList[5]  := '132x66 {condensed}';
     MyList[6]  := '176x66 {spreadsheet}';
     MyList[7]  := 'portrait mode';
     MyList[8]  := 'landscape mode';
     MyList[9]  := '6 lpi';
     MyList[10] := '8 lpi';
     MyList[11] := 'roman-8';
     MyList[12] := 'PC-8';
     MyList[13] := 'normal';
     Mylist[14] := 'bold';
     Mylist[15] := 'upright';
     Mylist[16] := 'italics';
     Mylist[17] := '10 pitch';
     Mylist[18] := '12 pitch';
     Mylist[19] := '17 pitch';
     Mylist[20] := '14 point';
     Mylist[21] := '12 point';
     Mylist[22] := '10 point';
     Mylist[23] := ' 8 point';
     Mylist[24] := ' 6 point';
     MyList[25] := 'line printer';
     MyList[26] := 'courier';
     MyList[27] := 'helvetica';
     MyList[28] := 'times roman';
     MyList[29] := 'letter gothic';
     MyList[30] := 'prestige';
     MyList[31] := 'presentation';
 end; {of proc Fill_MyList}

begin
    Fill_MyList;
    ClrScr;
    Offcursor;
    with LTTT do
    begin
        Lines := 20;
        Y := 2;
        LeftChar  := ' ';
        RightChar := ' ';
        AllowToggle := true;
        MenuTitle := 'LaserJet II';
    end;
    Show_List(MyList,ListWidth,31);
    if L_picks[1]  then write(lst,formfeed);
    if L_picks[2]  then write(lst,linefeed);
    if L_picks[3]  then write(lst,reset);
    if L_picks[4]  then write(lst,_80x66);
    if L_picks[5]  then write(lst,_132x66);
    if L_picks[6]  then write(lst,_176x66);
    if L_picks[7]  then write(lst,portrait);
    if L_picks[8]  then write(lst,landscape);
    if L_picks[9]  then write(lst,_6lpi);
    if L_picks[10] then write(lst,_8lpi);
    if L_picks[11] then write(lst,roman8);
    if L_picks[12] then write(lst,pc8);
    if L_picks[13] then write(lst,medium);
    if L_picks[14] then write(lst,bold);
    if L_picks[15] then write(lst,upright);
    if L_picks[16] then write(lst,italic);
    if L_picks[17] then write(lst,_10pitch);
    if L_picks[18] then write(lst,_12pitch);
    if L_picks[19] then write(lst,_17pitch);
    if L_picks[20] then write(lst,_14point);
    if L_picks[21] then write(lst,_12point);
    if L_picks[22] then write(lst,_10point);
    if L_picks[23] then write(lst, _8point);
    if L_picks[24] then write(lst, _6point);
    if L_picks[25] then write(lst,lineprinter);
    if L_picks[26] then write(lst,courier);
    if L_picks[27] then write(lst,roman8+helvetica);
    if L_picks[28] then write(lst,roman8+TimesRoman);
    if L_picks[29] then write(lst,LetterGothic);
    if L_picks[30] then write(lst,prestige);
    if L_picks[31] then write(lst,presentation);

    ClearText(1,1,80,25,white,black);
    OnCursor;
end.

