Program P1180;

Uses CRT, DOS, Printer, FastTTT5, WinTTT5, ListTTT5;

const
    ListWidth = 40;

type
    StrList  = string[ListWidth];

var
    MyList   : array[1..42] of StrList;

const on  = true;
      off = false;
      esc = #27;

type string4 = string[4];

function emphasized  (onoff:boolean):string4;
begin case onoff of
    true: emphasized := ESC+'E';
   false: emphasized := ESC+'F';
      end;
end;

function compressed  (onoff:boolean):string4;
begin case onoff of
    true: compressed := #15;
   false: compressed := #18;
      end;
end;

function doubleStrike      (onoff:boolean):string4;
begin case onoff of
    true: doubleStrike := ESC+'G';
   false: doubleStrike := ESC+'H';
      end;
end;

function doubleHigh    (onoff:boolean):string4;
begin case onoff of
    true: doubleHigh := ESC+'w'+#1;
   false: doubleHigh := ESC+'w'+#0;
      end;
end;

function doubleWide    (onoff:boolean):string4;
begin case onoff of
    true: doubleWide := ESC+'W'+#1;
   false: doubleWide := ESC+'W'+#0;
      end;
end;

function italics      (onoff:boolean):string4;
begin case onoff of
    true: italics := ESC+'4';
   false: italics := ESC+'5';
      end;
end;

function proportional(onoff:boolean):string4;
begin case onoff of
    true: proportional := ESC+'p'+#1;
   false: proportional := ESC+'p'+#0;
      end;
end;

function subscript   (onoff:boolean):string4;
begin case onoff of
    true: subscript := ESC+'S'+#1;
   false: subscript := ESC+'T';
      end;
end;

function superscript (onoff:boolean):string4;
begin case onoff of
    true: superscript := ESC+'S'+#0;
   false: superscript := ESC+'T';
      end;
end;

function underline   (onoff:boolean):string4;
begin case onoff of
    true: underline := ESC+'-'+#1;
   false: underline := ESC+'-'+#0;
      end;
end;

function IBM   (onoff:boolean):string4;
begin case onoff of
    true: IBM := ESC+'t'+#1;
   false: IBM := ESC+'t'+#0;
      end;
end;

function NLQ   (onoff:boolean):string4;
begin case onoff of
    true: NLQ := ESC+'x'+#1;
   false: NLQ := ESC+'x'+#0;
      end;
end;

function skipPerf   (onoff:boolean):string4;
begin case onoff of
    true: skipPerf := ESC+#78+#8;
   false: skipPerf := ESC+#79;
      end;
end;


function formFeed :string4;  begin formFeed := #12; end;
function lineFeed :string4;  begin lineFeed := #10; end;
function reset    :string4;  begin reset    := ESC+'@'; end;
function cancel   :string4;  begin cancel   := #24; end;
function _10cpi   :string4;  begin _10cpi   := ESC+'P'; end;
function _12cpi   :string4;  begin _12cpi   := ESC+'M'; end;
function _15cpi   :string4;  begin _15cpi   := ESC+'g'; end;
function _20cpi   :string4;  begin _20cpi   := ESC+'M'+#15; end;
function IBM1     :string4;  begin IBM1     := ESC+'7'; end;
function IBM2     :string4;  begin IBM2     := ESC+'6'; end;
function Courier  :string4;  begin Courier  := ESC+'k'+#0; end;
function Sans     :string4;  begin Sans     := ESC+'k'+#1; end;
function Prestige :string4;  begin Prestige := ESC+'k'+#3; end;
function BoldPS   :string4;  begin BoldPS   := ESC+'k'+#3; end;
function _8lpi    :string4;  begin _8lpi    := ESC+'0'; end;
function _7_72    :string4;  begin _7_72    := ESC+'1'; end;
function _6lpi    :string4;  begin _6lpi    := ESC+'2'; end;

Procedure Fill_MyList;
 begin
     MyList[1]  := 'Form Feed';
     MyList[2]  := 'Line Feed';
     MyList[3]  := 'Reset Printer';
     MyList[4]  := 'Cancel';
     MyList[5]  := '10 cpi';
     MyList[6]  := '12 cpi';
     MyList[7]  := '15 cpi';
     MyList[8]  := '17 cpi (compressed) On';
     MyList[9]  := 'Compressed Off';
     MyList[10] := '20 cpi';
     MyList[11] := 'IBM Graphics On';
     MyList[12] := 'IBM Graphics Off';
     MyList[13] := 'IBM Char Set 1';
     MyList[14] := 'IBM Char Set 2';
     MyList[15] := 'NLQ On';
     MyList[16] := 'NLQ Off';
     MyList[17] := 'NLQ Courier';
     MyList[18] := 'NLQ Sans Serif';
     MyList[19] := 'NLQ Prestige';
     MyList[20] := 'NLQ Bold PS';
     Mylist[21] := 'Italics On';
     Mylist[22] := 'Italics Off';
     Mylist[23] := 'Double High On';
     Mylist[24] := 'Double High Off';
     Mylist[25] := 'Double Wide On';
     Mylist[26] := 'Double Wide Off';
     Mylist[27] := 'PS On';
     Mylist[28] := 'PS Off';
     Mylist[29] := 'Emphasized On';
     Mylist[30] := 'Emphasized Off';
     Mylist[31] := 'Underlined On';
     Mylist[32] := 'Underlined Off';
     Mylist[33] := 'Double-Strike On';
     Mylist[34] := 'Double-Strike Off';
     Mylist[35] := 'Skip Perf On';
     Mylist[36] := 'Skip Perf Off';
     Mylist[37] := 'Subscript On';
     Mylist[38] := 'Superscript On';
     Mylist[39] := 'Sub/Superscript Off';
     Mylist[40] := '8 lpi';
     Mylist[41] := '7/72" spacing';
     Mylist[42] := '6 lpi';
 end; {of proc Fill_MyList}

begin
    Fill_MyList;
    ClrScr;
    Offcursor;
    with LTTT do
    begin
        Lines := 20;
        Y := 2;
        LeftChar  := ' ';
        RightChar := ' ';
        AllowToggle := true;
        MenuTitle := 'KX-P1180';
    end;
    Show_List(MyList,ListWidth,42);
    if L_picks[1]  then write(lst,formfeed);
    if L_picks[2]  then write(lst,linefeed);
    if L_picks[3]  then write(lst,reset);
    if L_picks[4]  then write(lst,cancel);
    if L_picks[5]  then write(lst,_10cpi);
    if L_picks[6]  then write(lst,_12cpi);
    if L_picks[7]  then write(lst,_15cpi);
    if L_picks[8]  then write(lst,compressed(on));
    if L_picks[9]  then write(lst,compressed(off));
    if L_picks[10] then write(lst,_20cpi);
    if L_picks[11] then write(lst,IBM(on));
    if L_picks[12] then write(lst,IBM(off));
    if L_picks[13] then write(lst,IBM1);
    if L_picks[14] then write(lst,IBM2);
    if L_picks[15] then write(lst,NLQ(on));
    if L_picks[16] then write(lst,NLQ(off));
    if L_picks[17] then write(lst,Courier);
    if L_picks[18] then write(lst,Sans);
    if L_picks[19] then write(lst,Prestige);
    if L_picks[20] then write(lst,BoldPS);
    if L_picks[21] then write(lst,italics(on));
    if L_picks[22] then write(lst,italics(off));
    if L_picks[23] then write(lst,doubleHigh(on));
    if L_picks[24] then write(lst,doubleHigh(off));
    if L_picks[25] then write(lst,doubleWide(on));
    if L_picks[26] then write(lst,doubleWide(off));
    if L_picks[27] then write(lst,proportional(on));
    if L_picks[28] then write(lst,proportional(off));
    if L_picks[29] then write(lst,emphasized(on));
    if L_picks[30] then write(lst,emphasized(off));
    if L_picks[31] then write(lst,underline(on));
    if L_picks[32] then write(lst,underline(off));
    if L_picks[33] then write(lst,doubleStrike(on));
    if L_picks[34] then write(lst,doubleStrike(off));
    if L_picks[35] then write(lst,skipPerf(on));
    if L_picks[36] then write(lst,skipPerf(off));
    if L_picks[37] then write(lst,subscript(on));
    if L_picks[38] then write(lst,superscript(on));
    if L_picks[39] then write(lst,subscript(off));
    if L_picks[40] then write(lst,_8lpi);
    if L_picks[41] then write(lst,_7_72);
    if L_picks[42] then write(lst,_6lpi);
    ClearText(1,1,80,25,white,black);
    OnCursor;
end.

