Program P2200XE;

Uses CRT, DOS, Printer, FastTTT5, WinTTT5, ListTTT5;

const
    ListWidth = 40;

type
    StrList  = string[ListWidth];

var
    MyList   : array[1..45] of StrList;

const on  = true;
      off = false;
      esc = #27;
      FS  = #28;

type string4 = string[4];

function emphasized  (onoff:boolean):string4;
begin case onoff of
    true: emphasized := ESC+'E';
   false: emphasized := ESC+'F';
      end;
end;

function compressed  (onoff:boolean):string4;
begin case onoff of
    true: compressed := #15;
   false: compressed := #18;
      end;
end;

function doubleStrike      (onoff:boolean):string4;
begin case onoff of
    true: doubleStrike := ESC+'G';
   false: doubleStrike := ESC+'H';
      end;
end;

function doubleHigh    (onoff:boolean):string4;
begin case onoff of
    true: doubleHigh := FS+'V'+#1;
   false: doubleHigh := FS+'V'+#0;
      end;
end;

function doubleWide    (onoff:boolean):string4;
begin case onoff of
    true: doubleWide := ESC+'W'+#1;
   false: doubleWide := ESC+'W'+#0;
      end;
end;

function italics      (onoff:boolean):string4;
begin case onoff of
    true: italics := ESC+'4';
   false: italics := ESC+'5';
      end;
end;

function PS          (onoff:boolean):string4;
begin case onoff of
    true: PS := ESC+'p'+#1;
   false: PS := ESC+'p'+#0;
      end;
end;

function subscript   (onoff:boolean):string4;
begin case onoff of
    true: subscript := ESC+'S'+#1;
   false: subscript := ESC+'T';
      end;
end;

function superscript (onoff:boolean):string4;
begin case onoff of
    true: superscript := ESC+'S'+#0;
   false: superscript := ESC+'T';
      end;
end;

function underline   (onoff:boolean):string4;
begin case onoff of
    true: underline := ESC+'-'+#1;
   false: underline := ESC+'-'+#0;
      end;
end;

function IBM   (onoff:boolean):string4;
begin case onoff of
    true: IBM := ESC+'t'+#1;
   false: IBM := ESC+'t'+#0;
      end;
end;

function draft   (onoff:boolean):string4;
begin case onoff of
    true: draft := ESC+'x'+#0;
   false: draft := ESC+'x'+#1;
      end;
end;

function skipPerf   (onoff:boolean):string4;
begin case onoff of
    true: skipPerf := ESC+'N'+#4;
   false: skipPerf := ESC+'O';
      end;
end;

function HiSpeed   (onoff:boolean):string4;
begin case onoff of
    true: HiSpeed := FS+'S'+#1;
   false: HiSpeed := FS+'S'+#0;
     end;
end;

function formFeed :string4;  begin formFeed := #12; end;
function lineFeed :string4;  begin lineFeed := #10; end;
function reset    :string4;  begin reset    := FS+'@'; end;
function cancel   :string4;  begin cancel   := #24; end;
function _10cpi   :string4;  begin _10cpi   := ESC+'P'; end;
function _12cpi   :string4;  begin _12cpi   := ESC+'M'; end;
function _15cpi   :string4;  begin _15cpi   := ESC+'g'; end;
function _17cpi   :string4;  begin _17cpi   := ESC+'!'+#4; end;
function _20cpi   :string4;  begin _20cpi   := ESC+'!'+#5; end;
function _8lpi    :string4;  begin _8lpi    := ESC+'0'; end;
function _6lpi    :string4;  begin _6lpi    := ESC+'2'; end;

Procedure Fill_MyList;
 begin
     MyList[1]  := 'Form Feed';
     MyList[2]  := 'Line Feed';
     MyList[3]  := 'Reset Printer';
     MyList[4]  := 'Cancel';
     MyList[5]  := '10 cpi';
     MyList[6]  := '12 cpi';
     MyList[7]  := '12 cpi draft';
     MyList[8]  := '12 cpi hi-speed draft';
     MyList[9]  := '15 cpi';
     MyList[10] := '17 cpi/Compressed On';
     MyList[11] := 'Compressed Off';
     MyList[12] := '20 cpi';
     MyList[13] := 'IBM Graphics On';
     MyList[14] := 'IBM Graphics Off';
     MyList[15] := 'LQ';
     MyList[16] := 'Draft';
     MyList[17] := 'Courier';
     MyList[18] := 'ITC Souvenir 10';
     MyList[19] := 'Fast Focus 10';
     MyList[20] := 'Fast Focus 12';
     Mylist[21] := 'Prestige Elite 12';
     MyList[22] := 'Helvetica 10 point PS';
     MyList[23] := 'Times 10 point PS';
     MyList[24] := 'Bold PS';
     Mylist[25] := 'Italics On';
     Mylist[26] := 'Italics Off';
     Mylist[27] := 'Double High On';
     Mylist[28] := 'Double High Off';
     Mylist[29] := 'Double Wide On';
     Mylist[30] := 'Double Wide Off';
     Mylist[31] := 'PS On';
     Mylist[32] := 'PS Off';
     Mylist[33] := 'Emphasized On';
     Mylist[34] := 'Emphasized Off';
     Mylist[35] := 'Underlined On';
     Mylist[36] := 'Underlined Off';
     Mylist[37] := 'Double-Strike On';
     Mylist[38] := 'Double-Strike Off';
     Mylist[39] := 'Skip Perf On';
     Mylist[40] := 'Skip Perf Off';
     Mylist[41] := 'Subscript On';
     Mylist[42] := 'Superscript On';
     Mylist[43] := 'Sub/Superscript Off';
     Mylist[44] := '8 lpi';
     Mylist[45] := '6 lpi';
 end; {of proc Fill_MyList}

begin
    Fill_MyList;
    ClrScr;
    Offcursor;
    with LTTT do
    begin
        Lines := 20;
        Y := 2;
        LeftChar  := ' ';
        RightChar := ' ';
        AllowToggle := true;
        MenuTitle := 'P2200XE';
    end;
    Show_List(MyList,ListWidth,42);
    if L_picks[1]  then write(lst,formfeed);
    if L_picks[2]  then write(lst,linefeed);
    if L_picks[3]  then write(lst,reset);
    if L_picks[4]  then write(lst,cancel);
    if L_picks[5]  then write(lst,_10cpi);
    if L_picks[6]  then write(lst,_12cpi);
    if L_picks[7]  then write(lst,HiSpeed(off)+draft(on)+_12cpi);
    if L_picks[8]  then write(lst,HiSpeed(on)+draft(on)+_12cpi);
    if L_picks[9]  then write(lst,_15cpi);
    if L_picks[10] then write(lst,compressed(on));
    if L_picks[11] then write(lst,compressed(off));
    if L_picks[12] then write(lst,_20cpi);
    if L_picks[13] then write(lst,IBM(on));
    if L_picks[14] then write(lst,IBM(off));
    if L_picks[15] then write(lst,draft(off));
    if L_picks[16] then write(lst,draft(on));
    if L_picks[17] then write(lst,ESC+'k'+#0);
    if L_picks[18] then write(lst,draft(off)+_10cpi+ESC+'k'+#15);
    if L_picks[19] then write(lst,draft(off)+_10cpi+ESC+'k'+#50);
    if L_picks[20] then write(lst,draft(off)+_12cpi+ESC+'k'+#51);
    if L_picks[21] then write(lst,draft(off)+ESC+'k'+#19);
    if L_picks[22] then write(lst,draft(off)+PS(on)+ESC+'k'+#16);
    if L_picks[23] then write(lst,draft(off)+PS(on)+ESC+'k'+#18);
    if L_picks[24] then write(lst,draft(off)+PS(on)+ESC+'k'+#34);
    if L_picks[25] then write(lst,italics(on));
    if L_picks[26] then write(lst,italics(off));
    if L_picks[27] then write(lst,doubleHigh(on));
    if L_picks[28] then write(lst,doubleHigh(off));
    if L_picks[29] then write(lst,doubleWide(on));
    if L_picks[30] then write(lst,doubleWide(off));
    if L_picks[31] then write(lst,PS(on));
    if L_picks[32] then write(lst,PS(off));
    if L_picks[33] then write(lst,emphasized(on));
    if L_picks[34] then write(lst,emphasized(off));
    if L_picks[35] then write(lst,underline(on));
    if L_picks[36] then write(lst,underline(off));
    if L_picks[37] then write(lst,doubleStrike(on));
    if L_picks[38] then write(lst,doubleStrike(off));
    if L_picks[39] then write(lst,skipPerf(on));
    if L_picks[40] then write(lst,skipPerf(off));
    if L_picks[41] then write(lst,subscript(on));
    if L_picks[42] then write(lst,superscript(on));
    if L_picks[43] then write(lst,subscript(off));
    if L_picks[44] then write(lst,_8lpi);
    if L_picks[45] then write(lst,_6lpi);
    ClearText(1,1,80,25,white,black);
    OnCursor;
end.

