@Echo Off
Rem *=======================[LCAD.Bat]=================================*
Rem Use this batch file to loop LaunchCAD. You can rename it if you wish
Rem or copy it's contents to another batch file.
Rem LaunchCAD copyright 1988-1992 Mountain Software
Rem *==================================================================*

:CheckEnv
  Set TESTENV=test
  If Not "%TESTENV%"=="test" goto EnvError
  Set TESTENV=

Rem *- Put programs here to run before LaunchCAD and AutoCAD
Rem *- load display drivers, EXTLISP, etc.

:Loop
  LC %1
  If ErrorLevel 3 Goto :Error

Rem *- If you wish to execute AutoCAD using "Batch" mode then Configure
Rem *- LaunchCAD with a blank "CAD Program Filename"

  If ErrorLevel 2 Goto Batch
  Goto Loop_Check
:Batch
  Echo Executing AutoCAD in Batch mode...
  If "%USERNAME%"=="" Set USERNAME=LC
  ACAD !BATCH! %USERNAME%

:Loop_Check
  If ErrorLevel 1 GoTo Done
  GoTo :Loop
:Done

Rem *- Put programs here to run after AutoCAD to unload drivers, etc.

  GoTo End
:Error
  Echo An ERROR was detected by LaunchCAD
  GoTo End
:EnvError
  Echo Environment full.  Try adding /E:1024 to SHELL line of CONFIG.SYS, then reboot.
  Echo Example: SHELL=C:\COMMAND.COM /E:1024 /P
  Set TESTENV=
:End

