;*************************************************************
;****  CQM.LSP *******   Autodesk Inc. ***** Nov. 11, 92 **********
; Change Question Mark (CQM)
; Author: Scott Goodfellow
;
; To correct problem of 8-bit SHP files not using the high ASCII characters
; in R12 which cause ? marks to appear in text strings and dimensions when 
; these values have been used in earlier AutoCAD versions.  This example LISP 
; routine converts %%127, %%128, %%129 characters to the special characters 
; %%d %%p %%c. 
;
;******************************************************************  
(defun C:CQM (/ SS SL E DT SLDT SV BT AT E)
   (setq SS (ssget "X" '((-4 . "<or") ( 0 . "DIMENSION" )
                             ( 0 . "TEXT") (-4 . "OR>"))))
   (setq SL (sslength SS))
   (while (>= SL 1)
      (setq E (entget (ssname SS (- SL 1)))) ;Entity
      (setq DT (cdr (assoc 1 E))) ;Dimension text
      (setq SLDT (strlen DT)) ;String Length Dim Text
      (setq SV 1) ;Start Value
      (while (and (>= SV 1) (<= SV (- SLDT 4)))
         (setq SST (substr DT SV 5)) ;SubString Txt
            (if (= SST "%%127")
               (progn
                  (setq BT (substr DT 1 (- SV 1))) ;Before %%nnn text
                  (setq AT (substr DT (+ SV 6) SLDT)) ;After %%nnn text
                  (setq DT (strcat BT "%%d" AT))
                  (setq E (subst (cons 1 DT)(assoc 1 E) e))
                  (entmod E)                  
               )
            )
            (if (= SST "%%128")
               (progn
                  (setq BT (substr DT 1 (- SV 1))) ;Before %%nnn text
                  (setq AT (substr DT (+ SV 6) SLDT)) ;After %%nnn text
                  (setq DT (strcat BT "%%p" AT))
                  (setq E (subst (cons 1 DT)(assoc 1 E) e))
                  (entmod E)                  
               )
            )
            (if (= SST "%%129")
               (progn
                  (setq BT (substr DT 1 (- SV 1))) ;Before %%nnn text
                  (setq AT (substr DT (+ SV 6) SLDT)) ;After %%nnn text
                  (setq DT (strcat BT "%%c" AT))
                  (setq E (subst (cons 1 DT)(assoc 1 E) e))
                  (entmod E)                  
               )
            )
            (setq SV (+ SV 1))
      )
      (setq SL (- SL 1))
   )
)




