; REVOL - Volume of a surface of revolution
;
; Select a polyline that represents the path, and a line that
; represents the axis of revolution - similar to AutoCAD's REVSURF
; command.  REVOL will report the volume enclosed by the surface
; in cubic inches and in cubic centimeters, assuming that the path
; is drawn in inches.
;
; Restrictions:
;
;	The path can only be a 2d polyline, and the axis of revolution
;	can only be a 2d line with the same z as the path.
;
;	Normally, the path is assumed to be drawn in the downward direction,
;	and the axis of revolution in the upward direction.  The reported
;	volumes may be negative or positive if these conventions are
;	violated, but the absolute values of the results will be correct.
;
; Additional options:
;
;	AutoLISP variable "maxblg" controls the accuracy for curved
;	sections of the path.  The default is 0.05.  A smaller value
;	will improve accuracy, and slow down calculation.  The value
;	must be greater than 0.  To change the value (to .1, e.g.);
;
;			(setq maxblg 0.1)
;
;	After REVOL is executed, the results are displayed and saved in
;	the global AutoLISP variables "volume" and "volcc", and can be
;	redisplayed by
;
;		!volume		or	!volcc
;

(defun revvc (p0 p1 bulge / delx dely xo yo dydx pm bul)
	(setq delx (- (car p1) (setq xo (car p0)))
		dely (- (cadr p1) (setq yo (cadr p0))))
	(if (> (abs bulge) maxb)
	(setq pm (list
			(+ xo (* 0.5 (+ delx (* bulge dely))))
			(+ yo (* 0.5 (- dely (* bulge delx)))))
		bul (/ (- (sqrt (+ 1.0 (* bulge bulge))) 1.0) bulge)
		pm (+ (revvc p0 pm bul) (revvc pm p1 bul)))
	(if (not (zerop bulge))
	(setq pm (list
		(+ xo (* 0.5 (+ delx (/ (* 4.0 bulge dely) 3.0))))
		(+ yo (* 0.5 (- dely (/ (* 4.0 bulge delx) 3.0)))))
		pm (+ (revvc p0 pm 0) (revvc pm p1 0)))
	(if (zerop delx) 0
	(if (zerop dely) (* delx yo yo)
	(setq dydx (/ dely delx)
		pm (* delx (+ (* yo yo)
		(* dydx delx (+ yo (/ (* dydx delx) 3.0)))))))))))
(defun revvxf (p) (setq p (list (- y0 (cadr p)) (- (car p) x0)))
	(if (zerop dx) p
		(list (- (* dy (car p)) (* dx (cadr p))) 
			(+ (* dx (car p)) (* dy (cadr p))))))
(defun c:revol ( / next e1 e2 maxb)
	(setq maxb (if maxblg maxblg 0.05))
	(defun next (ent) (entget (entnext (cdr (assoc -1 ent)))))
	(if (setq e1 (entsel "Select path curve: "))
	(if (and (= "POLYLINE" (cdr (assoc 0 (setq e1 (entget (car e1))))))
	    (zerop (boole 7 (cdr (assoc 70 e1)))))
	(if (setq e2 (entsel "Select Axis of revolution: "))
	(if (and (= "LINE" (cdr (assoc 0 (setq e2 (entget (car e2))))))
	    (= (cadddr (assoc 10 e2)) (cadddr (assoc 11 e2))))
	(if (= (cadddr (assoc 10 e2)) (cadddr (assoc 10 e1)))
	(prompt (strcat "\nVolume = " (rtos (revol)) " cu. in., "
		(rtos (setq volcc (* volume 2.54 2.54 2.54))) " cc.\n"))
	(prompt "\nPath and axis not in same plane\n"))
	(prompt "\nAxis must be a 2d line\n")))
	(prompt "\nPath must be a 2d polyline\n"))) (princ))
(defun revol ( / x0 y0 dx dy dd pcl bulge p0 p1)
	(setq x0 (cadr (assoc 10 e2))
		y0 (caddr (assoc 10 e2))
		dx (- (cadr (assoc 11 e2)) x0)
		dy (- (caddr (assoc 11 e2)) y0)
		dd (sqrt (+ (* dx dx) (* dy dy)))
		dx (/ dx dd)
		dy (/ dy dd)
		volume 0
		pcl (= 1 (boole 1 (cdr (assoc 70 e1))))
		e1 (next e1)
		bulge (cdr (assoc 42 e1))
		p1 (revvxf (cdr (assoc 10 e1)))
		pcl (if pcl p1 nil))
	(while (= "VERTEX" (cdr (assoc 0 (setq e1 (next e1)))))
		(setq p0 p1
			p1 (revvxf (cdr (assoc 10 e1)))
			volume (+ volume (revvc p0 p1 bulge))
			bulge (cdr (assoc 42 e1))))
	(setq volume (* pi volume)))
(prompt "REVOL loaded\n")
(princ)
      
