PROGRAM NetDrive;

USES
	Dos, Crt, TPEnv2;

{
TPEnv2 was made from TPENV.ARC downloaded from the PCVENB Lib 6 (TurboPower).
I created a ParentEnv() procedure from parts of provided procedures.
Thank you TurboPower !
}

VAR
	DirExists : SearchRec;
	DriveList : String[21];
	ChkDrive  : String[1];
	CHkFile   : String[18];
	NovDrive  : String[2];
	Counter   : Integer;
	Percent1  : String[20];
	Quiet     : Boolean;

PROCEDURE Syntax;
Begin
WriteLn('NETDRIVE v1.0');
WriteLn('');
WriteLn('A NetWare utility by Danny Dillon  (70214,2221)');
WriteLn('');
WriteLn('NETDRIVE sets the environmental variable "NETDRIVE" to the first drive where');
WriteLn('LOGIN.EXE is found, ( starting with F: and searching through Z: ). It is meant');
WriteLn('to be used in a batch file immediately following NETx, allowing the supervisor');
WriteLn('to write the same batch file for for all workstations, without having to allow');
WriteLn('for a different lastdrive. ');
WriteLn('');
WriteLn('     ...');
WriteLn('     NETX');
WriteLn('     NETDRIVE <Q>');
WriteLn('     If ErrorLevel 0 %NETDRIVE%\LOGIN\LOGIN');
WriteLn('');
WriteLn('Optional Parameter Q turns off console error messages.');
WriteLn('Any other other parameter displays this screen.');
WriteLn('Errorlevel 0 indicates \LOGIN\LOGIN.EXE was found & NETDRIVE set.');
WriteLn('Errorlevel 1 indicates \LOGIN\LOGIN.EXE was not found.');
WriteLn('ErrorLevel 2 indicated a problem writing to the environment.');
WriteLn('');
WriteLn('This program has been tested with MS & IBM DOS 3.3 & up !');
WriteLn(' ');
end;

Begin {MAIN PROGRAM}
	Quiet := False;
	DriveList := 'FGHIJKLMNOPQRSTUVWXYZ';
	If ParamCount <> 0 then begin
		Percent1 := ParamStr(1);
		Percent1[1] := Upcase(Percent1[1]);
		If Percent1 <> 'Q' then Syntax;
		Quiet := True;
	end;

	NovDrive := '';
	For Counter := 1 to 21 do
		Begin
			ChkDrive := DriveList[Counter];
			CHkFile := Concat(ChkDrive,':\LOGIN\LOGIN.EXE');
			FindFirst(ChkFile, AnyFile, DirExists);
			If (DosError = 0) then Begin
				NovDrive := Concat(ChkDrive,':');
				Counter := 21;
			end;
		end;
	If Length(NovDrive) < 2 then Begin
		If NOT Quiet then WriteLn('NETDRIVE ERROR: \LOGIN\LOGIN.EXE not found !');
		Halt(1);
	end;
	ParentEnv(E);
	if not SetEnvStr(E, 'NETDRIVE', NovDrive) then Begin
		If NOT Quiet then WriteLn('Not enough space in environment to add NETDRIVE.');
		Halt(2);
	end;

{ The following is the code for the ParentEnv procedure I added to TPENV.
  It was derived from parts of CurrentEnv & MasterEnv.

  procedure ParentEnv(var Env : EnvRec);
  var
    ESeg : Word;
    Mcb : Word;
	 PSeg : Word;
	 Owner : Word;
  begin
    with Env do begin
      ClearEnvRec(Env);
		Owner := MemW[0:(2+4*$2E)];
		PSeg := MemW[PrefixSeg:$16];
		ESeg := MemW[PSeg:$2C];
		if Eseg = 0 then begin
		  Mcb := Owner+MemW[Mcb:3];
		  if (Mem[Mcb:0] <> Byte('M')) or (MemW[Mcb:1] <> Owner) then
			 Exit;
		  Eseg := Mcb+1;
		end else
		  Mcb := Eseg-1;
		EnvSeg := ESeg;
		EnvLen := MemW[Mcb:3] shl 4;
	 end;
  end;

}
End.







