/*
 * netmess.c
 *
 * author: Samuel Ford
 * 
 * description: Designed to be called from a NetWare login script
 *              (system login script) with the external command
 *              option (#NETMESS.EXE).
 *
 *              Requires the presence of NETMESS.CFG in the path.
 *              NETMESS.CFG will contain one line that is equal to
 *              the path in which the message files reside
 *
 *              Displays in a paged format (similar to "| more" in DOS)
 *              two files: SYSTEM.MES and %COMPANY%.MES
 *              If the environment variable COMPANY is set and a valid file
 *              matches the variable plus the .MES extension, this file
 *              will be displayed after SYSTEM.MES.
 *
 * compiled with Borland Turbo C++
 *
 */

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>

FILE *f1;
char thepath[64];
char thefile[64];
char *covar;
char ch;
int cline = 1;

void ShowFile(FILE *fptr);

int main()
{
   /* Start by reading in the configuration file. */

   f1 = fopen("netmess.cfg", "r");
   if (f1 == NULL) {
      cputs("\nUnable to locate NETMESS.CFG.\n");
      exit(1);
   }

   /* Read the first line - it should be the message directory. */

   fgets(thepath, 64, f1);
   thepath[strlen(thepath) - 1] = '\0';

   /* Close up and get ready to read SYSTEM.MES. */

   fclose(f1);

   strcpy(thefile, thepath);
   strcat(thefile, "system.mes");

   f1 = fopen(thefile, "r");
   if (f1 != NULL) ShowFile(f1);
   fclose(f1);

   /* Now do the company file. */

   covar = getenv("COMPANY");
   strcpy(thefile, thepath);
   if (covar != NULL) strcat(thefile, covar);
   strcat(thefile, ".mes");

   f1 = fopen(thefile, "r");
   if (f1 != NULL) ShowFile(f1);
   fclose(f1);

   printf("Press any key ...");
   ch = getch();

   return(0);
}

void ShowFile(FILE *fptr)
{
   while (!feof(fptr)) {

      while (!feof(fptr) && cline < 25) {
         ch = fgetc(fptr);
         putchar(ch);
         if (wherex() == 1) cline++;
      }

      if (!feof(fptr)) {
         printf("Press any key ...");
         ch = getch();
         printf("\n");
         cline = 1;
      }
   }
   printf("\n");
   cline++;
}