/*
      NetPrompt     
      Disposable Data Module

      NPD.c
      3/18/92

      F. Brett Platko

   This module contains disposable data only. The marker at the end
   "init_end_data" flags the end of disposable data.
      
*/

#include "cr.h"                  // CodeRunner Standard Lib 

// Disposable Messages.

char   msgPrevLoad  [] = "   Program is already loaded   ";
char   msgUnLoaded  [] = "      Program is unloaded      ";
char   msgNoUnload  [] = "  Sorry, Cannot safely unload  ";
char   msgLoaded    [] = "    NetPrompt is now Loaded    ";
char   msgNoNetWare [] = "  NetWare Shell is not loaded  ";

byte   skipIntroFlag = 0x00,              // Flag to Skip Intro Message.
       unloadReq     = 0x00;              // Unload Request Flag.

char   argv0          [67] = "",          // Command line arguments.
      *argv           [06];               // Allow up to 6 parameters.

int    argc;                              

char   attrC [] = {0x1B,0x1E,0x1F,0x13};  // Screen Color choices for Color.
char   attrM [] = {0x70,0x70,0x70,0x70};  // Screen Color choices form mono.

char  *pVidAttr;                          // Current work attribute.

// The MsgIntro string is used by the dspf() function in the NPI module.

char msgIntro [] = "`2\
 `\xAF`m\
`\x04        NetPrompt Utility Ver 1.00 `w\
`3`w\
 `1  NetP  /U  `0 : Unload TSR (if loaded last) `w\
 `1        /NI `0 : Suppress This Intro Screen `w\
 `1        /P= `0 : Prompt String (optional) `w\
`3`w\
 `1               F. Brett Platko `w\
 `1         Serial Number: Public Domain `w\
`3`w\
 `1 `w\
 `r"; 

// The tsr_name string is used by OPI's MapMem utility.

char _tsr_name [] = "NetPrompt (C) 1992 F. B. Platko";

// The cfg_rec structure contains the signature used by the install module
// to detect if this TSR was previously loaded.

struct cfg_rec config_block = { sizeof(config_block),       // Configuration block size 
                                'N','E','T','P',            // Program ID string 
                                100                         // Version 1.00 
                              };

// The following variable is used by the Novell "Version.Exe" program to 
// quickly get program version numbers. You can put anything in this string
// that you want but it must start with the mixed case keyword VeRsIoN=.

char version [] = "VeRsIoN=NetPrompt TSR Ver 1.00";

fp install_list [] = {install_trap};      // Software Interrupt Trap.

word init_data_end = 1;      // Marker for the end-of-init-data (must be = NZ) 


