/*
      NetPrompt
      Disposable Install Module

      NPI.c
      Version 1.00
      3/18/92

      F. Brett Platko

      The module contains disposable code.
     
*/

#include "cr.h"            // CodeRunner Header for Standard Library Functions.
#include "sio.h"           // CodeRunner Header for Standard I/O Functions.

#define STACK_SIZE (160)               // TSR Stack: 160 words.

word ISR_Stk  [STACK_SIZE + 1];        // Interrupt Service Routine work stack.

extern isr21();                        // Interrupt 21 Trap Service.

extern char   argv0          [],       // Variables used to emulate argc and argv.
             *argv           [];

extern int    argc;

extern char   attrC [];                // Screen Attributes for Color Monitors.
extern char   attrM [];                // Screen Attributes for Mono  Monitors.
extern char  *pVidAttr;                // Current Video Attribute.

extern char   msgIntro     [];         // Introduction Message.
extern char   msgPrevLoad  [];         // Previous Load Message.
extern char   msgUnLoaded  [];         // TSR Unloaded Message.
extern char   msgNoUnload  [];         // Could Not Unload TSR Message.
extern char   msgNoNetWare [];         // NetWare is not loaded Message.
extern char   msgLoaded    [];         // TSR has been loaded.

extern byte   unloadReq,               // TSR Unload Request Flag.
              skipIntroFlag;           // Skip Intro Screen Flag.

extern word   init_data_end;           // Marker for end of Disposable Data.

extern int far *fpMasterEnv;           // Far pointer to Master Environment.
extern word     mEnvSize;              // Size of Master Environment.

extern char   promptStr    [];         // Prompt String.

extern struct trap_rec tr;             // ISR Trap Record. (Defined in PA.C).

void init_code_start (void)            // This Dummy function marks start of disposable code.
{
}
 
void  ArgvInit    (void)                           // Generate Argv,Argc
{
   register char  c;                               // Test character.
   register char *line = &cmd_line[0];             // The startup command line.

   up_case (cmd_line);                             // UPcase argument string.

   _get_prog_name(argv0);                          // Program Name (argv[0]) is not 
                                                   // included in the cmd_line var.

   argv[0] = argv0;                                

   for (argc = 0; argc < 6; )                      // Limit arguments to 5.
   {
      while ((*line == ' ') || (*line == '	'))   // blanks and tabs are ignored. 
      {
         line++;	
      }

      if (*line == '\0')                           // No more data.
      {
         break;
      }

      argv[argc++] = line;                         // Fill in the argument data.

      c = *line;

      while ((c != '\0') && c != ' ' && c != '	' && c != '"') 
      {
         c = *++line;                              // non-blanks
      }

      if (c == '\0')                               // End of data.
      {
         break;
      }

      if (c == '"')                                // keep items in quotes together
      {
         c = *++line;

         while (c != '"')
         {
            c = *(++line);
         }
      }

      *(line++) = '\0';

   } 
} 

 void ParseCmdLine (void)                  // Parse Command Line
{ 
   int   x;

   ArgvInit();

   for (x = 0; x <= argc; x ++)
   {
      if (argv[x][0] == '/')                             // Use forward slash as delimiter.   
       {
         switch (argv[x][1])
         {
            case 'U':                                    // Unload TSR.
                        unloadReq = 0x01;
                        return;

            case 'N':                                    // Test for NO's
                        if (argv[x][2] == 'I')           // Skip Intro Screen.
                        {
                           skipIntroFlag = 0x01;
                           break;
                        }
                        
                        break;   

            case 'P':                                    // User Supplied Prompt String
                        strcpy (promptStr, &argv[x][4]);
                        break;

            default:          
                        break;

         }
      }
   }
}
void  IntroScreen (void)                     // Display Introduction Screen 
{
   chk_video();                              // Update video variables.

   if (skipIntroFlag == 0x01)                // If flag is set skip this function.
   {
      return;
   }

   if (vid_mode == 7)                        // If monitor is Mono or Hercules.
   {
      pVidAttr = attrM;
      vid_atr = 7;
   }
   else
   {
      pVidAttr = attrC;                      // Color monitor.
      vid_atr = 3;
   }

   crs_x = 14;                               // Position x and y cursor for screen.
   crs_y = 2;

   dspf(msgIntro, pVidAttr);                 // Display the Introduction screen.
   
   vid_atr = 0x1F;                           // Frame color.               

   crs_x = 14;                   
   crs_y = 2; 

   dsp_box (48,                              // Display double line frame.
            12,
            0X101);

}
main     (void)
{  
   int   rCode;                              // General Purpose Return Code var.
   word  mEnvSeg;                            // Segment of the Master Environment Block.

   ParseCmdLine();                           // Extract memory size & default application   

   IntroScreen ();

   rCode = is_netware();

   if (rCode == 0x00)                        // NetWare is not installed.
   {
      if (skipIntroFlag == 0x01)             // If flag is set display at command line.
      {
         printf(msgNoNetWare);               // Sorry, no NetWare message.
      }
      else
      {
         crs_y = 12;
         crs_x = 22;
      
         dspf(msgNoNetWare);

         crs_x = 0;                          // Put cursor at bottom of screen.
         crs_y = 24;
         vid_atr = 7; 
         clr_eol();
         crs_y --; 
         mv_crs();
      }
      return(1);                             // Exit with return code 1.
   }
   
   if (second_load() != 0)                   // Check if program already loaded   
   {
      if (unloadReq == 0x01)                 // Do we have a Unload Request (/U)?
      {
         if (remove_tsr() == 0x00)           // Can't unload - other TSR in the way   
         {
            if (skipIntroFlag == 0x01)
            {
               printf(msgNoUnload);          // Sorry cannot unload message.
            }
            else
            {
               crs_y = 12;
               crs_x = 22;
      
               dspf(msgNoUnload);

               crs_x = 0;                             
               crs_y = 24;
               vid_atr = 7; 
               clr_eol();
               crs_y --; 
               mv_crs();
            } 

            return(1);                       // Exit with return code 1.
         }
         else                                // TSR Unloaded, exit to DOS.
         {
            if (skipIntroFlag == 0x01)
            {
               printf(msgUnLoaded);          // TSR Unloaded message.
            }
            else
            {
               crs_y = 12;
               crs_x = 22;
      
               dspf(msgUnLoaded);

               crs_x = 0;                             
               crs_y = 24;
               vid_atr = 7; 
               clr_eol();
               crs_y --; 
               mv_crs();
            } 

            return(0);                       // Exit with return code 0.
         }
      }

      if (skipIntroFlag == 0x01)
      {
         printf(msgPrevLoad);                // Already loaded message.
      }
      else
      {
         crs_y = 12;
         crs_x = 22;
      
         dspf(msgPrevLoad);

         crs_x = 0;                             
         crs_y = 24;
         vid_atr = 7; 
         clr_eol();
         crs_y --; 
         mv_crs();
      } 

      return(1);                             // Exit with return code 1.
   }

   mEnvSeg = get_master_env();               // Get master environment segment.

   fpMasterEnv = MK_FP (mEnvSeg, 0);         // Create Far Pointer to Master Env.
                  
   mEnvSize = 16 * ofsg_r2 (3, (mEnvSeg -1));      // To get the size we look at the 
                                                   // word located at offset 3 in the
                                                   // environment block's MCB (in paragraphs.)

   idata_end = &init_data_end;               // Enables Init Data Disposal.
   icode_beg =  init_code_start;             // Enables Init Code Disposal. 

   stay_resident( ISR_Stk,                   // Enable Resident Mode.
                  STACK_SIZE * 2);    
 
   install_trap ( isr21,                     // Install Interrupt Traps.
                  STACK_SIZE,                
                  0x7F);               

   add_trap (&tr);                           // Activate the interrupt trap.

   if (skipIntroFlag == 0x01)
   {
      printf(msgLoaded);                     // TSR loaded message.
   }
   else
   {
      crs_y = 12;
      crs_x = 22;
      
      dspf(msgLoaded);

      crs_x = 0;                             
      crs_y = 24;
      vid_atr = 7; 
      clr_eol();
      crs_y --; 
      mv_crs();
   } 

   return(0);                                // Exit with return code 0.
}
 