#include <stdio.h>
#include <conio.h>

#include "nos.h"
#include "noslib.h"
#include "netpq.h"

extern struct serverdef *server;
extern struct localqueuedef *localqueue;

extern int currentserver, adaptornum, numberoflogins, currentprinter, found;
extern int queuejobcount, printjobcount;
extern int maxlocalqueuecount, localqueuecount;

char *statusstring [] =
    {
    "FREE",
    "UPDATING",
    "HOLDING",
    "WAITING",
    "DESPOOLING",
    "CANCELLED",
    "FILE ERROR",
    "SPOOL ERROR",
    "* RUSH *"
    };

int numberofprinterstrings = 6;
char *printerstring [] =
    {
    "LPT1:",
    "LPT2:",
    "LPT3:",
    "COM1:",
    "COM2:",
    "ALL"
    };

char *printerstatusstring [] =
    {
    "Disabled",
    "Single",
    "Enabled"
    };



reportinfo ()
{
//report server name & time

    currentserver = 0;
    while (currentserver < numberoflogins)
	{
	highvideo ();
	textcolor (YELLOW);
	cprintf ("%-15s", server [currentserver] .servername);
	nohighlight ();
	cprintf ("%*s%02d/%02d/%04d %02d:%02d:%02d", 42,"",
	    server [currentserver] .time.TB_month,
	    server [currentserver] .time.TB_day,
	    server [currentserver] .time.TB_year,
	    server [currentserver] .time.TB_hour,
	    server [currentserver] .time.TB_minutes,
	    server [currentserver] .time.TB_seconds);
	cprintf ("\r\n");

	reportprinterstatus ();

	reportprinterjobs ();

	currentserver++;
	}
}



reportprinterstatus ()
{
//  report status of each of the 5 printer ports on the server

    currentprinter = 0;
    while (currentprinter < 5)
	{
	if (server [currentserver] .PS_state_value [currentprinter] != 0)
	    {
	    highlight ();
	    cprintf ("%s ", printerstring [currentprinter]);

	    if (server [currentserver] .PS_state_pause [currentprinter] == 1)
		{
		highlightblink ();
		cprintf ("%-10s", "Paused");
		}
	    else
		{
		if (server [currentserver] .PS_index [currentprinter] < 65535)
		    {
		    if (server [currentserver] .PS_CPS [currentprinter] == 0)
			highlightblink ();
			cprintf ("%4d CPS  ", server [currentserver] .PS_CPS [currentprinter]);
		    }
		else
		    cprintf ("%-10s", printerstatusstring [server [currentserver] .PS_state_value [currentprinter] ]);
		}
	    nohighlight ();
	    }
	else
	    {
	    cprintf ("%s ", printerstring [currentprinter]);
	    cprintf ("Disabled  ");
	    }
	currentprinter++;
	}
    cprintf ("\r\n");
}



reportprinterjobs ()
{
//report status of each printer job in the server's queue

int outputjobcount;

    printjobcount = 0;
    outputjobcount = 0;
    found = false;

    while (printjobcount < localqueuecount)
	{
	if (localqueue [printjobcount] .server == currentserver)
	    {
	    if (found == false)
		{
		textcolor (CYAN);
		cprintf ("%-6s %-12s %-12s %-12s %-12s %11s %8s",
		    "SEQ #", "USER NAME", "MACHINE", "COMMENT",
		    "DESTINATION", "STATUS", "SIZE");
		cprintf ("\r\n");
		found = true;
		}

	    choosecolor (localqueue [printjobcount] .QE_status);
	    localqueue [printjobcount] .QE_user [12] = '\0';
	    localqueue [printjobcount] .QE_machine [12] = '\0';
	    localqueue [printjobcount] .QE_comment [12] = '\0';
	    localqueue [printjobcount] .QE_destination [12] = '\0';

	    cprintf ("%-6lu", localqueue [printjobcount] .QE_sequence);
	    cprintf (" %-12s", localqueue [printjobcount] .QE_user);
	    cprintf (" %-12s", localqueue [printjobcount] .QE_machine);
	    cprintf (" %-12s", localqueue [printjobcount] .QE_comment);
	    cprintf (" %-12s", localqueue [printjobcount] .QE_destination);

	    //	If despooling, display number of bytes sent

	    if ( (localqueue [printjobcount] .QE_status == 4) && (localqueue [printjobcount] .printer != -1) )
		{
		cprintf (" %8lu of", server [currentserver] .PS_output_chars [localqueue [printjobcount] .printer]);
		}
	    else
		cprintf (" %11s", statusstring [localqueue [printjobcount] .QE_status] );

	    cprintf (" %8lu", localqueue [printjobcount] .QE_size);
	    cprintf ("\r\n");
	    outputjobcount++;
	    if ( (localqueuecount > (21 - (numberoflogins * 5))) &&
		(outputjobcount > (21 - (numberoflogins * 5)) / numberoflogins))
		{
		errorhighlight ();
		cprintf ("Total of %d files in queue\r\n", server [currentserver] .queue_jobs);
		printjobcount = localqueuecount;
		}
	    nohighlight ();
	    }
	printjobcount++;
	}

    if (found == false)
	{
	cprintf ("No files spooled");
	cprintf ("\r\n");
	}
    cprintf ("\r\n");
}


getextch ()
{
//  gets value of extended key press

int c;
    c = getch ();
    if (c == 0)
	{
	c = getch ();
	if (c < 128)
	    c += 128;
	}
    return (c);
}


highlight ()
{
//  sets colors for active servers, and ports

    textcolor (YELLOW);
    highvideo ();
}


nohighlight ()
{
//  sets colors for server time & inactive ports

    textcolor (CYAN);
    lowvideo ();
}


highlightblink ()
{
//  sets colors for paused and 0 CPS ports

    textcolor (LIGHTRED + BLINK);
    highvideo ();
}

errorhighlight ()
{
//  sets colors for error messages

    textcolor (LIGHTRED);
    highvideo ();
}

choosecolor (int status)
{
//  sets colors for queued files status

    switch (status)
	{
	case 2:
	    textcolor (RED);
	    break;
	case 3:
	case 8:
	    textcolor (GREEN);
	    break;
	case 4:
	    textcolor (YELLOW);
	    highvideo ();
	    break;
	default:
	    textcolor (CYAN);
	    break;
	}
}



message (char *messagetext, int eraseflag)
{
//  displays message in center of the first line of the screen

    gotoxy ( (40 - (strlen (messagetext) / 2) ), 1);
    errorhighlight ();
    cprintf ("%s", messagetext);
    nohighlight ();

    if (eraseflag == true)
	{
	sleep (2);
	gotoxy ( (40 - (strlen (messagetext) / 2) ), 1);
	cprintf ("%*s", strlen (messagetext), " ");
	}
}
