/*******************************************************
  Program:	SetPJob
  Programmer:	Ken McKinlay, Ottawa Civic Hospital
  Function:	To set the default print job for a user without having to
		run PRINTCON.  It can also query the system for the default
		print job.
  Returns:	0:	Successful
		1:	DOS file error or command syntax error
		> 1	Network error returned by Novell
  Legal:	The program is made available AS IS.  Ken McKinlay or the
		Ottawa Civic Hospital can not be held responsible for any
		failure due to this program or its use.
		This program has been release into the market as FREEWARE
		and may not be sold.
*******************************************************/

#define	TRUE	1
#define	FALSE	0

#include	<nit.h>
#include	<niterror.h>

#include	<printcon.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

void	ExitCode(int),
	Help(void);

FILE	*fptr;

void	main(int argc, char *argv[])
{
	BYTE		loginTime[7];
	char		updateDefaultJob=FALSE;
	char		directoryPath[32],objectName[48],jobName[32];
	int		errorcode,objectType,i;
	long		objectID;
	size_t		records;
	PRINTCON_HEADER	printconHeader;

	/* If no arguments, display help, if 1 argument set the job to the
	   current user, if 2 arguments, set the job for the user */
	argc--;
	switch (argc)
	{
		case 1:
			if ((errorcode=GetConnectionInformation(GetConnectionNumber(),objectName,&objectType,&objectID,loginTime)) != SUCCESSFUL)
				ExitCode(errorcode);
			strcpy(jobName,argv[1]);
			break;
		case 2:
			if ((errorcode=GetBinderyObjectID(argv[1],OT_USER,&objectID)) != SUCCESSFUL)
				ExitCode(errorcode);
			strcpy(jobName,argv[2]);
			break;
		default:
			Help();
	}

	/* Open the PrintCon.DAT file for the user */
	sprintf(directoryPath,"SYS:MAIL/%lX/PRINTCON.DAT",objectID);
	if ((fptr=fopen(directoryPath,"r+b"))==NULL)
	{
		printf("Error in opening the file: %s\n",directoryPath);
		ExitCode(1);
	}
	
	/* Read in the Header information for the user */
	records=fread(&printconHeader,sizeof(printconHeader),1,fptr);
	if (records < 1)
	{
		printf("Error in reading the file: %s\n",directoryPath);
		ExitCode(1);
	}
	printf("The default print job is: %s\n",printconHeader.defaultJobName);

	/* If the Print Job is a '?', exit out without doing anything */
	if (jobName[0] == '?')
		ExitCode(0);
	
	/* Search for the print job in the table, set a flag if found */
	for (i=0; i < MaxPrintconEntries; i++)
		if (stricmp(jobName,printconHeader.index[i].jobName) == 0)
		{
			updateDefaultJob=TRUE;
			strcpy(printconHeader.defaultJobName,printconHeader.index[i].jobName);
			break;
		}

	/* If the flag is set, write back the header with the new default job */
	if (updateDefaultJob)
	{
		rewind(fptr);
		records=fwrite(&printconHeader,sizeof(printconHeader),1,fptr);
		if (records < 1)
		{
			printf("Error in writing the file: %s\n",directoryPath);
			ExitCode(1);
		}
		printf("The new default print job is: %s\n",printconHeader.defaultJobName);
	}
	else
	{
		printf("The job: %s was no found.\n",jobName);
		ExitCode(1);
	}

	ExitCode(0);
}

/* Close the file, and return with the error code */
void	ExitCode(int errorcode)
{
	fclose(fptr);
	if (errorcode > 1)
		printf("Network error: %d returned on exit.\n",errorcode);

	exit(errorcode);
}

/* Display the help screen and copyright notice */
void	Help(void)
{
	printf("SetPJob      (c) 1991 Ottawa Civic Hospital\n");
	printf("                 Ken McKinlay\n\n");
	printf(" syntax: SetPJob [username] JobName\n");
	printf("                 username is the login name for the server\n");
	printf("                 JobName is a valid print job\n");
	printf("                      or '?' to display the default job\n");

	ExitCode(1);
}
