/* jcc-indx.c Index utility for jcc.c by Duane Paulson 03/25/92 */
#include "jcc.h"

main()
{

	char    *inbuff;
	int     count = 0;
	long    filepos;
	FILE    *infile, *outfile;

	if( ( inbuff = malloc( BUFFSIZE + 1 ) ) == NULL )
	{
		printf( "Out of memory (malloc())\n" );
		exit( 1 );
	}

	if( (infile = fopen( JARGONFILE, "rb" )) == NULL )
	{
		perror( JARGONFILE );
		CLEANUP( 2 );
	}
	printf( "Opened %s\n", JARGONFILE );


	if( (outfile = fopen( HASHFILE, "wb" )) == NULL )
	{
		perror( HASHFILE );
		CLEANUP( 3 );
	}
	printf( "Writing %s", HASHFILE );

	while( ( fgets( inbuff, BUFFSIZE, infile ) ) != NULL )
		if( !strncmp( inbuff, LEX_START, LEX_START_LENGTH ) )
			break;

	filepos = ftell( infile ) + 1;

	while( (fgets( inbuff, BUFFSIZE, infile ) ) != NULL )
	{
		if( !strncmp( inbuff, LEX_END, LEX_END_LENGTH ) )
			break;
		if( *inbuff == METACHAR )
		{
			count++;
			fwrite( &filepos, sizeof filepos, 1, outfile );
			if( !( count % 100 ) )
				printf( "." );
		}
		filepos = ftell( infile ) + 1;
	}
	putchar( '\n' );
	printf( "%d entries written\n", count );
	CLEANUP( 0 );
}

/* end file jcc-indx.c */
