/*
jcc.c  - Jargon Cookie Cutter by Duane Paulson 03/27/92

Prints a cookie pulled at random from a Jargon File definition.
Inspired by Karl Lehenbauer's 1988 cookie.c from Usenet. I have
rewritten most of it to reflect the way I like to do things,
but the underlying structure remains.

HISTORY:

  1.1a  03/28/92: Correct version of 1.1.
  1.1   03/27/92: Fixed bug where using unix format text file
	(with eol being a lone linefeed) running under ms-dos
	resulted in last character of line being truncated.
  1.0   03/25/92: Initial release.

*/

#include "jcc.h"

#ifdef SPLITPATHS
 /* Variables for path-name splitting. */
 char jargonpath[_MAX_PATH], hashpath[_MAX_PATH], drive[_MAX_DRIVE],
      dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
#endif /* SPLITPATHS */

int     random( int min_range, int max_range );

int     random( int min_range, int max_range )
{
	int     trunc;
	float   dec_rand, fraction;

	dec_rand = (float)rand() / 32767.0;
	dec_rand = dec_rand * (float)( max_range - min_range );
	trunc = (int)dec_rand;
	fraction = dec_rand - (float)trunc;
	if( fraction >= 0.5 )
		trunc++;
	return trunc + min_range;
}

main( int argc, char *argv[] )
{
	char    *jargonname = JARGONFILE, *hashname = HASHFILE,
		*inbuff;
	int     selection, entries, scr_line = 1, pause = 1;
	long    index;
	FILE    *jargon, *hash;

#ifdef MSDOS
	int     seed;
#endif /* MSDOS */
	if( ( inbuff = malloc( BUFFSIZE + 1 ) ) == NULL )
	{
		printf( "Out of memory (malloc())\n" );
		exit( 1 );
	}

	switch( argc )
	{
		case 1:
			break;
		case 2:
			if ( tolower(argv[1][0]) == 'n' )
			{
				pause = 0;
				break;
			}
		default:
			printf( "Syntax: %s [n]\n", argv[0] );
			puts( "\tn=no pause" );
			CLEANUP( 2 );
	}

#ifdef SPLITPATHS
	jargonname = jargonpath;
	_splitpath( argv[0], drive, dir, NULL, NULL );
	_splitpath( JARGONFILE, NULL, NULL, fname, ext );
	_makepath( jargonname, drive, dir, fname, ext );
	hashname = hashpath;
	_splitpath( HASHFILE, NULL, NULL, fname, ext );
	_makepath( hashname, drive, dir, fname, ext );
#endif /* SPLITPATHS */

	if( ( jargon = fopen( jargonname, "rb" )) == NULL )
	{
		perror( jargonname );
		CLEANUP( 3 );
	}

	if( ( hash = fopen( hashname, "rb" )) == NULL )
	{
		perror( hashname );
		CLEANUP( 4 );
	}

	if ( fseek( hash, 0L, SEEK_END ) != 0 )
	{
		perror( hashname );
		CLEANUP( 5 );
	}
	entries = ftell(hash) / sizeof (long);

#ifdef MSDOS
	/*
	   Since the process id doesn't provide sufficient
	   randomness under ms-dos single tasking, the system
	   timer is read instead. It ticks 18+ times per second.
	   Note that this is strictly hardware-dependent --
	   don't try this code under any other system.
	*/
	_fmemmove( &seed, (unsigned _far *)0x0040006C, sizeof seed );
	srand( seed );
#else /* ifdef MSDOS */
	srand( getpid() ^ (unsigned)time( NULL ) );
#endif /* MSDOS */

	selection = random( 1, entries );

	fseek( hash, (long)selection * sizeof (long), SEEK_SET );
	fread( &index, sizeof index, 1, hash );

	fseek( jargon, index, SEEK_SET );

	while( ( fgets( inbuff, 320, jargon ) ) != NULL )
	{
		if( *inbuff == METACHAR )
			break;

		scr_line++;
		if(scr_line == SCREENLINES && pause )
		{
			printf( "    Press a key. . ." );
			getch();
			putchar( '\n' );
			scr_line = 1;
		}

		if( EOLSIZE == 2 &&
		 *(inbuff + strlen( inbuff ) - EOLSIZE ) != '\r' )
			*(inbuff + strlen( inbuff ) - 1 ) = '\0';
		else
			*(inbuff + strlen( inbuff ) - 1 ) = '\0';

		puts( inbuff );
	}
	CLEANUP( 0 );
}

/* end file jcc.c */
