/* Jumble */

constants
 win_nbr = 1             % window identifier
 scr_attr = 62           % yellow on cyan.
 frame_attr = 112        % black on white. 
 frame_str = "Jumble"    % window title
 row = 0                 % row position of upper left window corner
 col = 0                 % col position of upper left window corner
 ht = 24                 % height of window in rows
 width = 80              % width of window in columns 
 continue_msg = "Press Any Key To Continue"
 enter_msg = "Enter Your Scrambled Word: "
    
domains
 integerlist = integer*
 
database
 letter( string, integer )
 counts( integer, integer )
 
predicates
 jumble( string, integer, integerlist )
 split( string, integer )
 member( integer, integerlist ) 
 adjust_col( integer, integer, integer, integer, integer )
 adjust_line( integer, integer )
 append( integer, integerlist, integerlist )
   
clauses
  
/* Split accepts a word and splits it into letters. Each letter and it's */
/* position within the word is entered into the database. The position	 */
/* number of the letter to be split off is an input parameter. The front */
/* letter is removed, the position incremented, and the process is       */
/* repeated recursively until an empty string is created.                */

split( "", _ ):-!.

split( Word, Count ):-
  frontstr( 1, Word, First, Rest ),
  assert( letter( First, Count ) ),
  Count1 = Count + 1,
  split( Rest, Count1 ). 

/* Adjust_col calculates the potential ending position of the string about */
/* to be printed. If it would cause the string to be split between two     */
/* lines, then the current line is ended and the next is started.          */

adjust_col( Length, Col1, Line1, Col2, Line2 ) :-
  Col1 > width - 4,
  !,
  nl,
  Line2 = Line1 + 1,
  Col2 = Length + 2.

adjust_col( _, Col1, Line1, Col1, Line1 ):-!.

/* Adjust_line checks to see if the string to be printed would cause */
/* scrolling. If it would, a pause message is displayed, then the    */
/* screen is cleared and the printing continues.                     */

adjust_line( Line1, Line2 ) :-
  Line1 > ht - 4,
  !,
  Line2 = 1,
  nl,
  write( continue_msg ),
  readchar( _ ),
  clearwindow.

adjust_line( Line1, Line1 ):-!.
  
/* Jumble selects a letter from the database. A check is made to ensure    */
/* that it has not already been used. Input parameters are the current     */
/* string being built, the number of letters to be added, and the position */
/* numbers of the letters already chosen. The process continues recursively*/
/* until the number of letters to be added reaches 0, then the constructed */
/* string is printed.                                                      */

jumble( String, 0, _ ) :-
  retract( counts( Col, Line ) ),
  !,
  str_len( String, Length ),
  Col1 = Col + Length + 1,
  adjust_col( Length, Col1, Line, Col2, Line2 ),
  adjust_line( Line2, Line3 ),
  assert( counts( Col2, Line3 ) ),  
  writef( "% ", String ),
  fail.

jumble( String, Length, List ) :-
  Length > 0,
  !,
  letter( A, C1 ),
  not( member( C1, List ) ),
  append( C1, List, List1 ),
  concat( String, A, String1 ),
  Length1 = Length - 1,
  jumble( String1, Length1, List1 ).
  
/* Member succeeds if an integer is already a member of a given list. */

member( Head, [ Head | _ ] ):-!.

member( Head, [ _ | Tail ] ) :-
  member( Head, Tail ).

/* Append adds an integer to the front of a given list. */ 

append( N, List, [ N | List ] ).
      
goal
  makewindow( win_nbr, scr_attr, frame_attr, frame_str, row, col, ht, width ),
  retractall( letter( _, _ ) ),
  retractall( counts( _, _ ) ),
  write( enter_msg ),
  readln( Word ),
  split( Word, 1 ),
  str_len( Word, Length ),
  assert( counts( 1, 1 ) ),
  not( jumble( "", Length, [] ) ).
