;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: The Birdhouse
; Software: PCboard
;     Mode: Manual
;
;
;  History:
;
; 21-sep-91  rewritten using structured programming techniques.
; 25-sep-91  added include for UTILITY.INC, removed log path
;            specification.
; 27-sep-91  fixed re-dial operation.
; 09-oct-91  added ability to do DSZ estimates according to each
;            boards expected connect rate, changed EL to S0.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   The user must edit the string declarations in this file
;   prior to the first use.
;
;   The user must also have their password saved in the dialing directory.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include "utility.inc"                    ; include common aspect procedures
include "pcboard.inc"                    ; include pcboard procedures

proc MAIN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  STRING VARIABLE DECLARATIONS
;;;
;;;  re-edit for each board
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

string DOORWAY   = "y"                   ; doorway loader?: "y" or ""
string ENGLISH   = ""                    ; accept default language?: "y" or ""
string WANTGRAF  = "n"                   ; want graphics?: "n" or ""

string FIRSTNAME = "david"               ; your first name
string LASTNAME  = "mcmillen"            ; your last name

string CONF1     = "j 0"                 ; first conference
string CON_RATE  = "2400"                ; connect rate for DSZ estimates


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  BOARD SPECIFIC PROCEDURE
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

when 0 "More?" transmit "ns^M"           ; pass all screen pauses
when 1 "continue?" transmit "^Mx^M"      ; insure eXpert mode is on
when 2 "Scan Message Base Since" transmit "n^M"   ; don't scan message bases

call OPEN_LOG                            ; open the log file

if not null DOORWAY                      ; skip loader delay?
    call LOADER
endif

if not null ENGLISH                      ; select default language?
    call LANGUAGE
endif

if not null WANTGRAF                     ; use non graphics mode?
    call NO_GRAPH
endif

call LOGIN with FIRSTNAME LASTNAME &S0   ; login to system
call GO_CONF with CONF1                  ; go to the main conference

call SET_CONNECT with CON_RATE           ; set rate for DSZ estimates

endproc ; MAIN
