;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: The Birdhouse
; Software: PCboard
;     Mode: Automatic
;
;
;  History:
;
; 21-sep-91  rewritten using structured programming techniques.
; 25-sep-91  added include for UTILITY.INC, removed log path
;            specification.
; 27-sep-91  fixed re-dial operation.
; 09-oct-91  added ability to do DSZ estimates according to each
;            boards expected connect rate, changed EL to S0.
; 25-oct-91  fixed second conference logic.
; 03-nov-91  removed more? response.
; 06-nov-91  changed more? response from ns^M to ^M.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   This script assumes that the user has the batch file ZMODEM.BAT and
;   Procomm+'s zmodem autodownload option is off.  Also that the SELECT
;   command has been used on the PCboard system to select only the desired
;   conferences for the R Z A command and that Markmail or Kmail have
;   been properly configured (must be in expert mode).
;
;   The user must edit the string declarations in this file
;   prior to the first use.
;
;   The user must also have their password saved in the dialing directory.
;
;   This script will perform the following actions depending on how the
;   user has edited this file.
;
;   1.  Set expert mode on (if not already on) and leave it on.
;
;   2.  Read message bases and new files through Markmail or Kmail
;       or get messages with R Z A and scan for new files.
;
;   3.  If using markmail or Kmail, upload reply packet if it exists,
;       then delete it if successful.
;
;   4.  Flag main conference files for downloading if any were defined
;       in the string variable declarations.
;
;   5.  If a second conference command is declared, flag second
;       conference files for downloading if any were defined in the
;       string variable declarations.
;
;   6.  Download all flagged files, or timeout and skip if
;       no files were flagged.
;
;   7.  If files to be uploaded are declared , upload them to the main
;       conference.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include "utility.inc"                    ; include common Aspect procedures
include "pcboard.inc"                    ; include pcboard procedures

proc MAIN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  STRING VARIABLE DECLARATIONS
;;;
;;;  re-edit for each logon
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                                         ; first conference files ("" = none)
string DFILES1   = ""
; max length        ----------------------------------------------------------------------------

                                         ; second conference files ("" = none)
string DFILES2   = ""

                                         ; file to upload ("" = none)
string UFILE1    = ""
string UFILE1D   = ""
; max length        -------------------------------------------------------------------------
                                         ; description of file to upload

string UFILE2    = ""
string UFILE2D   = ""

string UFILE3    = ""
string UFILE3D   = ""

string UFILE4    = ""
string UFILE4D   = ""


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  STRING VARIABLE DECLARATIONS
;;;
;;;  re-edit for each board
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

string DOORWAY   = "y"                   ; doorway loader?: "y" or ""
string ENGLISH   = ""                    ; accept default language?: "y" or ""
string WANTGRAF  = "n"                   ; want graphics?: "n" or ""

string FIRSTNAME = "david"               ; your first name
string LASTNAME  = "mcmillen"            ; your last name
string DLPASSWD  = ""                    ; download password "password^M"

string READER    = "markmail"            ; mail reader?: "markmail", "kmail",
                                         ; "rza" or "none"
string READERCMD = "door mm-2"           ; command to open reader door (if any)
string PACKET    = "bhbbs.qwk"           ; name of message packet file
string REPLIES   = "bhbbs.rep"           ; name of message reply file

string CONF1     = "j 0"                 ; first conference
string CONF2     = ""                    ; second conference ("" = none)
string CON_RATE  = "2400"                ; connect rate for DSZ estimates


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  BOARD SPECIFIC PROCEDURE
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; when 0 "More?" transmit "ns^M"           ; pass all screen pauses
when 0 "More?" transmit "^M"             ; pass all screen pauses
when 1 "continue?" transmit "^Mx^M"      ; insure eXpert mode is on
when 2 "Scan Message Base Since" transmit "n^M"   ; don't scan message bases

call OPEN_LOG                            ; open the log file

try_again:

if not null DOORWAY                      ; skip loader delay?
    call LOADER
endif

if not null ENGLISH                      ; select default language?
    call LANGUAGE
endif

if not null WANTGRAF                     ; use non graphics mode?
    call NO_GRAPH
endif

call LOGIN with FIRSTNAME LASTNAME &S0   ; login to system
if not null S0
    call RE_DIAL                         ; re-login on failure
    goto try_again
endif

call GO_CONF with CONF1                  ; go to the main conference

cwhen 0                                  ; clear responses
cwhen 1
cwhen 2

call SET_CONNECT with CON_RATE           ; set rate for DSZ estimates

switch READER                            ; read new mail, scan for new files
    case "markmail"
        call MARKMAIL with READERCMD PACKET REPLIES
    endcase
    case "kmail"
        call KMAIL with READERCMD PACKET REPLIES
    endcase
    case "rza"
        call RZAMAIL with CONF1          ; use "R Z A" command
        call NEW_FILES                   ; scan for new files
    endcase
endswitch

if not null DFILES1                      ; flag files to download
    call FLAG_FILES with DFILES1         ; from first conference
endif

if not null CONF2                        ; if second conference exists
    call GO_CONF with CONF2              ; go there
    strcmp READER "rza"                  ; scan for new files
    if success
        call NEW_FILES
    endif
    if not null DFILES2                  ; flag files to download
        call FLAG_FILES with DFILES2
    endif
    call GO_CONF with CONF1              ; go back
endif

if not null DFILES1                      ; download flagged files
    call DOWNLOAD with DLPASSWD
else
    if not null DFILES2
        call DOWNLOAD with DLPASSWD
    endif
endif

if not null UFILE1                       ; upload file(s)
    call UPLOAD with UFILE1 UFILE1D
    if not null UFILE2
        call UPLOAD with UFILE2 UFILE2D
        if not null UFILE3
            call UPLOAD with UFILE3 UFILE3D
            if not null UFILE4
                call UPLOAD with UFILE4 UFILE4D
            endif
        endif
    endif
endif

call LOGOFF                              ; logoff

quit                                     ; exit Procomm+

endproc ; MAIN
