;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;  History:
;
;  26-jan-91  Original release.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; determine max cps rate for modem to PC communication
;
;
include "utility.inc"                    ; include utility routines

proc MAIN
    string STATUS       = "AT^M"         ; modem command: hello?
    string TESTSTRING   = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKL^M^J"
    string STARTTIME    = ""
    string ENDTIME      = ""
    long ST_SEC         = 0
    long EN_SEC         = 0
    long EL_TIME        = 0
    long CPSRATE        = 0
    long CHARS          = 50000          ; number of chars to send
                                         ; must be a multiple of 50
    integer LOOPS       = 0

    message "Seting up modem for test..."
    transmit STATUS
    waitfor "ok"
    pause 1
 
    message "Determining CPS rate..."
    LOOPS       = CHARS / 50             ; determine the number of loops to do

    STARTTIME   = $TIME1

    for N0=1 upto LOOPS                  ; send lots o' data
        transmit    TESTSTRING
    endfor

    ENDTIME     = $TIME1

    call MIL2LONG with STARTTIME &ST_SEC ; get absolute seconds value
    call MIL2LONG with ENDTIME &EN_SEC

    EL_TIME     = EN_SEC - ST_SEC            ; get elapsed seconds
    CPSRATE     = CHARS / EL_TIME            ; get cps rate

    strfmt      S0 "Started at: %s^M^JEnded at  : %s^M^J" STARTTIME ENDTIME
    message     S0

    strfmt      S0 "Start secs: %ld ^M^JEnd secs  : %ld ^M^J" ST_SEC EN_SEC
    message     S0

    strfmt      S0 "Elapsed time:  %ld  seconds^M^J" EL_TIME
    message     S0

    strfmt      S0 "Transfer rate:  %ld  cps^M^J" CPSRATE
    message     S0

endproc ; MAIN
