;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script INCLUDE file
; written by  David R. McMillen
;
; This is an Aspect include file for all GAP scripts.  It contains all
; procedures common to GAP scripts.
;
;
;  History:
;
;  08-aug-91  original version.
;  05-sep-91  fixed manual mode, changed reader decision.
;  06-sep-91  added bulletin prompt response.
;  17-sep-91  changed to external DSZ zmodem, increased waitfor
;             username, made name/pass waitfor's more generic.
;  19-sep-91  fixed download prompts.
;  28-sep-91  rewritten using structured programming techniques.
;  09-oct-91  fixed LOGOFF to send CR before waiting for prompt,
;             changed all "when" statements to "when 2", initialized
;             EL in LOGIN.
;  18-oct-91  changed MARKMAIL to upload replies before downloading
;             a new packet.
;  24-oct-91  added DATE_QWK to MARKMAIL.
;  17-jan-92  added PROC_QWK to MARKMAIL.
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      NO_GRAPH
;   Parameters:     none
;   Description:    selects non-graphics mode.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc NO_GRAPH

    waitfor "[Enter] = Yes" 10           ; ansi graphics mode?
    transmit "n^M"

endproc ; NO_GRAPH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LOGIN
;   Parameters:     with string1 string2 &string3
;   Description:    give name and password.
;   Returns:        error code if failure.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LOGIN

    strparm     FIRSTNAME, LASTNAME, EL

    EL = ""                              ; assume success
    waitfor "first name" 20
    if waitfor
        transmit FIRSTNAME
        transmit "^M"

        waitfor "last name"
        transmit LASTNAME
        transmit "^M"

        waitfor "password"
        transmit $D_PWORD                ; get it from the dialing directory

        waitfor "board command" forever
    else
        EL = "1"                         ; indicate failure
    endif

endproc ; LOGIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      MARKMAIL
;   Parameters:     with string1 string2 string3
;   Description:    open markmail door, get packet, close door.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc MARKMAIL

    strparm DOOR
    strparm PACKET
    strparm REPLIES

    transmit "^M"                        ; enter mark mail door
    waitfor "board command" forever
    transmit DOOR
    transmit "^M"
    waitfor "markmail command" forever

    findfirst REPLIES                    ; upload replies (if any)
    if FOUND
        transmit "u^M"
        waitfor "protocol type" 20
        strfmt S1 "zmodem %s" REPLIES
        dos S1
        delete REPLIES
        transmit "^M"
        waitfor "markmail command"  forever
    endif

    delete "saved.qwk"                   ; get rid of old packets
    rename PACKET "saved.qwk"

    transmit "d^M"                       ; build new packet
    when 2 "Receive this Packet" transmit "y^M"
    waitfor "sorry, no messages" 10      ; no packet available?
    if waitfor
        message "^M^JNo packet to download."
    else
        waitfor "rz" forever
        dos "zmodem"                     ; run external zmodem
        call PROC_QWK with PACKET        ; process packet first
        call DATE_QWK with PACKET        ; date and save packet
    endif
    cwhen 2                              ; clear response
    transmit "^M"
    waitfor "markmail command" forever   ; return to board
    transmit "q^M"
    waitfor "board command"

endproc ; MARKMAIL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      DOWNLOAD
;   Parameters:     with string1
;   Description:    download all files specified in the string passed.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc DOWNLOAD

    strparm DFILES

    transmit "^M"
    waitfor "board Command" forever
    transmit "f^M"
    waitfor "Files Command"
    transmit "d^M"
    waitfor "marked files" 5             ; do not download marked files
    if waitfor
        transmit "n^M"
        waitfor "File # 1"
    endif

    transmit DFILES                      ; specify files to download
    transmit "^M"

    waitfor "download (e/C)" 20          ; file list complete?
    if waitfor
        transmit "^M"                    ; say yes
        waitfor "[Y]es [N]o" 10          ; action after download?
        if waitfor
            transmit "^M"                ; say continue
            waitfor "rz" forever
            dos "zmodem"                 ; run external zmodem
        else
            message "^M^JTimed out waiting for action after download prompt."
        endif
    else
        message "^M^JTimed out after specifing file names."
    endif

    transmit "^M"
    waitfor "Files Command" forever      ; return to main menu
    transmit "q^M"

endproc ; DOWNLOAD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      UPLOAD
;   Parameters:     with string1 string2
;   Description:    upload specified file using specified description.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc UPLOAD

    strparm UFILE
    strparm UDESC

    transmit "^M"
    waitfor "board Command" forever
    transmit "f^M"
    waitfor "Files Command"
    transmit "u "
    transmit UFILE                       ; send filename
    transmit "^M"
    waitfor "more than 1 file"           ; one file at a time
    transmit "n^M"

    waitfor "for sysop Only" 20          ; public download? yes
    if waitfor
        transmit "^M"
        waitfor "keywords"
        transmit UDESC                   ; send file description
        transmit "^M"
        waitfor "description"
        transmit UDESC
        transmit "^M"
        transmit "^M"
        waitfor "[S]ave, [H]elp"
        transmit "s^M"
        strfmt S1 "zmodem %s" UFILE      ; upload file with dsz
        dos S1
    else
        message "^M^JTimed out, probably a duplicate file."
    endif

    transmit "^M"
    waitfor "Files Command" 120
    transmit "q^M"

endproc ; UPLOAD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LOGOFF
;   Parameters:     none
;   Description:    logoff system and close logfile.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LOGOFF

    transmit "^M"
    waitfor "board Command" 120
    transmit "g^M"
    waitfor "no carrier" 20
    log close

endproc ; LOGOFF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
