;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script INCLUDE file
; written by  David R. McMillen
;
; This is an Aspect include file for all PCBoard scripts.  It contains all
; procedures common to PCBoard scripts.
;
;
;  History:
;
; 21-sep-91  converted to structured programming techniques.
; 24-sep-91  moved some routines to utility.inc
; 27-sep-91  fixed re-login sequence in LOGIN.
; 29-sep-91  changed LOADER to send esc twice.
; 09-oct-91  added when to GO_CONF and NEW_FILES, changed all
;            "when" statements to "when 2", initialize EL in LOGIN.
; 11-0ct-91  fixed MARKMAIL to timeout if nothing to download.
; 15-oct-91  changed LOADER waitfor string.
; 18-oct-91  changed MARKMAIL to upload replies before downloading
;            a new packet.
; 26-oct-91  added DATE_QWK to MARKMAIL, added waitfor
;            "board command?" in MARKMAIL to fix confusion with
;            "markmail command?".
; 29-oct-91  changed "command?" to "command" for some boards that
;            have different prompts, changed "board command?" to
;            "returning to bbs".
; 24-nov-91  changed "returning to bbs" to "returning to" in MARKMAIL.
; 27-nov-91  changed delay from 20 to 30 in MARKMAIL.
; 19-dec-91  added PROC_QWK to MARKMAIL.
; 11-jan-92  added CAMMAIL.
; 13-jan-92  added when to MARKMAIL.
; 18-jan-92  fixed CAMMAIL upload waitfors and timeouts.
; 26-jan-92  added response to password request at Markmail
;            exit.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LOADER
;   Parameters:     none
;   Description:    sends <esc> <esc> to skip loader delay.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LOADER

    waitfor "press esc" 20
    transmit "`033"
    transmit "`033"

endproc ; LOADER
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LANGUAGE
;   Parameters:     none
;   Description:    selects default language.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LANGUAGE

    waitfor "(Enter)=no change" 10
    transmit "^M"

endproc ; LANGUAGE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      NO_GRAPH
;   Parameters:     none
;   Description:    selects non-graphics mode.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc NO_GRAPH

    waitfor "(Enter)=no?" 10
    transmit "n^M"

endproc ; NO_GRAPH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LOGIN
;   Parameters:     with string1 string2 &string3
;   Description:    give name and password.
;   Returns:        error code if failure.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LOGIN

    strparm     FIRSTNAME, LASTNAME, EL

    EL = ""                              ; assume success
    waitfor "first name?" 10
    if waitfor
        transmit FIRSTNAME
        transmit "^M"

        waitfor "last name?"
        transmit LASTNAME
        transmit "^M"

        waitfor "will echo"
        transmit $D_PWORD                ; get it from the dialing directory

        waitfor "command" forever
    else
        EL = "error"                     ; indicate failure
    endif

endproc ; LOGIN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      GO_CONF
;   Parameters:     with string1
;   Description:    go to specified conference.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc GO_CONF

    strparm CONF
                                         ; don't scan message bases
    when 2 "Scan Message Base Since" transmit "n^M"

    transmit "^M"
    waitfor "command" forever
    transmit CONF
    transmit "^M"

    waitfor "command"
    cwhen 2                              ; clear response

endproc ; GO_CONF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      MARKMAIL
;   Parameters:     with string1 string2 string3
;   Description:    open markmail door, upload replies,
;                   get packet, close door, give password.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc MARKMAIL

    strparm DOOR
    strparm PACKET
    strparm REPLIES

    transmit "^M"                        ; enter mark mail door
    waitfor "command" forever
    when 1 "(C)ontinous?" transmit "c^M"
    transmit DOOR
    transmit "^M"
    waitfor "markmail command?" forever

    findfirst REPLIES                    ; upload message replies
    if FOUND                             ; if any
        transmit "^M"
        waitfor "markmail command?"
        transmit "u^M"
        waitfor "protocol type" 20
        strfmt S1 "zmodem %s" REPLIES
        dos S1
        delete REPLIES
    else
        message "^M^JNo replies packet to upload."
    endif
    transmit "^M"
    waitfor "markmail command?" forever

    delete "saved.qwk"                   ; get rid of old packets
    rename PACKET "saved.qwk"

    transmit "d^M"                       ; make and get new packet
    when 2 "Receive this Packet" transmit "y^M"
    waitfor "sorry, no messages" 30      ; no packet available?
    if waitfor
        message "^M^JNo packet to download."
    else
        waitfor "rz" forever
        dos "zmodem"                     ; run external zmodem
        call PROC_QWK with PACKET        ; process packet first
        call DATE_QWK with PACKET        ; date and save packet
    endif
    cwhen 1                              ; clear response
    when 2 "dots will echo" transmit $D_PWORD  ; give password if asked
    transmit "^M"
    waitfor "markmail command?" forever
    transmit "q^M"                       ; return to board
    waitfor "returning to" forever
    transmit "^M"
    waitfor "command" forever
    cwhen 2                              ; clear response

endproc ; MARKMAIL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      KMAIL
;   Parameters:     with string1 string2 string3
;   Description:    open kmail door, get packet, close door.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc KMAIL

    strparm DOOR
    strparm PACKET
    strparm REPLIES

    transmit "^M"                        ; enter kmail door
    waitfor "command" forever
    transmit DOOR
    transmit "^M"
    waitfor "command" forever

    delete "saved.qwk"                   ; get rid of old packets
    rename PACKET "saved.qwk"

    transmit "d^M"                       ; make and get packet
    waitfor "Receive this Packet" forever
    transmit "y^M"
    waitfor "rz" forever
    dos "zmodem"                         ; run external zmodem
    waitfor "command" forever

    findfirst REPLIES
    if FOUND
        transmit "^M"
        waitfor "command"               ; upload message replies
        transmit "u^M"                   ; if any
        waitfor "protocol type" 20
        strfmt S1 "zmodem %s" REPLIES
        dos S1
        delete REPLIES
    else
        message "^M^JNo replies packet to upload."
    endif

    transmit "^M"
    waitfor "command"                   ; return to pcboard
    transmit "q^M"

endproc ; KMAIL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      CAMMAIL
;   Parameters:     with string1 string2 string3
;   Description:    open cam-mail door, get packet, close door.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc CAMMAIL

    strparm DOOR
    strparm PACKET
    strparm REPLIES

    transmit "^M"                        ; enter mail door
    waitfor "command" forever
    transmit DOOR
    transmit "^M"
    waitfor "cam-mail command?" forever

    findfirst REPLIES                    ; upload message replies
    if FOUND                             ; if any
        transmit "^M"
        waitfor "cam-mail command?"
        transmit "u^M"
        waitfor "prepare to upload" 20
        strfmt S1 "zmodem %s" REPLIES
        dos S1
        delete REPLIES
    else
        message "^M^JNo replies packet to upload."
    endif
    transmit "^M"
    waitfor "cam-mail command?" forever

    delete "saved.qwk"                   ; get rid of old packets
    rename PACKET "saved.qwk"

    transmit "d^M"                       ; make and get new packet
    when 2 "Receive" transmit "y^M"
    waitfor "sorry, no messages" 20      ; no packet available?
    if waitfor
        message "^M^JNo packet to download."
    else
        waitfor "rz" forever
        dos "zmodem"                     ; run external zmodem
        call PROC_QWK with PACKET        ; process packet first
        call DATE_QWK with PACKET        ; date and save packet
    endif
    cwhen 2                              ; clear response
    transmit "^M"
    waitfor "cam-mail command?" forever
    transmit "q^M"                       ; return to board
    waitfor "thank you" forever

endproc ; CAMMAIL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      RZAMAIL
;   Parameters:     with string1
;   Description:    zip up all messages, download them, return to
;                   specified conference.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc RZAMAIL

    strparm CONF

    transmit "^M"                        ; look for, zip, and dnld new messages
    waitfor "command" forever           ; using zmodem batch file
    transmit "r z a^M"
    waitfor "compressing capture file" 10
    if waitfor
       waitfor "rz" forever              ; run external zmodem
       dos "zmodem"
    else
        message "^M^JTimed out, no packet was compressed."
    endif

    transmit "^M"
    waitfor "command" forever           ; go back to first conference
    transmit CONF                        ; when done
    transmit "^M"

endproc ; RZAMAIL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      NEW_FILES
;   Parameters:     none
;   Description:    scan the current conference for new files.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc NEW_FILES

    when 2 "More?" transmit "ns^M"       ; pass all screen pauses

    transmit "^M"
    waitfor "command" forever
    transmit "n^M"
    waitfor "enter)=?"                   ; use default date?
    transmit "^M"                        ; date format "mmddyy^M"
    waitfor "(Enter)=none?"              ; file areas?
    transmit "a^M"                       ; scan all

    waitfor "command" forever           ; clear response when done
    cwhen 2

endproc ; NEW_FILES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      FLAG_FILES
;   Parameters:     with string1
;   Description:    flag the specified files in the current conference.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc FLAG_FILES

    strparm DFILES

    transmit "^M"
    waitfor "command" forever
    transmit "flag "
    transmit DFILES
    transmit "^M"

endproc ; FLAG_FILES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      DOWNLOAD
;   Parameters:     with string1
;   Description:    download all flagged files (using the specified
;                   password if requested).
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc DOWNLOAD

    strparm DLPASSWD

    transmit "^M"
    waitfor "command" forever
    when 2 "password" transmit DLPASSWD      ; give download password if asked
    transmit "db^M"
    waitfor "download flagged files" 10      ; did we flag any?
    if waitfor
        transmit "^M"                        ; yes, lets get 'em
        waitfor "filename to download" forever  ; additional files?
        transmit "^M"                        ; none
        waitfor "(Enter)=continue?" 10       ; action after completion?
        if waitfor
            transmit "^M"                    ; no goodbye at completion
            waitfor "rz" forever
            dos "zmodem"                     ; run external zmodem
        else
            message "^M^JTimed out waiting for action after download prompt."
            transmit "^M"                    ; not enough time for download
        endif
    else
        message "^M^JTimed out waiting for download flagged files prompt."
        transmit "^M"                        ; no files were flagged previously
    endif
    cwhen 2                                  ; clear download password

endproc ; DOWNLOAD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      UPLOAD
;   Parameters:     with string1 string2
;   Description:    upload specified file using specified description.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc UPLOAD

    strparm UFILE
    strparm UDESC

    transmit "^M"
    waitfor "command" forever
    transmit "u "                        ; send filename
    transmit UFILE
    transmit "^M"
    waitfor "maximum" 20                 ; description?
    if waitfor
        transmit UDESC                   ; send description
        transmit "^M^M"
        waitfor "protocol type" 20
        strfmt S1 "zmodem %s" UFILE      ; send file
        dos S1
    else
        message "^M^JTimed out waiting for prompt for file description."
        transmit "^M"
    endif

endproc ; UPLOAD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      LOGOFF
;   Parameters:     none
;   Description:    logoff system and close logfile.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc LOGOFF

    transmit "^M"
    waitfor "command" forever
    transmit "g^M"
    waitfor "NO CARRIER" 20
    log close

endproc ; LOGOFF
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
