;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;
;
;  History:
;
; 26-jan-92  Original version.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Modem "Practical Peripherals PM9600SA V.32"
;
; 1.    set up modem as per procomm+ v2.01
; 2.    set inactivity disconnect timer
; 3.    set speaker volume level
; 4.    disable MNP 5
;
;
proc main

   message  "^M^J^M^J"
   message  "Now configuring Practical Peripherals PM9600SA V.32 modem..."
   message  "^M^J^M^J"

   transmit "AT^M"                       ; hello?
   waitfor  "ok"
   transmit "ATZ^M"                      ; soft reset
   waitfor  "ok"
   transmit "AT&F^M"                     ; restore factory defaults
   waitfor  "ok"
   transmit "AT&C1^M"                    ; CD
   waitfor  "ok"
   transmit "AT&D2^M"                    ; DTR
   waitfor  "ok"
   transmit "ATS7=60^M"                  ; wait for carrier after dial
   waitfor  "ok"
   transmit "ATS11=55^M"                 ; DTMF dialing speed (may cause
                                         ;   problems with some phone
                                         ;   systems?)
   waitfor  "ok"
   transmit "ATS95=44^M"                 ; extended connect messages
   waitfor  "ok"
   transmit "ATS30=60^M"                 ; inactivity timeout 10 min
   waitfor  "ok"
   transmit "ATL1^M"                     ; speaker volume setting
   waitfor  "ok"
   transmit "ATS46=136^M"                ; disable MNP 5
   waitfor  "ok"
   transmit "AT&W0^M"                    ; save settings at location 0
   waitfor  "ok"
   transmit "AT&Y0^M"                    ; set default settings to location 0
   waitfor  "ok"
   transmit "AT&V^M"                     ; show configuration
   waitfor  "ok"

endproc ; main
