;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: Practical Peripherals Support
; Software: Wildcat
;     Mode: Automatic
;
;
;  History:
;
; 26-jan-92  Original version.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   This script assumes that the user has the batch file ZMODEM.BAT and
;   Procomm+'s zmodem autodownload option is off.
;
;   The user must edit the string declarations in this file
;   prior to the first use.
;
;   The user must also have their password saved in the dialing directory.
;
;   This script will perform the following actions depending on how the
;   user has edited this file.
;
;   1.  Upload reply packet if it exists, then delete it.
;
;   2.  Read message bases and new files through Tomcat.
;
;   3.  Log off.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include "utility.inc"                    ; include common Aspect procedures

proc MAIN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  STRING VARIABLE DECLARATIONS
;;;
;;;  re-edit for each board
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

string FIRSTNAME = "david"               ; your first name
string LASTNAME  = "mcmillen"            ; your last name

string PACKET    = "ppibbs.qwk"          ; name of message packet file
string REPLIES   = "ppibbs.rep"          ; name of message reply file

string CON_RATE  = "9600"                ; connect rate for DSZ estimates


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  BOARD SPECIFIC PROCEDURE
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

when 0 "onStop:" transmit "n"            ; pass all screen pauses
when 1 "to continue" transmit "^M"       ; insure eXpert mode is on
when 2 "bulletin menu" transmit "n"      ; don't scan message bases

call OPEN_LOG                            ; open the log file

waitfor "first name?"
transmit FIRSTNAME
transmit "^M"

waitfor "last name?"
transmit LASTNAME
transmit "^M"

waitfor "password"
transmit $D_PWORD                        ; get it from the dialing directory

waitfor "enter command" forever

cwhen 0                                  ; clear responses
cwhen 1
cwhen 2

call SET_CONNECT with CON_RATE           ; set rate for DSZ estimates

transmit "d"
waitfor "door number"
pause 1
transmit "1^M"
waitfor "tomcat menu"

findfirst REPLIES                        ; upload message replies
if FOUND                                 ; if any
    transmit "u^M"
    waitfor "zmodem" 20
    strfmt S1 "zmodem %s" REPLIES
    dos S1
    waitfor "tomcat menu"
    delete REPLIES
else
    message "^M^JNo replies packet to upload."
endif

transmit "d^M"                           ; make and get new packet
when 2 "Receive this Packet" transmit "g^M"
waitfor "sorry, no messages" 30          ; no packet available?
if waitfor
    message "^M^JNo packet to download."
else
    waitfor "zmodem" forever
    dos "zmodem"                         ; run external zmodem
    call PROC_QWK with PACKET            ; process packet first
    call DATE_QWK with PACKET            ; date and save packet
endif
cwhen 2                                  ; clear response

waitfor "hang up" forever
transmit "h^M"
hangup
quit                                     ; exit Procomm+

endproc ; MAIN
