;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: SBCC
; Software: TBBS
;     Mode: Automatic
;
;
; History:
;
; 08-mar-90  Original version
; 26-mar-90  added for sale message section read
; 07-aug-90  added some pauses
; 06-feb-91  converted to pcplus v2
; 11-feb-91  changed to script logfile delete, changed login
; 19-feb-91  added when for press any key at start
; 20-may-91  added quit at end, removed old logfile delete
; 14-aug-91  resolved -press conflict
; 25-sep-91  added include for UTILITY.INC.
; 07-oct-91  added ability to do DSZ estimates according to each
;            boards expected connect rate.
; 10-oct-91  added pause at end to allow user to abort the logoff.
; 11-oct-91  added response for personal messages during new message
;            reads.
; 16-oct-91  changed logfile name to mmddyy.log, made pause at end more
;            visible, stop file scan after 10 secs or less.
; 24-oct-91  changed DATED_LOG to DATE_LOG.
;
;
; Comments:
;
; Get all new general and for sale messages, scan new files, then log off.
;
;
include "utility.inc"                    ; include common aspect procedures

proc MAIN

log close                                ; close any prior log
transmit "^M"
waitfor "FULL Name?" forever             ; log on now...
strfmt S0 "david mcmillen;%s" $D_PWORD   ; name;password^M
transmit S0                              ; Send name and password

when 0 "-more-" transmit "^M"
when 1 "-press" transmit "^M"
when 2 "Reply to this msg" transmit "n^M"

call DATE_LOG                            ; open a log file
; call OPEN_LOG                          ; open a log file
call SET_CONNECT with "2400"             ; set rate for DSZ estimates

waitfor "waiting" 5                      ; skip any personal messages...
if waitfor
   pause 1
   transmit "n^M"                        ; change "n^M" to "y^M" if you
endif                                    ; want to respond to personal
                                         ; messages here

transmit "^M"
waitfor "User's Guide" forever      ; set expert mode to 3 (no menus)...
transmit "ux3m"                     ; <U>til e<X>pert <3> no menus <M>ain menu

waitfor "Command:" forever          ; go look for new files...
transmit "f4d"                      ; <F>iles <4>IBM <D>ownload
waitfor "Select File Area" forever
transmit "^M"                       ; <^M> file area 1

waitfor "<CR> To Exit:" 10          ; leave file section in 10 sec or less...
if waitfor
    transmit "^Mm"                  ; <^M> exit files <M>ain menu
else
    transmit "s"                    ; stop file scan
    waitfor "<CR> To Exit:"         ; leave file section
    transmit "^Mm"                  ; <^M> exit files <M>ain menu
endif

waitfor "Command:" forever          ; go get all new general interest messages...
transmit "mmrnn"                    ; <M>essages <M>sgs. general <R>ead
waitfor "Command:" forever          ; <N>ew <N>o pause
transmit "m"                        ; <M>ain menu

waitfor "Command:" forever          ; go get all new for sale messages...
transmit "mfrnn"                    ; <M>essages <F>or sale <R>ead
waitfor "Command:" forever          ; <N>ew <N>o pause
transmit "m"                        ; <M>ain menu

waitfor "Command:" forever          ; set expert mode back to 0 (beginner)...
transmit "ux0m"                     ; <U>til e<X>pert <0> all menus <M>ain menu


waitfor "User's Guide" forever           ; log off...

message "^M^J^M^J"
fatsay $ROW $COL $TERMNORM "Press <esc> to abort logoff..."
call CPAUSE with 10                      ; countdown 10 seconds

transmit "gy^M"
waitfor "NO CARRIER"
log close                                ; close log file
quit                                     ; exit procomm+

endproc ; MAIN
