;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: Seaside
; Software: GAP
;     Mode: Manual
;
;
;  History:
;
;  08-aug-91  original version.
;  05-sep-91  fixed for updated GAP.ASI file.
;  27-sep-91  rewritten using structured programming techniques.
;  09-oct-91  added ability to do DSZ estimates according to each
;             boards expected connect rate, changed EL to S0.
;
;
;
; Comments:
;
;   The user must also have their password saved in the dialing directory.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include "utility.inc"                    ; include common Aspect procedures
include "gap.inc"                        ; include GAP procedures

proc MAIN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                         ;;;
;;;  STRING VARIABLE DECLARATIONS           ;;;
;;;                                         ;;;
;;;  re-edit for each board                 ;;;
;;;                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

string WANTGRAF  = "n"                   ; want graphics?: "n" or ""

string FIRSTNAME = "david"               ; your first name
string LASTNAME  = "mcmillen"            ; your last name
string CON_RATE  = "2400"                ; connect rate for DSZ estimates


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  BOARD SPECIFIC PROCEDURE
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

when 0 "To Continue" transmit "^M"
when 1 "[c]ont" transmit "c^M"
when 2 "bulletin read" transmit "^M"

call OPEN_LOG                            ; open the log file

if not null WANTGRAF                     ; use non graphics mode?
    call NO_GRAPH
endif

call LOGIN with FIRSTNAME LASTNAME &S0   ; login to system
cwhen 2                                  ; clear bulletin responses

call SET_CONNECT with CON_RATE           ; set rate for DSZ estimates

endproc ; MAIN
