;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;    Board: Seaside
; Software: GAP
;     Mode: Automatic
;
;
;  History:
;
;  08-aug-91  original version.
;  05-sep-91  fixed for updated GAP.ASI file.
;  27-sep-91  rewritten using structured programming techniques.
;  09-oct-91  added ability to do DSZ estimates according to each
;             boards expected connect rate, changed EL to S0.
;
;
;
; Comments:
;
;   This script assumes that the user has the batch file ZMODEM.BAT and
;   Procomm+'s zmodem autodownload option is off.
;
;   The user must also have their password saved in the dialing directory.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include "utility.inc"                    ; include common Aspect procedures
include "gap.inc"                        ; include GAP procedures

proc MAIN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                         ;;;
;;;  STRING VARIABLE DECLARATIONS           ;;;
;;;                                         ;;;
;;;  re-edit for each logon                 ;;;
;;;                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                                         ; file(s) to download ("" = none)
                                         ; format: "file1.ext^Mfile2.ext^M"
string DFILES    = ""

string UFILE1    = ""
; first file to upload ("" = none)
string UFILE1D   = ""
;                  [---------------------------------------------]
; description of first file to upload

string UFILE2    = ""
; second file to upload ("" = none)
string UFILE2D   = ""
;                  [---------------------------------------------]
; description of second file to upload


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                         ;;;
;;;  STRING VARIABLE DECLARATIONS           ;;;
;;;                                         ;;;
;;;  re-edit for each board                 ;;;
;;;                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

string WANTGRAF  = "n"                   ; want graphics?: "n" or ""

string FIRSTNAME = "david"               ; your first name
string LASTNAME  = "mcmillen"            ; your last name

string READER    = "markmail"            ; mail reader?: "markmail", "kmail",
                                         ; "rza" or "none"
string READERCMD = "door markmail"       ; command to open reader door (if any)
string PACKET    = "seaside.qwk"         ; name of message packet file
string REPLIES   = "seaside.rep"         ; name of message reply file
string CON_RATE  = "2400"                ; connect rate for DSZ estimates


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  BOARD SPECIFIC PROCEDURE
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

when 0 "To Continue" transmit "^M"
when 1 "[c]ont" transmit "c^M"
when 2 "bulletin read" transmit "^M"

call OPEN_LOG                            ; open the log file

try_again:

if not null WANTGRAF                     ; use non graphics mode?
    call NO_GRAPH
endif

call LOGIN with FIRSTNAME LASTNAME &S0   ; login to system
if not null S0
    call RE_DIAL                         ; re-login on failure
    goto try_again
endif
cwhen 1                                  ; clear continue responses
cwhen 2                                  ; clear bulletin responses

call SET_CONNECT with CON_RATE           ; set rate for DSZ estimates

switch READER                            ; read new mail, scan for new files
    case "markmail"
        call MARKMAIL with READERCMD PACKET REPLIES
    endcase
endswitch

if not null DFILES                       ; download file(s)
    call DOWNLOAD with DFILES
endif

if not null UFILE1                       ; upload file(s)
    call UPLOAD with UFILE1 UFILE1D
    if not null UFILE2
        call UPLOAD with UFILE2 UFILE2D
    endif
endif

call LOGOFF                              ; logoff

quit                                     ; exit Procomm+

endproc ; MAIN
