;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script file
; written by  David R. McMillen
;
;  History:
;
; 11-nov-91  added dialing dir popup
; 09-dec-91  changed startup dir
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This script:
;
;   1.  Checks to see that the modem is powered up.
;   2.  Sets the default directory as defined.
;   3.  Loads the defined dialing directory.
;   4.  Pops up the dialing screen.
;   5.  Properly runs the linked script only if connected.
;       (Does not seem to run the script if under Desqview?)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; define  DEBUG 1                          ; define for debug messages

include "utility.inc"

string  MYDIR   = "c:\bbs\xfer"          ; directory to start up in
string  MYDDIR  = "home"                 ; dialing directory to load

proc main

try_again:
    termkey 0x2400                       ; alt-j to init modem
    waitfor "ok" 5                       ; wait for modem to initialize
    if not waitfor
        message "Turn your modem on!"
        call CPAUSE with 2
        goto try_again
    else
        chdir MYDIR                      ; go to default directory
        dload MYDDIR                     ; load default dialing directory
        termkey 0x2000                   ; pop up the dialing directory
        if connected
            $ifdef DEBUG
                strfmt S0 "^M^JConnected and executing script:  %s" $d_script
                message S0
                call CPAUSE with 2
            $endif
            execute $d_script            ; execute the linked script
        endif
    endif

endproc ; main
