;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROCOMM PLUS ASPECT script INCLUDE file
; written by  David R. McMillen
;
; This is an Aspect include file for common routines used by any or
; all scripts.
;
;
;  History:
;
; 21-sep-91  converted to structured programming techniques.
; 25-sep-91  changed OPEN_LOG to not allow a path to be specified,
;            added MIL2LONG routine.
; 09-oct-91  added SET_CONNECT, CALL_BY_NAME, CPAUSE and GET_FNAME,
;            changed RE_DIAL to use CPAUSE.
; 15-oct-91  added DATED_LOG, changed display and border in OPEN_LOG.
; 24-oct-91  added DATE_QWK, changed DATED_LOG to DATE_LOG.
; 09-dec-91  changed pathnames.
; 19-dec-91  added PROC_QWK.
;
;
;  Routines:
;
; CALL_BY_NAME  Call the first dialing directory entry in which
;               the specified string is a part of the name field.
;
; CPAUSE        Pauses for the number of seconds specified while
;               displaying a second by second countdown.  Max
;               delay is 99 seconds.
;
; DATE_LOG      Opens a new logfile named mmddyy.log.
;
; DATE_QWK      Moves specified packet file to QWK directory
;               and renames it xxmmdd_v.qwk where xx = first
;               two chars of packet filename, mmdd = date,
;               v = version for each date.
;
; GET_FNAME     Prompts the user for a filename or CR for none.
;
; MIL2LONG      Converts military time string into long int
;               number of seconds past midnight.
;
; OPEN_LOG      Open a logfile using the calling scripts name
;               as the logfile name.
;
; PROC_QWK      Replaces welcome banner with local file if
;               present.
;
; RE_DIAL       Redial dialing directory entry last connected to.
;
; SET_CONNECT   Sets the environment variable "DSZCON" to the
;               specified string.
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      CALL_BY_NAME
;   Parameters:     with string1 &string2
;   Description:    call the first dialing directory entry in which
;                   the specified string is a part of the name field.
;   Returns:        errorllevel = null if success
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc CALL_BY_NAME

    strparm     NAME
    strparm     EL

    EL = "1"                             ; assume failure
    strfmt S0 "^M^JLooking for dialing directory entry `"%s`"..." NAME
    message S0
    for N0=1 upto 200
        set dialentry N0                 ; look for name match
        find $D_NAME NAME
        if found
            EL = ""                      ; found it, set success
            strfmt S0 "^M^JEntry found at `"%d`"." N0
            message S0
            itoa N0 S0                   ; dial it
            dial S0
            exitfor
        endif
    endfor

endproc ; CALL_BY_NAME
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      CPAUSE
;   Parameters:     with integer
;   Description:    pauses for the number of seconds specified while
;                   displaying a second by second countdown.  Max
;                   delay is 99 seconds.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc CPAUSE

    intparm     SECS

    message ""                           ; new line

    integer     ATR = $TERMNORM          ; color for display
    integer     ROW = $ROW               ; location for display
    integer     COL = $COL

    if SECS > 99                         ; truncate to 99 seconds maximum
        SECS = 99
    endif

    for N0=SECS downto 0                 ; begin countdown
        fatsay ROW COL ATR "Paused for %2d seconds..." N0
        pause 1
    endfor
    message ""                           ; new line

endproc ; CPAUSE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      DATE_LOG
;   Parameters:     none
;   Description:    opens a new logfile named mmddyy.log.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc DATE_LOG

    log close

    substr S0 $DATE 0 2                  ; get month
    substr S1 $DATE 3 2                  ; get day
    substr S2 $DATE 6 2                  ; get year
    strfmt S3 "c:\bbs\logs\%s%s%s.log" S0 S1 S2
    log open S3
                                         ; timestamp the logfile
    message   "^M^J^M^J^M^J^M^J"
    strfmt S0 "Logfile name:  %s" S3
    message S0
    strfmt S0 "Connected to:  %s" $D_NAME
    message S0
    strfmt S0 "        Date:  %s" $DATE
    message S0
    strfmt S0 "        Time:  %s" $TIME0
    message S0
    message   "^M^J^M^J^M^J^M^J"

endproc ; DATE_LOG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      DATE_QWK
;   Parameters:     with string1
;   Description:    moves specified packet file to QWK directory
;                   and renames it xxmmdd_v.qwk where xx = first
;                   two chars of packet filename, mmdd = date,
;                   v = version for each date.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc DATE_QWK

    strparm PACKET                       ; original packet filename
    string NEWNAME, OLDNAME = ""
    string QWKPATH = "c:\bbs\qwk"

    strfmt OLDNAME "%s\%s" QWKPATH PACKET      ; check for existing packet
    findfirst OLDNAME
    if not found
        strfmt S0 "copy %s %s" PACKET QWKPATH  ; move packet to directory
        dos S0
        delete PACKET
        substr S0 PACKET 0 2             ; get xx from packet filename
        substr S1 $DATE 0 2              ; get month
        substr S2 $DATE 3 2              ; get day
        strfmt NEWNAME "%s\%s%s%s_0.qwk" QWKPATH S0 S1 S2  ; new dated filename

        findfirst NEWNAME                ; don't overwrite a file
        if found
            for N0 = 1 upto 9
                message "Bumping QWK file version."
                strfmt NEWNAME "%s\%s%s%s_%d.qwk" QWKPATH S0 S1 S2 N0
                findfirst NEWNAME
                if not found             ; rename packet to dated filename
                    rename OLDNAME NEWNAME
                    message "Packet file successfully renamed."
                    exitfor
                else
                    if N0 >= 9
                        message "ERROR, too many packets today, goto sleep!"
                    endif
                endif
            endfor
        else
            rename OLDNAME NEWNAME       ; rename packet to dated filename
            message "Packet file successfully renamed."
        endif
    else
        message "ERROR, packet exists in target directory!"
    endif

endproc ; DATE_QWK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      GET_FNAME
;   Parameters:     with &string1
;   Description:    prompts the user for a filename or CR for none.
;   Returns:        filename or null if none.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc GET_FNAME

    strparm     FNAME

get3289:
    message "^M^JEnter filename (enter=none)..."
    get FNAME 13
    if not null FNAME                    ; check for filename entered
        isfile FNAME                     ; check for valid filename
        if not success
           strfmt S0 "^M^JERROR, file `"%s`" does not exist!" FNAME
           message S0
           goto get3289
        else
        endif
    else
        message "^M^JNo file specified."
    endif

endproc ; GET_FNAME
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      MIL2LONG
;   Parameters:     with string1 &long
;   Description:    Converts military time string into long int
;                   number of seconds past midnight.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc MIL2LONG

    strparm     MTIME
    longparm    SECONDS
    long        MTEMP   = 0

    substr      S0 MTIME 0 2             ; first convert hours to seconds
    atoi        S0 N0
    MTEMP       = N0                     ; convert int to long!
    SECONDS     = MTEMP * 60 * 60

    substr      S0 MTIME 3 2             ; now get minutes, convert to
    atoi        S0 N0                    ; seconds and add them in
    MTEMP       = N0
    SECONDS     = SECONDS + ( MTEMP * 60 )

    substr      S0 MTIME 6 2             ; now add in the seconds
    atoi        S0 N0
    MTEMP       = N0
    SECONDS     = SECONDS + MTEMP

endproc ; MIL2LONG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      OPEN_LOG
;   Parameters:     none
;   Description:    opens and timestamps a new logfile.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc OPEN_LOG

    log close                            ; set logfile to "script_filename.log"

    strfmt S3 "c:\bbs\logs\%s.log" $D_SCRIPT
    log open S3
                                         ; timestamp the logfile
    message   "^M^J^M^J^M^J^M^J"
    strfmt S0 "Logfile name:  %s" S3
    message S0
    strfmt S0 "Connected to:  %s" $D_NAME
    message S0
    strfmt S0 "        Date:  %s" $DATE
    message S0
    strfmt S0 "        Time:  %s" $TIME0
    message S0
    message   "^M^J^M^J^M^J^M^J"

endproc ; OPEN_LOG
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      PROC_QWK
;   Parameters:     with string1
;   Description:    Replaces welcome banner with local file if
;                   present.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc PROC_QWK

    strparm PACKET                       ; original packet filename

    findfirst "welcome"                  ; look for new welcome banner
    if found                             ; put it in if found
        strfmt S0 "pkzip -a %s welcome" PACKET
        dos S0
    else
        message "No welcome packet to add in."
    endif

endproc ; PROC_QWK
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      RE_DIAL
;   Parameters:     none
;   Description:    redials the last dialing directory entry
;                   connected to.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc RE_DIAL

    hangup                               ; insure we are hung up
    message "^M^J^M^J"                   ; tell user what we are doing
    message "Ŀ"
    message "                                                    "
    message "   Login aborted due to abnormal connect to host!   "
    message "                                                    "
    message "   Will now attempt to redial host                  "
    message "                                                    "
    message "   Press <esc> to abort...                          "
    message "                                                    "
    message "^M^J^M^J"
    call CPAUSE with 4
    itoa $D_ENTRY S0                     ; get last connected dial dir entry
    dial S0                              ; dial it

endproc ; RE_DIAL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   Procedure:      SET_CONNECT
;   Parameters:     with string1
;   Description:    sets the environment variable "DSZCON" to the
;                   specified string.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SET_CONNECT

    strparm     CRATE

    getenv "dszcon" S0                   ; get current value

    strfmt S1 "dszcon=%s" CRATE          ; set to new value
    putenv S1

    getenv "dszcon" S1                   ; check it and display it
    strfmt S2 "^M^JDSZCON was: %s, Now: %s." S0 S1
    message S2

endproc ; SET_CONNECT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
