#include <dir.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>



int leapyear(int year){
	if(year % 4 == 0 && year % 100 != 0 || year % 400 ==0)
		return 1;
	else
		return 0;
}


int julian(int day, int month, int year){
	static int runsum[]={0, 31, 59, 90, 120, 151, 181, 212,
			     243, 273, 304, 334, 365};
	int total;
	total=runsum[month-1]+day;
	if(month>2){
		total+=leapyear(year);
	}
	return(total);
}

void get_Date( int *day, int *month, int *year){
	union REGS ireg;

	ireg.h.ah=0x2a;
	intdos(&ireg,&ireg);
	*day=ireg.h.dl;
	*month=ireg.h.dh;
	*year=ireg.x.cx-1900;
}

void calc_DateTime(int *sec, int *min,   int *hour, int time,
		   int *day, int *month, int *year, int date  ){

	*sec  = (time & 0x1f   ) *  2;
	*min  = (time & 0x7e0  ) >> 0x05;
	*hour = (time & 0xf800 ) >> 0x0b;

	*day  =  date & 0x1f;
	*month= (date & 0x1e0)  >> 0x05;
	*year = (date & 0xfe00) >> 0x09;

	if(*hour>12) *hour-=12;
	*year+=80;
}


unsigned int datecmp(int d1, int m1, int y1, int d2, int m2, int y2){
	int i, max, min, t1, t2, years=0;

	t1=julian(d1,m1,y1);
	t2=julian(d2,m2,y2);

	if(y1 !=y2){                             /* Must go across years  */
		if(y1 > y2){
			max=y1;
			min=y2;
			t2=julian(31,12,y2)-t2;  /* Days to end of year  */
		} else {
			max=y2;
			min=y1;
			t1=julian(31,12,y2)-t1;
		}
		for(i=max;i>min+1;i--) {           /* For all years  */
			years+=365+leapyear(i);
		}
	} else {
		t1=julian(d1,m1,y1);
		t2=julian(d2,m2,y2);
		return(abs(t1-t2));
	}
	return(t1+t2+years);
}


void process(unsigned time, unsigned date, long size, char *name,
	       int numdays, char *batchfile){

	char scrnbuffer[4000];
	char BatchBuffer[80];
	unsigned int DT;
	int x,y;
	int sec,min,hour;
	int fday,fmonth,fyear;
	int  day, month, year;

	get_Date(&day, &month, &year);

	calc_DateTime( &sec,  &min  ,  &hour, time ,
		      &fday, &fmonth, &fyear, date );


	DT=datecmp(day,month,year, fday,fmonth,fyear);

	textcolor(LIGHTCYAN);

	cprintf("%13s   %02d:%02d:%02d  %02d-%02d-%02d  %6ld  ",
		name,
		hour,min,sec,
		fmonth,fday,fyear,
		size);

	if(DT > numdays){
		textcolor(GREEN);
		cprintf("%c   %03d\r\n",'M',DT);
		sprintf(BatchBuffer,"%s %s %d",batchfile,name,DT);

		x=wherex();
		y=wherey();
		gettext(1,1,80,24,scrnbuffer);

		system(BatchBuffer);

		puttext(1,1,80,24,scrnbuffer);
		gotoxy(x,y);

	} else {
		textcolor(YELLOW);
		cprintf("%c   %03d\r\n",251,DT);
	}
	textcolor(LIGHTGRAY);
}

void show_instructions(){
	char *str=
	"\nUsage: PROCESS numdays execute_file\n\n";

	printf("%s",str);
	exit(1);
}

int extension_check(char *fn){
	char *ptr,*ptr1,*ptr2;
	strupr(fn);
	ptr  = (char*) strstr(fn,".EXE");
	ptr1 = (char*) strstr(fn,".COM");
	ptr2 = (char*) strstr(fn,".BAT");
	if ( ptr!=NULL || ptr1!=NULL || ptr2!=NULL )
		return 0;
	else
		return -1;
}
main(int argc, char *argv[]){
	int numdays;
	struct ffblk f;
	register int done;

	clrscr();

	numdays=atoi(argv[1]);

	if(argc<3) show_instructions();

	if(numdays<1) show_instructions();

	if((access(argv[2],0))==-1){
		if((searchpath(argv[2]))==NULL) {
			printf("\a\nCould not find the file %s\n",strupr(argv[2]));
			show_instructions();
		}
	}

	if(extension_check(argv[2])==-1){
		printf("\a\nYou must specify a .BAT, .COM, or .EXE file!\n");
		show_instructions();
	}


	done=findfirst("*.*",&f,0);
	if(!done){
		textcolor(WHITE);
		cprintf("FILE PROCESSOR UTILITY, Ver 1.0\r\n\n");
		cprintf("Files older than %d days will be processed by %s\r\n\n",numdays,strupr(argv[2]));
		cprintf(" Filename         Time      Date     Size       Day\r\n");
		cprintf("=============   ========  ========  ======  =   ===\r\n");
	}

	while(!done){
		process(f.ff_ftime,f.ff_fdate,f.ff_fsize,f.ff_name,numdays,argv[2]);
		done=findnext(&f);
	}
}