'+--------------------------[ Set-User Ver 1.00 ]----------------------------+
'|  Written By Gary Meeker 06/07/92                        Updated   /  /    |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                 300/1200/2400/9600 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'V1.00  06/07/92 - Initial release
'-----------------------------------------------------------------------------

DEFINT A-Z

'  P.D.Q. Declarations
DECLARE FUNCTION PDQExist% (FileSpec$)
DECLARE FUNCTION PDQParse$ (Work$)
DECLARE FUNCTION PDQValI% (Number$)
DECLARE SUB CritErrOff ()
DECLARE SUB CritErrOn ()
DECLARE SUB SetDelimitChar (Char)
DECLARE SUB PDQRestore()

'   QuickPack Declarations
DECLARE FUNCTION ASCII% (Work$)
DECLARE SUB SetLevel (ErrLevel%)
DECLARE SUB FCopy (Source$, Dest$, Buffer$, ErrCode%)

'   Local Declarations
DECLARE SUB GetParameter(Parameter$, Flag)
DECLARE SUB InputOption(FileNo, Flag)
DECLARE SUB Check4File(FileName$)

' Myown Declarations
DECLARE SUB DelChar (Target$, Position, Char$)

' $INCLUDE: 'PCBTYPES.INC'

DIM USERSYS AS USERSSYSRECORD
DIM User14 AS User14Record, Buffer AS STRING * 8192

C$ = UCASE$(COMMAND$)
IF Len(C$) = 0 THEN
   PRINT "Syntax: Set-User PCBDir  ConfigFile  [/Q] [/P] [/S] [/U] [/L] [/C]"
   PRINT
   PRINT "Where:     PCBDir = Drive:\Path to USERS.SYS file"
   PRINT "       ConfigFile = Drive:\Path\FileName.Ext of Configuration File"
   PRINT
   PRINT "[/Q] = Quiet"
   PRINT "[/P] = Set Level to Password in PWRD File"
   PRINT "[/S] = Adjust Only USERS.SYS File if USERS file SecLevel is higher"
   PRINT "[/U] = Adjust Only USERS File if USERS.SYS file SecLevel is higher"
   PRINT "       If neither /S or /U then adjust to the higher of the two"
   PRINT "[/L] = Use the lower level"
   PRINT "[/C] = Clear Update status in USERS.SYS if USERS is changed"
   END
END IF

CritErrOff
UserLen   = LEN(User14)
SetDelimitChar 32

GetParameter "/Q", Quiet
GetParameter "/U", SetUserOnly
GetParameter "/S", SetSysOnly
GetParameter "/P", PasswordSet
GetParameter "/L", UseLower
GetParameter "/C", ClearStatus

PCBDir$ = PDQParse$(C$)        'Get the PCBOARD.SYS location from Command Line
ConfigFile$ = PDQParse$(C$)    'Get config file from command line
IF RIGHT$(PCBDir$, 1) <> "\" THEN PCBDir$ = PCBDir$ + "\"
SysFile$ = PCBDir$ + "USERS.SYS"
DoorTextFile$ = PCBDir$ + "PCBDOOR.TXT"

Check4File ConfigFile$         ' Make sure they exist
Check4File SysFile$

IF Quiet = 0 THEN
    PRINT "Set-User 1.00....Checking "; CHR$(34); SysFile$; CHR$(34)
END IF

OPEN ConfigFile$ FOR INPUT AS #1
   LINE INPUT #1, UserFile$
   LINE INPUT #1, PwrdFile$
   LINE INPUT #1, TextFile$
   LINE INPUT #1, A$
   SecLimit = PDQValI(A$)
   InputOption 1, SetExpLevel
CLOSE #1

Check4File UserFile$           ' Make sure these exist too
Check4File PwrdFile$

OPEN SysFile$ FOR BINARY AS #1
   GET #1,, USERSYS
   IF Quiet = 0 THEN PRINT "User: "; USERSYS.UserName$
OPEN UserFile$ FOR RANDOM ACCESS READ WRITE SHARED AS #2 LEN = UserLen
   IF ERR THEN PRINT : PRINT "Error Occured Opening Users File - ("; ERR; ")"
   GET #2, USERSYS.RecNo, User14
   IF ERR THEN PRINT : PRINT "Error Occured Reading Users File - ("; ERR; ")"
   SecLevel = ASC(User14.SecLevel$)
   IF PasswordSet THEN
      OPEN PwrdFile$ FOR INPUT AS #3
         SetDelimitChar 44                 ' Set to ','
         TestPassword$ = RTRIM$(USERSYS.Password$)
         DO
            LINE INPUT #3, A$
            PDQRestore
            Password$ = RTRIM$(PDQParse$(A$))
            IF LEN(Password$) > 0 AND Password$ = TestPassword$ THEN
               GOSUB SetUserLevel
               EXIT DO
            END IF
         LOOP
      CLOSE #3
   ELSEIF USERSYS.SecLevel <> SecLevel THEN
      IF UseLower XOR USERSYS.SecLevel < SecLevel THEN
         IF NOT SetUserOnly THEN GOSUB UpdateUserSys
      ELSE
         IF NOT SetSysOnly THEN GOSUB UpdateUserFile
      END IF
   END IF
CLOSE

CritErrOn

IF ErrorLevel <> 0 THEN
   SetLevel SecLevel
END IF

END

SetUserLevel:
   SecLevel = PDQValI(PDQParse$(A$))
   IF SecLevel <= SecLimit THEN
      IF SetExpLevel THEN
         USERSYS.ExpSecLevel = SecLevel
      END IF
      GOSUB UpdateUserSys
      ErrorLevel = SecLevel
      IF LEN(TextFile$) > 0 THEN
          Buffer$ = STRING$(2048, 0)
          FCopy TextFile$, DoorTextFile$, Buffer$, ErrCode%
      END IF
   END IF
RETURN

UpdateUserSys:
   USERSYS.SecLevel = SecLevel
   USERSYS.Updated$ = CHR$(1)
   USERSYS.PackedFlags$ = CHR$(ASCII(USERSYS.PackedFlags$) OR &h01)
   PUT #1, 1, USERSYS
   IF Quiet = 0 THEN PRINT "USERS.SYS Security Level raised to"; Seclevel
RETURN

UpdateUserFile:
   User14.SecLevel$ = CHR$(USERSYS.SecLevel)
   PUT #2, USERSYS.RecNo, User14
   IF ERR THEN PRINT : PRINT "Error Occured Reading Users File - ("; ERR; ")"
   IF ClearStatus THEN
      USERSYS.Updated$ = CHR$(0)
      USERSYS.PackedFlags$ = CHR$(ASCII(USERSYS.PackedFlags$) AND &hFE)
      PUT #1, 1, USERSYS
   END IF
   IF Quiet = 0 THEN PRINT "USERS Security Level raised to"; USERSYS.Seclevel
RETURN

SUB GetParameter(Parameter$, Par) STATIC
   SHARED C$, Value$
   StrLen = LEN(Parameter$)
   Flag = INSTR(C$, Parameter$)
   IF Flag THEN                                   ' Was Parameter present?
'      IF RIGHT$(Parameter$, 1) = ":" THEN         ' Yes, Is it an Optional?
'         EndName = INSTR(Flag, C$, " ")           '      Yes, Find End
'         IF EndName = 0 THEN                      '
'            EndName = LEN(C$) + 1                 '      Must be end of Line
'         END IF                                   '
'         Temp = EndName - Flag - StrLen           '      This is the length
'         Value$ = MID$(C$, Flag + StrLen, Temp)   ' So we can return this
'         Par = PDQValI(Value$)                    '
'      ELSE
'         Temp = 0                                 ' No, so zero length
         Par = -1
'      END IF
'      DelChar C$, Flag, SPACE$(StrLen + Temp)     ' delete it all
      DelChar C$, Flag, SPACE$(StrLen)     ' delete it all
   END IF
END SUB

SUB InputOption(FileNo, Flag) STATIC
   LINE INPUT #FileNo, Par$
   Flag = (UCASE$(Par$) = "YES")
END SUB

SUB Check4File(FileName$) STATIC
   IF NOT PDQExist(FileName$) THEN
      PRINT CHR$(34); FileName$; CHR$(34); " not Found!"
      PRINT
      CritErrOn
      END
   END IF
END SUB

