(* RINGDOOR.PAS By Joseph Sheppard, The Ledge PCBoard, 818-896-4015.
 * Allows selected users to Page the Sysop with a sound similar to
 * a telephone ringing. This is a free program. Use at your own risk.
 * Author assumes no responsibility.
 *)

{$M 6000,14000,14000}
{$S-,R-}
{$L+,D+}

Uses
   Dos,
   Crt,
   MiniCrt,
   OpenShare,
   MdosIO,
   BufIO,
   qRead,
   Tools,
   ProData,
   ProRoot,
   KitInit;



var

  start, stop, driver, closed, reason: string;
  maxrings, restrings, sound1, sound2, hold: word;
  fd: text;
  restricted: boolean;

(* ---------------------------------------------------------------- *)
procedure load_info;

begin
   assignText(fd,config_file);
   reset(fd);
   readln(fd,driver);
   readln(fd,maxrings);
   readln(fd,closed);
   readln(fd,restrings);
   readln(fd,sound1);
   readln(fd,sound2);
   readln(fd,hold);
   close(fd);

end;

(* ---------------------------------------------------------------- *)
procedure exit_door;

begin

  newline;
  newline;
  pdispln('$YELLOW$Returning to:$CYAN$ '+pcbsetup.system_name^);
  default_color;
  close_down_door(false);

end;

(* ---------------------------------------------------------------- *)


procedure ringer;

var
  times: integer;

begin

  times:=0;


repeat

  if dump_user or (minutes_left < 1) then exit;
  if key_ready then exit;
  inc(times);
  sound(sound1);  {1100 for telephone}
  delay(hold);    {10 for telephone}
  sound(sound2);  {800 for telephone}
  delay(hold);    {10 for telephone}

until times=15;

end;

(* ---------------------------------------------------------------- *)
procedure over_limit;

begin

  newline;
  pdispln('$WHITE$Maximum Number of Rings Reached! Please try again later.');
  newline;
  popup_cmdline('Press Enter to Return to BBS: ','');
  exit_door;

end;

(* ---------------------------------------------------------------- *)
procedure check_for_midnight;

begin

  if start <= stop then exit;
  if system_time <= stop then restricted:=true;
  if system_time >= start then restricted:=true;

end;
(* ---------------------------------------------------------------- *)
procedure check_time;



begin

  if closed='' then exit;
  start:=copy(closed,1,5);
  stop:=copy(closed,7,11);

  if (system_time >= start) and (system_time <= stop) then restricted:=true;
  check_for_midnight;

  pdispln('$GREEN$The Sysop has restricted use of this door between the hours of$WHITE$ '+closed+'$GREEN$.');
  if restricted then pdisp('You are in the $WHITE$RESTRICTED$GREEN$ period');
  if not restricted then pdisp('You are in the $WHITE$UNRESTRICTED$GREEN$ period');
  if restricted then pdisp('$WHITE$ '+itoa(restrings)+'$GREEN$');
  if not restricted then pdisp('$WHITE$ '+itoa(maxrings)+'$GREEN$');
  pdispln(' rings will be allowed.');

  if (restricted) and (restrings=0) then exit_door;
  newline;

  if restricted then

begin

  pdisp(^G'$RED$Are you sure you want to page the Sysop during $WHITE$RESTRICTED$RED$ Time? $WHITE$Y/N: ');
  get_cmdline;
  get_nextpar;
  newline;
  if par='N' then exit_door;

     end;
       end;
(* ---------------------------------------------------------------- *)

{Main Block}

var
  rings, lines: word;

begin

init;

  progname:='RingDoor';
  restricted:=false;
  load_info;
  linenum:=-10000;
  clrscr;
  newline;
  newline;
  pdispln('$CYAN$RingDoor V1.7, (c) Joseph Sheppard, The Ledge PCBoard, 818-896-4015');
  newline;


  pdispln('$YELLOW$Why do you want to page the Sysop? $WHITE$[ENTER]$YELLOW$ to return to BBS without paging.');
  newline;
  pdisp('$CYAN$> ');
  input(reason,65);
  if reason=''then exit_door;
  make_log_entry('Paged Sysop at '+system_time,false);
  make_log_entry('Reason: '+reason,false);
  newline;
  newline;
  writeln('Sysop:  Press F10 to Chat');
  newline;
  check_time;
  pdispln('$CYAN$Ringing The Sysop!');
  newline;
  writeln('Sysop: Press F10 to Chat');
  writeln('Reason: '+reason);
  newline;
  pdispln('$YELLOW$Press any Key Return to BBS!');
  newline;
  rings:=0;
  lines:=0;
  if restricted then maxrings:=restrings;

while not key_ready do

begin

  inc(rings);
  if rings > maxrings then over_limit;
  inc(lines);
  if not local then beep;
  pdispln('$MAGENTA$Ring '+itoa(rings)+'!  ');

  if lines=10 then

begin

  newline;
  pdispln('$YELLOW$Press any Key to Return to BBS! ');
  writeln('Sysop: Press F10 to Chat');
  writeln('Reason: '+reason);
  newline;
  lines:=0;

end
else

begin

  if dump_user or (minutes_left < 1) then exit;
  ringer;
  nosound;
  if not key_ready then delay(1500);

end;
     end;
  nosound;
  exit_door;

  default_color;
  close_down_door(false);

end.

(* ---------------------------------------------------------------- *)

