PROGRAM listmaze;
  {
         This program will display a maze.  A different random number seed
    will produce a different maze.

         Written by James L. Dean
                    406 40th Street
                    New Orleans, LA 70124
  }
  USES Crt;

  CONST

    num_columns = 39;
    x_max = 78;       {2*num_columns}
    num_rows = 21;
    y_max = 42;       {2*num_rows}

  VAR
    delta_index_1              : INTEGER;
    delta_index_1a             : INTEGER;
    delta_index_1b             : INTEGER;
    delta_index_1c             : INTEGER;
    delta_index_1d             : INTEGER;
    delta_index_2              : INTEGER;
    delta_x                    : ARRAY [1..4,1..24] OF INTEGER;
    delta_y                    : ARRAY [1..4,1..24] OF INTEGER;
    digit                      : INTEGER;
    digit_num                  : INTEGER;
    page                       : ARRAY [0..y_max,0..x_max] OF CHAR;
    r_n                        : ARRAY [1..8] OF INTEGER;
    r_n_index_1                : INTEGER;
    r_n_index_2                : INTEGER;
    seed                       : STRING[8];
    sum                        : INTEGER;
    tem_int                    : INTEGER;
    x                          : INTEGER;
    x_next                     : INTEGER;
    x_out                      : INTEGER;
    x_wall_1                   : INTEGER;
    y                          : INTEGER;
    y_next                     : INTEGER;
    y_out                      : INTEGER;
    y_wall_1                   : INTEGER;

  PROCEDURE add_room;
    VAR
      delta_index_1 : BYTE;
      delta_index_2 : BYTE;
    BEGIN
      page[y,x]:=' ';
      delta_index_1:=1;
      REPEAT
        delta_index_2:=r_n[1];
        r_n_index_1:=1;
        FOR r_n_index_2:=2 TO 8 DO
          BEGIN
            tem_int:=r_n[r_n_index_2];
            r_n[r_n_index_1]:=tem_int;
            delta_index_2:=delta_index_2+tem_int;
            IF delta_index_2 > 29 THEN
              delta_index_2:=delta_index_2-29;
            r_n_index_1:=r_n_index_2
          END;
        r_n[8]:=delta_index_2
      UNTIL
        (delta_index_2 <= 24);
      WHILE (delta_index_1 <= 4) DO
        BEGIN
          x_next:=x+2*delta_x[delta_index_1][delta_index_2];
          IF ((x_next <= 0) OR (x_next >= x_max)) THEN
            delta_index_1:=delta_index_1+1
          ELSE
            BEGIN
              y_next:=y+2*delta_y[delta_index_1][delta_index_2];
              IF ((y_next <= 0) OR (y_next >= y_max)) THEN
                delta_index_1:=delta_index_1+1
              ELSE
                IF page[y_next,x_next] = 'W' THEN
                  BEGIN
                    IF x = x_next THEN
                      BEGIN
                        y_wall_1:=(y+y_next) DIV 2;
                        page[y_wall_1,x_next]:=' '
                      END
                    ELSE
                      BEGIN
                        x_wall_1:=(x+x_next) DIV 2;
                        page[y_next,x_wall_1]:=' '
                      END;
                    x:=x_next;
                    y:=y_next;
                    add_room;
                    x:=x-2*delta_x[delta_index_1][delta_index_2];
                    y:=y-2*delta_y[delta_index_1][delta_index_2]
                  END
                ELSE
                  delta_index_1:=delta_index_1+1
            END
        END
    END;

  BEGIN
    ClrScr;
    WRITELN(OUTPUT,'                                 Maze Generator');
    WRITELN(OUTPUT,' '); WRITELN(OUTPUT,' '); WRITELN(OUTPUT,' ');
    WRITE(OUTPUT,'     Random number seed?  ');
    READLN(INPUT,seed);
    r_n_index_1:=1;
    FOR r_n_index_2:=1 TO LENGTH(seed) DO
      BEGIN
        tem_int:=ORD(seed[r_n_index_2]);
        WHILE (tem_int > 29) DO tem_int:=tem_int-29;
        r_n[r_n_index_1]:=tem_int;
        r_n_index_1:=r_n_index_1+1
      END;
    r_n_index_2:=8;
    WHILE (r_n_index_1 > 1) DO
      BEGIN
        r_n_index_1:=r_n_index_1-1;
        r_n[r_n_index_2]:=r_n[r_n_index_1];
        r_n_index_2:=r_n_index_2-1
      END;
    WHILE (r_n_index_2 >= 1) DO
      BEGIN
        r_n[r_n_index_2]:=19;
        r_n_index_2:=r_n_index_2-1
      END;
    delta_x[1,1]:=-1;
    delta_y[1,1]:=0;
    delta_x[2,1]:=0;
    delta_y[2,1]:=1;
    delta_x[3,1]:=1;
    delta_y[3,1]:=0;
    delta_x[4,1]:=0;
    delta_y[4,1]:=-1;
    delta_index_2:=0;
    FOR delta_index_1a:=1 TO 4 DO
      FOR delta_index_1b:=1 TO 4 DO
        IF delta_index_1a <> delta_index_1b THEN
          FOR delta_index_1c:=1 TO 4 DO
            IF ((delta_index_1a <> delta_index_1c)
            AND (delta_index_1b <> delta_index_1c)) THEN
              FOR delta_index_1d:=1 TO 4 DO
                IF ((delta_index_1a <> delta_index_1d)
                AND (delta_index_1b <> delta_index_1d)
                AND (delta_index_1c <> delta_index_1d)) THEN
                  BEGIN
                    delta_index_2:=delta_index_2+1;
                    delta_x[delta_index_1a,delta_index_2]:=delta_x[1,1];
                    delta_y[delta_index_1a,delta_index_2]:=delta_y[1,1];
                    delta_x[delta_index_1b,delta_index_2]:=delta_x[2,1];
                    delta_y[delta_index_1b,delta_index_2]:=delta_y[2,1];
                    delta_x[delta_index_1c,delta_index_2]:=delta_x[3,1];
                    delta_y[delta_index_1c,delta_index_2]:=delta_y[3,1];
                    delta_x[delta_index_1d,delta_index_2]:=delta_x[4,1];
                    delta_y[delta_index_1d,delta_index_2]:=delta_y[4,1]
                  END;
    FOR y_out:=0 TO y_max DO
      FOR x_out:=0 TO x_max DO
        page[y_out,x_out]:='W';
    sum:=0;
    FOR digit_num:=1 TO 3 DO
      BEGIN
        digit:=r_n[1];
        r_n_index_1:=1;
        FOR r_n_index_2:=2 TO 8 DO
          BEGIN
            tem_int:=r_n[r_n_index_2];
            r_n[r_n_index_1]:=tem_int;
            digit:=digit+tem_int;
            IF digit > 29 THEN
              digit:=digit-29;
            r_n_index_1:=r_n_index_2
          END;
        r_n[8]:=digit;
        sum:=29*sum+digit
      END;
    x:=2*(sum MOD num_columns)+1;
    sum:=0;
    FOR digit_num:=1 TO 3 DO
      BEGIN
        digit:=r_n[1];
        r_n_index_1:=1;
        FOR r_n_index_2:=2 TO 8 DO
          BEGIN
            tem_int:=r_n[r_n_index_2];
            r_n[r_n_index_1]:=tem_int;
            digit:=digit+tem_int;
            IF digit > 29 THEN
              digit:=digit-29;
            r_n_index_1:=r_n_index_2
          END;
        r_n[8]:=digit;
        sum:=29*sum+digit
      END;
    y:=2*(sum MOD num_rows)+1;
    add_room;
    page[0,1]:=' ';
    page[y_max,x_max-1]:=' ';
    ClrScr;
    WRITE(OUTPUT,CHR(179));
    x:=1;
    WHILE (x < x_max) DO
      BEGIN
        IF page[0,x] = 'W' THEN
          WRITE(OUTPUT,CHR(196))
        ELSE
          WRITE(OUTPUT,' ');
        x:=x+1;
        IF x < x_max THEN
          BEGIN
            IF page[1,x] = 'W' THEN
              WRITE(OUTPUT,CHR(194))
            ELSE
              WRITE(OUTPUT,CHR(196));
            x:=x+1
          END
      END;
    WRITE(OUTPUT,CHR(191));
    WRITELN(OUTPUT);
    y:=2;
    WHILE(y < y_max) DO
      BEGIN
        IF page[y,1] = 'W' THEN
          WRITE(OUTPUT,CHR(195))
        ELSE
          WRITE(OUTPUT,CHR(179));
        x:=1;
        WHILE (x < x_max) DO
          BEGIN
            IF page[y,x] = 'W' THEN
              WRITE(OUTPUT,CHR(196))
            ELSE
              WRITE(OUTPUT,' ');
            x:=x+1;
            IF x < x_max THEN
              BEGIN
                IF page[y,x-1] = 'W' THEN
                  IF page[y-1,x] = 'W' THEN
                    IF page[y+1,x] = 'W' THEN
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(197))
                      ELSE
                        WRITE(OUTPUT,CHR(180))
                    ELSE
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(193))
                      ELSE
                        WRITE(OUTPUT,CHR(217))
                  ELSE
                    IF page[y+1,x] = 'W' THEN
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(194))
                      ELSE
                        WRITE(OUTPUT,CHR(191))
                    ELSE
                      WRITE(OUTPUT,CHR(196))
                ELSE
                  IF page[y-1,x] = 'W' THEN
                    IF page[y+1,x] = 'W' THEN
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(195))
                      ELSE
                        WRITE(OUTPUT,CHR(179))
                    ELSE
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(192))
                      ELSE
                        WRITE(OUTPUT,CHR(179))
                  ELSE
                    IF page[y+1,x] = 'W' THEN
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(218))
                      ELSE
                        WRITE(OUTPUT,CHR(179))
                    ELSE
                      IF page[y,x+1] = 'W' THEN
                        WRITE(OUTPUT,CHR(196))
                      ELSE
                        WRITE(OUTPUT,' ');
                x:=x+1
              END
          END;
        IF page[y,x_max-1] = 'W' THEN
          WRITE(OUTPUT,CHR(180))
        ELSE
          WRITE(OUTPUT,CHR(179));
        y:=y+2;
        WRITELN(OUTPUT)
      END;
    WRITE(OUTPUT,CHR(192));
    x:=1;
    WHILE(x < x_max) DO
      BEGIN
        IF page[y_max,x] = 'W' THEN
          WRITE(OUTPUT,CHR(196))
        ELSE
          WRITE(OUTPUT,' ');
        x:=x+1;
        IF x < x_max THEN
          BEGIN
            IF page[y_max-1,x] = 'W' THEN
              WRITE(OUTPUT,CHR(193))
            ELSE
              WRITE(OUTPUT,CHR(196));
            x:=x+1
          END
      END;
    WRITE(OUTPUT,CHR(179));
    WRITELN(OUTPUT);
  END.
