/*

FXDEMO.PRG

Written by:    Jim Fowler  - 04/16/92

Compile with:  CLIPPER FXDEMO /M /N /W
Link with:     RTLINK FILE FXDEMO,FXCOLOR

*/


******************************************************************************


#INCLUDE  "BOX.CH"
#INCLUDE  "INKEY.CH"
#INCLUDE  "SETCURS.CH"

STATIC    cEntryScreen


******************************************************************************


FUNCTION FxDemo()
	
   LOCAL lResult, nValue, nLoop, cGreen, cBrown, cPink

	cEntryScreen := SAVESCREEN( 0, 0, MAXROW(), MAXCOL() )
	SETCURSOR( SC_NONE )
   SETCOLOR( "b/bg,b/bg,rb,rb,b/bg" )
	CLS
   IF !( fx_IsVGA() )
		
		// No VGA, so display message and quit.
		
      SETCOLOR( "w+/r" )
      @ 10, 16, 13, 63 BOX ( B_SINGLE + " " )
      @ 11, 18 SAY "Sorry, a VGA system must be installed to run"
      @ 12, 18 SAY "this demo program.  Press any key to exit.  "
      INKEY( 0 )
      ExitDemo()
	
	ENDIF
	
   @  1, 57 SAY "<ESC> to quit demo." COLOR "r/bg"
   SETCOLOR( "w/n" )
   @  3, 54, 21, 78 BOX ( B_SINGLE + " " )
   @  4, 56 SAY "  Background = Black " COLOR "w/n"
   @  5, 56 SAY " Black          (n  )" COLOR "n/n"
   @  6, 56 SAY " Blue           (b  )" COLOR "b/n"
   @  7, 56 SAY " Green          (g  )" COLOR "g/n"
   @  8, 56 SAY " Cyan           (bg )" COLOR "bg/n"
   @  9, 56 SAY " Red            (r  )" COLOR "r/n"
   @ 10, 56 SAY " Magenta        (rb )" COLOR "rb/n"
   @ 11, 56 SAY " Brown          (gr )" COLOR "gr/n"
   @ 12, 56 SAY " White          (w  )" COLOR "w/n"
   @ 13, 56 SAY " Grey           (n+ )" COLOR "n+/n"
   @ 14, 56 SAY " Bright Blue    (b+ )" COLOR "b+/n"
   @ 15, 56 SAY " Bright Green   (g+ )" COLOR "g+/n"
   @ 16, 56 SAY " Bright Cyan    (bg+)" COLOR "bg+/n"
   @ 17, 56 SAY " Bright Red     (r+ )" COLOR "r+/n"
   @ 18, 56 SAY " Bright Magenta (rb+)" COLOR "rb+/n"
   @ 19, 56 SAY " Yellow         (gr+)" COLOR "gr+/n"
   @ 20, 56 SAY " Bright White   (w+ )" COLOR "w+/n"
   SETCOLOR( "b/bg" )
   
   *-------------------------------------------------------------------------*

   @  0, 1 SAY "This demo program is designed to help you become"
   @  1, 1 SAY "familiar with the special effects color commands and"
   @  2, 1 SAY "some simplified uses by presenting them in a"
   @  3, 1 SAY "tutorial manner."
   @  5, 1 SAY "Armed with these commands, you can almost create any"
   @  6, 1 SAY "color effect you can imagine.  You can also create"
   @  7, 1 SAY "any color from the 262,144 possible colors allowed"
   @  8, 1 SAY "by a VGA system."
   @ 10, 1 SAY "The effects shown in this demo are fairly simple to"
   @ 11, 1 SAY "implement.  For more advanced effects, you can study"
   @ 12, 1 SAY "the document VGA.DOC and the ASM source code file"
   @ 13, 1 SAY "FXCOLOR.ASM and get many more ideas."
   @ 15, 1 SAY "If you're ready, lets start!"
   @ 17, 1 SAY "Press <ENTER> to begin..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "To redefine colors and use special effects, we must"
   @  1, 1 SAY "first enable the special effects.  This is done"
   @  2, 1 SAY "using the command:"
   @  4, 1 SAY "     fx_Enable()" COLOR "n/bg"
   @  6, 1 SAY "Notice the colors now displayed in the table are the"
   @  7, 1 SAY "default colors used by your computer at bootup for"
   @  8, 1 SAY "text mode.  When we enable the special effects, some"
   @  9, 1 SAY "will change slightly, particularly the high-"
   @ 10, 1 SAY "intensity colors (which will be slightly darker)."
   @ 12, 1 SAY "This occurs because the special effects system uses"
   @ 13, 1 SAY "its own pre-defined colors.  The high-intensity"
   @ 14, 1 SAY "colors are purposely made slightly darker to allow"
   @ 15, 1 SAY "for effects such as pulsating colors.  If the high-"
   @ 16, 1 SAY "intensity colors are at their maximums, these"
   @ 17, 1 SAY "effects would not be possible."
   @ 19, 1 SAY "You can change the pre-defined colors by modifying"
   @ 20, 1 SAY "the values for the variable _NewBase in the ASM"
   @ 21, 1 SAY "source file and re-assembling."
   @ 23, 1 SAY "Press <ENTER> to enable the color system..." COLOR "r/bg"
   GetKey()

   fx_Enable()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Special effects enabled!  Nothing is happening yet"
   @  1, 1 SAY "because we've only enabled the special effects, not"
   @  2, 1 SAY "created them."
   @  4, 1 SAY "A fading effect can be created with the command:"
   @  6, 1 SAY "     fx_Fade( cBaseAttrib, cSecondAttrib )" COLOR "n/bg"
   @  8, 1 SAY "Let's fade red to blue, magenta to yellow, bright"
   @  9, 1 SAY "cyan to black (background), and bright white to"
   @ 10, 1 SAY "black (background) using the following commands:"
   @ 12, 1 SAY '     fx_Fade( "r",   "b"   )' COLOR "n/bg"
   @ 13, 1 SAY '     fx_Fade( "rb",  "gr+" )' COLOR "n/bg"
   @ 14, 1 SAY '     fx_Fade( "bg+", "n"   )' COLOR "n/bg"
   @ 15, 1 SAY '     fx_Fade( "w+",  "n"   )' COLOR "n/bg"
   @ 17, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   // Lets flag our colors first.
   @  9,56 SAY CHR( 26 ) COLOR "w/n"
   @ 10,56 SAY CHR( 26 ) COLOR "w/n"
   @ 16,56 SAY CHR( 26 ) COLOR "w/n"
   @ 20,56 SAY CHR( 26 ) COLOR "w/n"

   fx_Fade( "rb",  "gr+" )
   fx_Fade( "w+",  "n"   )
   fx_Fade( "r",   "b"   )
   fx_Fade( "bg+", "n"   )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "fx_Fade() is particularly effective when fading a"
   @  1, 1 SAY "foreground color into a background color (such as"
   @  2, 1 SAY "bright white to black as shown in the table)."
   @  4, 1 SAY "Just to show it works on background colors too,"
   @  5, 1 SAY "let's fade the color of our main screen (cyan) with"
   @  6, 1 SAY "the command:"
   @  8, 1 SAY '     fx_Fade( "bg", "n" )' COLOR "n/bg"
   @ 10, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_Fade( "bg", "n" )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "We can restore cyan back to normal with the command:"
   @  2, 1 SAY '     fx_Restore( cBaseAttrib )' COLOR "n/bg"
   @  4, 1 SAY 'Cyan is the base attribute we want to restore, so we'
   @  5, 1 SAY "will execute the following:"
   @  7, 1 SAY '     fx_Restore( "bg" )' COLOR "n/bg"
   @  9, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_Restore( "bg" )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "We can speed up or slow down the rate using:"
   @  2, 1 SAY "     fx_PalRate( [nPaletteIncrement] )" COLOR "n/bg"
   @  3, 1 SAY "     fx_IntRate( [nInterval] )" COLOR "n/bg"
   @  5, 1 SAY "The fading (and other effects) are implemented"
   @  6, 1 SAY "internally by hooking the timer interrupt 1Ch"
   @  7, 1 SAY "(which occurs 18.2 times per second) and rotating"
   @  8, 1 SAY "through the color palettes."
   @ 10, 1 SAY "The fx_PalRate() command lets you set the number of"
   @ 11, 1 SAY "palettes to increment (skip) each timer interval."
   @ 12, 1 SAY "Normally, this is 1.  The HIGHER the number, the"
   @ 13, 1 SAY "FASTER the increment and the effect."
   @ 15, 1 SAY "The fx_IntRate() command lets you set the number of"
   @ 16, 1 SAY "timer tick intervals before rotating any palettes."
   @ 17, 1 SAY "Therefore, the HIGHER the number, the SLOWER the"
   @ 18, 1 SAY "rotation occurs and the slower the effect."
   @ 20, 1 SAY "Let's increase the speed with:"
   @ 22, 1 SAY "     fx_PalRate( 2 )" COLOR "n/bg"
   @ 24, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Not fast enough?  Oh well, let's try this:"
   @  2, 1 SAY "     fx_PalRate( 15 )" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 15 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Fast enough now?"
   @  2, 1 SAY "Also, we want to see what slowing it down does, so"
   @  3, 1 SAY "we will start by resetting the speed back to normal."
   @  5, 1 SAY "     fx_PalRate( 1 )" COLOR "n/bg"
   @  7, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 1 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "To slow it, we'll use:"
   @  2, 1 SAY "     fx_IntRate( 2 )" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_IntRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "A little slower, but we can make it even slower with"
   @  2, 1 SAY "     fx_IntRate( 18 )" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_IntRate( 18 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "It's only doing about one palette change per second"
   @  1, 1 SAY "so it will take about 32 seconds to make a full"
   @  2, 1 SAY "cycle because it rotates from palette 0 to palette"
   @  3, 1 SAY "15, then reverses direction and rotates back to"
   @  4, 1 SAY "palette 0 and so forth.  Therefore, it must go 32"
   @  5, 1 SAY "palette changes to complete a full cycle (assuming"
   @  6, 1 SAY "fx_PalRate() is set to 1)."
   @  8, 1 SAY "Of course this is fascinating to watch, but we want"
   @  9, 1 SAY "to look at other commands too.  We can restore"
   @ 10, 1 SAY "EVERYTHING back to normal using the command:"
   @ 12, 1 SAY "     fx_RestAll()" COLOR "n/bg"
   @ 14, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_RestAll()

   // Lets unflag our colors.
   @  9,56 SAY " " COLOR "w/n"
   @ 10,56 SAY " " COLOR "w/n"
   @ 16,56 SAY " " COLOR "w/n"
   @ 20,56 SAY " " COLOR "w/n"

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Another special effect is pulsating colors.  The"
   @  1, 1 SAY "syntax for the command is:"
   @  3, 1 SAY "     fx_Pulse( cBaseAttrib )" COLOR "n/bg"
   @  5, 1 SAY "Let's try the following commands and see what result"
   @  6, 1 SAY "we obtain:"
   @  8, 1 SAY '     fx_Pulse( "b"   )' COLOR "n/bg"
   @  9, 1 SAY '     fx_Pulse( "r"   )' COLOR "n/bg"
   @ 10, 1 SAY '     fx_Pulse( "gr"  )' COLOR "n/bg"
   @ 11, 1 SAY '     fx_Pulse( "gr+" )' COLOR "n/bg"
   @ 13, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   // Lets flag our colors first.
   @  6,56 SAY CHR( 26 ) COLOR "w/n"
   @  9,56 SAY CHR( 26 ) COLOR "w/n"
   @ 11,56 SAY CHR( 26 ) COLOR "w/n"
   @ 19,56 SAY CHR( 26 ) COLOR "w/n"

   fx_Pulse( "b"   )
   fx_Pulse( "r"   )
   fx_Pulse( "gr"  )
   fx_Pulse( "gr+" )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Uh-Oh!  We've managed to pulse our text color.  As"
   @  1, 1 SAY "you can see, fx_Pulse() causes a color to go from"
   @  2, 1 SAY "normal to brighter (up to 75% brighter).  You may"
   @  3, 1 SAY "notice that yellow does not seem to change much."
   @  4, 1 SAY "This is because yellow is a high-intensity color and"
   @  5, 1 SAY "cannot be brightened much more.  Remember, it was"
   @  6, 1 SAY "explained earlier that the high-intensity colors are"
   @  7, 1 SAY "slightly darker on purpose in order to generate this"
   @  8, 1 SAY "effect."
   @ 10, 1 SAY "Let's increase the speed with:"
   @ 12, 1 SAY '     fx_PalRate( 2 )' COLOR "n/bg"
   @ 14, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Now we will slow it with:"
   @  2, 1 SAY "     fx_IntRate( 2 )" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_IntRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Well, it slowed, but appears to be at normal speed"
   @  1, 1 SAY "rather than slower.  Our command was fx_IntRate(2)."
   @  2, 1 SAY "Usually this should slow it to about one-half the"
   @  3, 1 SAY "normal rate.  So what happened?"
   @  5, 1 SAY "Earlier we sped it up with fx_PalRate( 2 )."
   @  6, 1 SAY "Therefore, every timer tick interval we are rotating"
   @  7, 1 SAY "the displayed palette by a factor of 2 (i.e.,"
   @  8, 1 SAY "skipping every other palette).  The fx_IntRate( 2 )"
   @  9, 1 SAY "command causes the rotation to occur every 2 timer"
   @ 10, 1 SAY "tick intervals (i.e., every other timer tick)."
   @ 11, 1 SAY "The resulting 2 palette increments every 2 timer"
   @ 12, 1 SAY "tick intervals is almost equivalent to the normal"
   @ 13, 1 SAY "speed of 1 palette increment every 1 timer tick."
   @ 14, 1 SAY "They are not exactly equivalent because we are"
   @ 15, 1 SAY "skipping a palette so the display is not quite as"
   @ 16, 1 SAY '"smooth" as normal speed would be.'
   @ 18, 1 SAY "To actually slow it, we need to reset the palette"
   @ 19, 1 SAY "increment rate back to normal with the command:"
   @ 21, 1 SAY "     fx_PalRate( 1 )" COLOR "n/bg"
   @ 23, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 1 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Now we're at a slower speed."
   @  2, 1 SAY "Pulsating colors have their uses, but trying to"
   @  3, 1 SAY "read pulsating text can give you a pulsating"
   @  4, 1 SAY "headache <g>.  Let's restore everything back to"
   @  5, 1 SAY "normal again and move on to blinking."
   @  7, 1 SAY "     fx_RestAll()" COLOR "n/bg"
   @  9, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_RestAll()

   // Lets unflag our colors.
   @  6,56 SAY " " COLOR "w/n"
   @  9,56 SAY " " COLOR "w/n"
   @ 11,56 SAY " " COLOR "w/n"
   @ 19,56 SAY " " COLOR "w/n"

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "The syntax for the blinking command is:"
   @  2, 1 SAY "     fx_Blink( cBaseAttrib,      ;" COLOR "n/bg"
   @  3, 1 SAY "               cSecondAttrib,    ;" COLOR "n/bg"
   @  4, 1 SAY "               [lSoftBlink]   )" COLOR "n/bg"
   @  6, 1 SAY "cBaseAttrib is the color attribute you want to"
   @  7, 1 SAY "blink (usually a foreground color) and cSecondAttrib"
   @  8, 1 SAY "is the color to blink to (usually a background"
   @  9, 1 SAY "color).  The optional lSoftBlink, when logical .T.,"
   @ 10, 1 SAY 'produces a "softened" blink (i.e. slight fading).'
   @ 12, 1 SAY "The color attributes specified do not have to be"
   @ 13, 1 SAY "foreground and background as you will see.  We'll"
   @ 14, 1 SAY "do the following commands:"
   @ 16, 1 SAY '     fx_Blink( "r",  "gr+" )' COLOR "n/bg"
   @ 17, 1 SAY '     fx_Blink( "gr", "bg"  )' COLOR "n/bg"
   @ 18, 1 SAY '     fx_Blink( "w+", "g", .T. )' COLOR "n/bg"
   @ 20, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   // Lets flag our colors first.
   @  9,56 SAY CHR( 26 ) COLOR "w/n"
   @ 11,56 SAY CHR( 26 ) COLOR "w/n"
   @ 20,56 SAY CHR( 26 ) COLOR "w/n"

   fx_Blink( "r",  "gr+" )
   fx_Blink( "gr", "bg"  )
   fx_Blink( "w+", "g",  .T. )

   *-------------------------------------------------------------------------*

   // In coloring the suceeding text examples, the "*" is used in the
   // color string to allow for high-intensity background colors in Clipper.
   // (I.E., "b*" is equivalent to a background color of "b+".)
   // It does NOT create the blinking effect because the hardware blink bit
   // is set OFF by fx_Enable().

   BlankText()
   @  0, 7 SAY 'Command:  fx_Blink( "r",  "gr+" )'
   @  1, 7 SAY " FG = red->yellow, BG = yellow         " COLOR "r/gr*"
   @  2, 7 SAY " FG = red->yellow, BG = bright magenta " COLOR "r/rb*"
   @  3, 7 SAY " FG = yellow, BG = red->yellow         " COLOR "gr+/r"
   @  4, 7 SAY " FG = bright cyan, BG = red->yellow    " COLOR "bg+/r"
   @  6, 7 SAY 'Command:  fx_Blink( "gr", "bg" )'
   @  7, 7 SAY " FG = brown->cyan, BG = cyan           " COLOR "gr/bg"
   @  8, 7 SAY " FG = brown->cyan, BG = grey           " COLOR "gr/n*"
   @  9, 7 SAY " FG = cyan, BG = brown->cyan           " COLOR "bg/gr"
   @ 10, 7 SAY " FG = bright blue, BG = brown->cyan    " COLOR "b+/gr"
   @ 12, 7 SAY 'Command:  fx_Blink( "w+", "g", .T. )'
   @ 13, 7 SAY " FG = bright white->green, BG = green  " COLOR "w+/g"
   @ 14, 7 SAY " FG = bright white->green, BG = blue   " COLOR "w+/b"
   @ 15, 7 SAY " FG = green, BG = bright white->green  " COLOR "g/w*"
   @ 16, 7 SAY " FG = black, BG = bright white->green  " COLOR "n/w*"
   @ 18, 1 SAY "Notice that you can have blinking colors AND high-"
   @ 19, 1 SAY "intensity backgrounds and that the background can"
   @ 20, 1 SAY "blink while the foreground remains stable.  Can you"
   @ 21, 1 SAY 'see the difference caused by "softened" blinking?'
   @ 23, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 7 SAY 'Command:  fx_Blink( "r",  "gr+" )'
   @  1, 7 SAY " FG = red->yellow, BG = yellow         " COLOR "r/gr*"
   @  2, 7 SAY " FG = red->yellow, BG = bright magenta " COLOR "r/rb*"
   @  3, 7 SAY " FG = yellow, BG = red->yellow         " COLOR "gr+/r"
   @  4, 7 SAY " FG = bright cyan, BG = red->yellow    " COLOR "bg+/r"
   @  6, 7 SAY 'Command:  fx_Blink( "gr", "bg" )'
   @  7, 7 SAY " FG = brown->cyan, BG = cyan           " COLOR "gr/bg"
   @  8, 7 SAY " FG = brown->cyan, BG = grey           " COLOR "gr/n*"
   @  9, 7 SAY " FG = cyan, BG = brown->cyan           " COLOR "bg/gr"
   @ 10, 7 SAY " FG = bright blue, BG = brown->cyan    " COLOR "b+/gr"
   @ 12, 7 SAY 'Command:  fx_Blink( "w+", "g", .T. )'
   @ 13, 7 SAY " FG = bright white->green, BG = green  " COLOR "w+/g"
   @ 14, 7 SAY " FG = bright white->green, BG = blue   " COLOR "w+/b"
   @ 15, 7 SAY " FG = green, BG = bright white->green  " COLOR "g/w*"
   @ 16, 7 SAY " FG = black, BG = bright white->green  " COLOR "n/w*"
   @ 18, 1 SAY "We will now increase the speed with:"
   @ 20, 1 SAY "     fx_PalRate( 2 )" COLOR "n/bg"
   @ 22, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 7 SAY 'Command:  fx_Blink( "r",  "gr+" )'
   @  1, 7 SAY " FG = red->yellow, BG = yellow         " COLOR "r/gr*"
   @  2, 7 SAY " FG = red->yellow, BG = bright magenta " COLOR "r/rb*"
   @  3, 7 SAY " FG = yellow, BG = red->yellow         " COLOR "gr+/r"
   @  4, 7 SAY " FG = bright cyan, BG = red->yellow    " COLOR "bg+/r"
   @  6, 7 SAY 'Command:  fx_Blink( "gr", "bg" )'
   @  7, 7 SAY " FG = brown->cyan, BG = cyan           " COLOR "gr/bg"
   @  8, 7 SAY " FG = brown->cyan, BG = grey           " COLOR "gr/n*"
   @  9, 7 SAY " FG = cyan, BG = brown->cyan           " COLOR "bg/gr"
   @ 10, 7 SAY " FG = bright blue, BG = brown->cyan    " COLOR "b+/gr"
   @ 12, 7 SAY 'Command:  fx_Blink( "w+", "g", .T. )'
   @ 13, 7 SAY " FG = bright white->green, BG = green  " COLOR "w+/g"
   @ 14, 7 SAY " FG = bright white->green, BG = blue   " COLOR "w+/b"
   @ 15, 7 SAY " FG = green, BG = bright white->green  " COLOR "g/w*"
   @ 16, 7 SAY " FG = black, BG = bright white->green  " COLOR "n/w*"
   @ 18, 1 SAY "And slow the speed with:"
   @ 20, 1 SAY "     fx_PalRate( 1 )" COLOR "n/bg"
   @ 21, 1 SAY "     fx_IntRate( 2 )" COLOR "n/bg"
   @ 23, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_PalRate( 1 )
   fx_IntRate( 2 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 7 SAY 'Command:  fx_Blink( "r",  "gr+" )'
   @  1, 7 SAY " FG = red->yellow, BG = yellow         " COLOR "r/gr*"
   @  2, 7 SAY " FG = red->yellow, BG = bright magenta " COLOR "r/rb*"
   @  3, 7 SAY " FG = yellow, BG = red->yellow         " COLOR "gr+/r"
   @  4, 7 SAY " FG = bright cyan, BG = red->yellow    " COLOR "bg+/r"
   @  6, 7 SAY 'Command:  fx_Blink( "gr", "bg" )'
   @  7, 7 SAY " FG = brown->cyan, BG = cyan           " COLOR "gr/bg"
   @  8, 7 SAY " FG = brown->cyan, BG = grey           " COLOR "gr/n*"
   @  9, 7 SAY " FG = cyan, BG = brown->cyan           " COLOR "bg/gr"
   @ 10, 7 SAY " FG = bright blue, BG = brown->cyan    " COLOR "b+/gr"
   @ 12, 7 SAY 'Command:  fx_Blink( "w+", "g", .T. )'
   @ 13, 7 SAY " FG = bright white->green, BG = green  " COLOR "w+/g"
   @ 14, 7 SAY " FG = bright white->green, BG = blue   " COLOR "w+/b"
   @ 15, 7 SAY " FG = green, BG = bright white->green  " COLOR "g/w*"
   @ 16, 7 SAY " FG = black, BG = bright white->green  " COLOR "n/w*"
   @ 18, 1 SAY "Restore EVERYTHING to normal with:"
   @ 20, 1 SAY "     fx_RestAll()" COLOR "n/bg"
   @ 22, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_RestAll()

   // Lets unflag our colors.
   @  9,56 SAY " " COLOR "w/n"
   @ 11,56 SAY " " COLOR "w/n"
   @ 20,56 SAY " " COLOR "w/n"

   *-------------------------------------------------------------------------*

   // Do these in advance of the next screen page.
   fx_Fade( "g", "r" )
   fx_Pulse( "rb" )
   fx_Blink( "w", "n" )

   BlankText()
   @  0, 1 SAY "Surprise!  Everything was restored to normal but I"
   @  1, 1 SAY "thought you might want to see the special effects"
   @  2, 1 SAY "together on one screen for comparisons."
   @  7,27 SAY 'fx_Fade( "g", "r" )   --->' COLOR "n/bg"
   @ 10,27 SAY 'fx_Pulse( "rb" )      --->' COLOR "n/bg"
   @ 12,27 SAY 'fx_Blink( "w", "n" )  --->' COLOR "n/bg"
   @ 22, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   fx_RestAll()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "All of the preceding special effects (and others)"
   @  1, 1 SAY "can be created using the attribute/palette set/get"
   @  2, 1 SAY "commands that will follow.  But first we need to"
   @  3, 1 SAY "discuss two other commands."
   @  5, 1 SAY "If you recall, the special effects are accomplished"
   @  6, 1 SAY "by rotating palettes N increments every N timer tick"
   @  7, 1 SAY "intervals.  But suppose you wanted palette 2 to be"
   @  8, 1 SAY "a color scheme of shades of red, and palette 11 to"
   @  9, 1 SAY 'represent a set of "tropical" colors you have'
   @ 10, 1 SAY "defined.  If the palettes are constantly rotated,"
   @ 11, 1 SAY "you will get an interesting side effect with each"
   @ 12, 1 SAY "color attribute (i.e., they'll appear as blips)."
   @ 14, 1 SAY "The command"
   @ 16, 1 SAY "     fx_SetFix( [lSetting] )" COLOR "n/bg"
   @ 18, 1 SAY "solves this.  When lSetting = .T., it suspends the"
   @ 19, 1 SAY 'rotations and "fixes" a palette in place.  Of course'
   @ 20, 1 SAY "you no longer have fading, pulsing, and blinking"
   @ 21, 1 SAY "effects (this can be overcome though if you are"
   @ 22, 1 SAY "ingenious enough to figure it out)."
   @ 24, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "     fx_SetFix( [lSetting] )" COLOR "n/bg"
   @  2, 1 SAY 'In other words, when "fixed" palette mode is ON,'
   @  3, 1 SAY "the following command's DISPLAYS are suspended:"
   @  5, 1 SAY "     fx_Fade()" COLOR "n/bg"
   @  6, 1 SAY "     fx_Pulse()" COLOR "n/bg"
   @  7, 1 SAY "     fx_Blink()" COLOR "n/bg"
   @  8, 1 SAY "     fx_PalRate()" COLOR "n/bg"
   @  9, 1 SAY "     fx_IntRate()" COLOR "n/bg"
   @ 11, 1 SAY 'When lSetting = .F., "fixed" palette mode is'
   @ 12, 1 SAY "turned OFF and the above commands are re-enabled."
   @ 14, 1 SAY "Keep in mind that when the RED/GREEN/BLUE (RGB)"
   @ 15, 1 SAY "values of any attribute in any palette are changed,"
   @ 16, 1 SAY "whether by the special effects commands above or by"
   @ 17, 1 SAY "attribute manipulation commands that follow, those"
   @ 18, 1 SAY "values are STILL IN EFFECT, even when you switch"
   @ 19, 1 SAY 'from "fixed" palette mode to rotation, and'
   @ 20, 1 SAY "vice-versa.  Remembering this rule can prevent some"
   @ 21, 1 SAY "unpredictable results."
   @ 23, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Once you have used fx_SetFix( .T. ) to place your"
   @  1, 1 SAY 'application in a "fixed" palette mode, you need to'
   @  2, 1 SAY "be able to change from one palette to another.  This"
   @  3, 1 SAY "is accomplished with the command:"
   @  5, 1 SAY "     fx_SetPal( [nPalette] )" COLOR "n/bg"
   @  7, 1 SAY "fx_SetPal() allows you to set the displayable"
   @  8, 1 SAY "palette.  There are 16 palettes (numbered 0-15),"
   @  9, 1 SAY "each containing 16 color attributes.  Although there"
   @ 10, 1 SAY "are 262,144 color combinations available, you may"
   @ 11, 1 SAY "define only 256 at any time and only 16 of those may"
   @ 12, 1 SAY "be displayed at any time in text mode.  (This is a"
   @ 13, 1 SAY "limitation imposed by DOS.)  The 16 colors that can"
   @ 14, 1 SAY "be displayed are the 16 color attributes in the"
   @ 15, 1 SAY "currently selected palette."
   @ 17, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Commands used to get/set palettes/attributes are:"
   @  2, 1 SAY "     fx_Palette( nPalette, [cPal48BtyeString] )" COLOR "n/bg"
   @  3, 1 SAY "     fx_PalAll( [cPal768ByteString] )" COLOR "n/bg"
   @  4, 1 SAY "     fx_Attr( cBaseAttrib, [cAttr48ByteString] )" COLOR "n/bg"
   @  5, 1 SAY "     fx_AttrAll( [cAttr768ByteString] )" COLOR "n/bg"
   @  7, 1 SAY "These commands do not actually manipulate the RGB"
   @  8, 1 SAY "values of the attributes, you must write your own"
   @  9, 1 SAY "routines for that.  They do, however, allow you to"
   @ 10, 1 SAY "get/set the RGB values.  The commands are similiar"
   @ 11, 1 SAY "in use - the difference is the format of the string"
   @ 12, 1 SAY "variable used by the command to get/set the values."
   @ 14, 1 SAY "fx_Palette() is used to get/set a SINGLE PALETTE"
   @ 15, 1 SAY "with 16 attributes.  fx_Attr() is used to get/set a"
   @ 16, 1 SAY "SINGLE ATTRIBUTE across 16 palettes.  fx_PalAll() is"
   @ 17, 1 SAY "used to get/set ALL PALETTES (in PALETTE order) with"
   @ 18, 1 SAY "16 attributes each.  fx_AttrAll() is used to get/set"
   @ 19, 1 SAY "ALL ATTRIBUTES (in ATTRIBUTE order) across 16"
   @ 20, 1 SAY "palettes each.  Please read the docs for more"
   @ 21, 1 SAY "information on these commands."
   @ 23, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Now let's display various shades of green.  First,"
   @  1, 1 SAY "we'll create a 48 byte string (16 attributes times 3"
   @  2, 1 SAY "RGB values each) and let this represent one palette."
   @  3, 1 SAY "We need to increment the RGB green value so it will"
   @  4, 1 SAY "range from a low RGB value for green to the maximum"
   @  5, 1 SAY "value (63) over a range of 16 attributes."
   @  7, 1 SAY '     cGreen := ""      // Values range 3,7,...,63'     ;
               COLOR "n/bg"
   @  8, 1 SAY "     nValue := 3       // Starting green value" COLOR "n/bg"
   @  9, 1 SAY "     FOR nLoop = 1 TO 16" COLOR "n/bg"
   @ 10, 1 SAY "        //        -Red-       -Green-      -Blue-"     ;
               COLOR "n/bg"
   @ 11, 1 SAY "        cGreen += CHR(0) + CHR( nValue ) + CHR(0)"     ;
               COLOR "n/bg"
   @ 12, 1 SAY "        nValue += 4    // Increment value by 4" COLOR "n/bg"
   @ 13, 1 SAY "     NEXT" COLOR "n/bg"
   @ 15, 1 SAY "Now we can implement our greens with the commands:"
   @ 17, 1 SAY "     fx_SetFix( .T. )  // If not issued before" COLOR "n/bg"
   @ 18, 1 SAY "     fx_Palette( 14, cGreen )  // We'll use pal # 14"  ;
               COLOR "n/bg"
   @ 19, 1 SAY "     fx_SetPal( 14 )           //    but any will do"  ;
               COLOR "n/bg"
   @ 21, 1 SAY "Of course, EVERYTHING will be a shade of green."
   @ 23, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   cGreen := ""       // Values range 3,7,...,63
   nValue := 3        // Starting green value
   FOR nLoop = 1 TO 16
       //        -Red-       -Green-      -Blue-
       cGreen += CHR(0) + CHR( nValue ) + CHR(0)
       nValue += 4    // Increment value by 4
   NEXT

   fx_SetFix( .T. )   // If not issued before
   fx_Palette( 14, cGreen )  // We'll use pal # 14
   fx_SetPal( 14 )           //    but any will do

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "As you can see, everything is a shade of green.  Can"
   @  1, 1 SAY 'you tell which shade of green is the "normal" green?'
   @  2, 1 SAY "(Hint:  It's not _wrong_ green!)"
   @  4, 3 SAY "   " COLOR "n/n"
   @  4, 6 SAY "   " COLOR "n/b"
   @  4, 9 SAY "   " COLOR "n/g"
   @  4,12 SAY "   " COLOR "n/bg"
   @  4,15 SAY "   " COLOR "n/r"
   @  4,18 SAY "   " COLOR "n/rb"
   @  4,21 SAY "   " COLOR "n/gr"
   @  4,24 SAY "   " COLOR "n/w"
   @  4,27 SAY "   " COLOR "n/n*"
   @  4,30 SAY "   " COLOR "n/b*"
   @  4,33 SAY "   " COLOR "n/g*"
   @  4,36 SAY "   " COLOR "n/bg*"
   @  4,39 SAY "   " COLOR "n/r*"
   @  4,42 SAY "   " COLOR "n/rb*"
   @  4,45 SAY "   " COLOR "n/gr*"
   @  4,48 SAY "   " COLOR "n/w*"
   @  6, 1 SAY "You'll notice the color to the extreme left above"
   @  7, 1 SAY "appears to be almost black, not green.  It does"
   @  8, 1 SAY "actually have some green in it - recall our initial"
   @  9, 1 SAY "RGB green value was 3 (out of possible 63).  The"
   @ 10, 1 SAY "value is very low and the color is very faint.  But"
   @ 11, 1 SAY "it is there!"
   @ 13, 1 SAY "We'll now go back to palette 0 and return to normal"
   @ 14, 1 SAY "colors because palette 0 was not changed.  We can"
   @ 15, 1 SAY "use the command:"
   @ 17, 1 SAY "     fx_SetPal( 0 )" COLOR "n/bg"
   @ 19, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_SetPal( 0 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Green (and most of the default colors) are easy to"
   @  1, 1 SAY "shade from dark to light because the increment for"
   @  2, 1 SAY "each applicable RGB value would be the same (i.e.,"
   @  3, 1 SAY "cyan's RGB values are 0/42/42, magenta is 42/42/0)."
   @  4, 1 SAY "For unequal values (such as brown - 42/21/0), you"
   @  5, 1 SAY "need to maintain the proper color ratio mix to"
   @  6, 1 SAY 'produce "true" color shadings.  For example:'
   @  8, 1 SAY '     cBrown := ""' COLOR "n/bg"
   @  9, 1 SAY "     nValue := 3" COLOR "n/bg"
   @ 10, 1 SAY "     FOR nLoop = 1 TO 16" COLOR "n/bg"
   @ 11, 1 SAY "        // Set RGB's - Green is 50% of Red value" COLOR "n/bg"
   @ 12, 1 SAY "        cBrown += CHR( nValue )               ;" COLOR "n/bg"
   @ 13, 1 SAY "                  + CHR( INT( nValue / 2 ) )  ;" COLOR "n/bg"
   @ 14, 1 SAY "                  + CHR(0)" COLOR "n/bg"
   @ 15, 1 SAY "        nValue += 4" COLOR "n/bg"
   @ 16, 1 SAY "     NEXT" COLOR "n/bg"
   @ 17, 1 SAY "     fx_Palette( 8, cBrown )   // We'll use pal # 8"  ;
               COLOR "n/bg"
   @ 18, 1 SAY "     fx_SetPal( 8 )" COLOR "n/bg"
   @ 20, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   cBrown := ""
   nValue := 3
   FOR nLoop = 1 TO 16
      // Set RGB's - Green is 50% of Red value
      cBrown += CHR( nValue )               ;
                + CHR( INT( nValue / 2 ) )  ;
                + CHR(0)
      nValue += 4
   NEXT
   fx_Palette( 8, cBrown )   // We'll use pal # 8
   fx_SetPal( 8 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Let's go back to palette 0 before continuing."
   @  2, 1 SAY "     fx_SetPal( 0 )" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_SetPal( 0 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "The command fx_Attr() lets us get/set an attribute"
   @  1, 1 SAY "across all palettes.  Black is such a drab color"
   @  2, 1 SAY "(actually it's no color).  Why don't we change it to"
   @  3, 1 SAY "pink!"
   @  5, 1 SAY "The RGB values for a high-intensity pink are"
   @  6, 1 SAY "63/0/47.  The following will create a 48-byte string"
   @  7, 1 SAY "with pink repeated for all 16 palettes."
   @  9, 1 SAY '     cPink := ""' COLOR "n/bg"
   @ 10, 1 SAY "     FOR nLoop = 1 TO 16" COLOR "n/bg"
   @ 11, 1 SAY "        cPink += CHR( 63 ) + CHR( 0 ) + CHR( 47 )"  ;
               COLOR "n/bg"
   @ 12, 1 SAY "     NEXT" COLOR "n/bg"
   @ 13, 1 SAY '     fx_Attr( "n", cPink )' COLOR "n/bg"
   @ 15, 1 SAY "Need proof it's stored in all the palettes?  We will"
   @ 16, 1 SAY 'de-activate our "fixed" palette mode and return to'
   @ 17, 1 SAY "rotating palettes with the command:"
   @ 19, 1 SAY "     fx_SetFix( .F. )" COLOR "n/bg"
   @ 21, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   cPink := ""
   FOR nLoop = 1 TO 16
       cPink += CHR( 63 ) + CHR( 0 ) + CHR( 47 )
   NEXT
   fx_Attr( "n", cPink )
   fx_SetFix( .F. )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Now that the palettes are rotating again, we can"
   @  1, 1 SAY "see that pink remains constant because it's in"
   @  2, 1 SAY "every palette."
   @  4, 1 SAY "But what's all this flickering?  Let's slow down"
   @  5, 1 SAY "and take a look."
   @  7, 1 SAY "     fx_IntRate( 12 )" COLOR "n/bg"
   @  9, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_IntRate( 12 )

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "With the palettes rotating slower we'll be able to"
   @  1, 1 SAY "diagnose our problem.  Have you figured it out yet?"
   @  3, 1 SAY "Palette 8 was set for shading brown and palette 14"
   @  4, 1 SAY "was set for shading green.  We forgot to restore"
   @  5, 1 SAY "those palettes before starting our palette rotation!"
   @  7, 1 SAY "Notice that pink, however, remains constant since we"
   @  8, 1 SAY "defined it for ALL palettes (including 8 and 14)."
   @ 10, 1 SAY "When we set palettes 8 and 14, we should have saved"
   @ 11, 1 SAY "the original definitions to a variable, as in"
   @ 13, 1 SAY "     cSavePal := fx_Palette( nPalette, cRGBString )"  ;
           COLOR "n/bg"
   @ 15, 1 SAY "We could then restore them easily with:"
   @ 17, 1 SAY "     fx_Palette( nPalette, cSavePal )" COLOR "n/bg"
   @ 19, 1 SAY "Of course, they should have been restored BEFORE we"
   @ 20, 1 SAY "defined pink across all palettes, otherwise, we"
   @ 21, 1 SAY "would have over-written pink in palettes 8 and 14."
   @ 23, 1 SAY "Press <ENTER> to continue..." COLOR "r/bg"
   GetKey()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Lets return everything to normal with:"
   @  2, 1 SAY "     fx_RestAll()" COLOR "n/bg"
   @  4, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_RestAll()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "By redefining the RGB values of an attribute or"
   @  1, 1 SAY 'palette and "fixing" palettes or rotating palettes'
   @  2, 1 SAY "at various speeds, you have complete control to"
   @  3, 1 SAY "create almost any color effect you can imagine. You"
   @  4, 1 SAY "can study the FXDEMO.PRG source to learn more about"
   @  5, 1 SAY "how to create some sophisticated effects."
   @  7, 1 SAY "Before your application terminates and returns to"
   @  8, 1 SAY "DOS, or at any time it may be necessary, you must"
   @  9, 1 SAY "disable the special effects colors and the timer"
   @ 10, 1 SAY "intercept.  This is done with the following command:"
   @ 12, 1 SAY "     fx_Disable()" COLOR "n/bg"
   @ 14, 1 SAY "Press <ENTER> to execute..." COLOR "r/bg"
   GetKey()

   fx_Disable()

   *-------------------------------------------------------------------------*

   BlankText()
   @  0, 1 SAY "Two other commands we have not discussed can be"
   @  1, 1 SAY "used even when the special effects are disabled."
   @  3, 1 SAY "     fx_IsFxOn()" COLOR "n/bg"
   @  4, 1 SAY "     fx_IsVGA()" COLOR "n/bg"
   @  6, 1 SAY "fx_IsFxOn() returns a logical .T./.F. indicating"
   @  7, 1 SAY "whether or not the special effects are enabled."
   @  9, 1 SAY "fx_IsVGA() returns a logical .T./.F. indicating"
   @ 10, 1 SAY "whether or not a VGA system is installed.  (A VGA"
   @ 11, 1 SAY "is required for the special effects commands.)"
   @ 13, 1 SAY "This concludes our demo program.  Please review"
   @ 14, 1 SAY "the documentation and syntax for each command and"
   @ 15, 1 SAY "also read the VGA.DOC file and study the FXCOLOR.ASM"
   @ 16, 1 SAY "source file for more information and tips on using"
   @ 17, 1 SAY "these and other special effects."
   @ 19, 1 SAY "Press <ENTER> to exit..." COLOR "r/bg"
   GetKey()

   ExitDemo()

RETURN ( NIL )


******************************************************************************


FUNCTION GetKey()
	
   IF INKEY( 0 ) == K_ESC
      fx_Disable()
      ExitDemo()
   ENDIF

RETURN ( NIL )


*******************************************************************************


FUNCTION BlankText()
	
   @ 0, 0 CLEAR TO 24, 53
   
RETURN ( NIL )


*******************************************************************************


FUNCTION ExitDemo()
	
   SETCOLOR( "n/w,n/w,n,n,n/w" )
	RESTSCREEN( 0, 0, MAXROW(), MAXCOL(), cEntryScreen )
	SETCURSOR( SC_NORMAL )
	QUIT
	
RETURN ( NIL )


*******************************************************************************


/* EOF: fxdemo.prg */
