		.xlist
		include 	stdlib.a
		includelib	stdlib.lib
		.list

; Global variables go here:

dseg		segment	para public 'data'
Name1		dd	?
Name2		dd	?
Handle1		dw	?
Handle2		dw	?
LineCnt		dw	0
Index1		db	0,0
Index2		db	0,0
Cnt1		db	0
Cnt2		db	0
Buffer1		db	256 dup (0)
Buffer2		db	256 dup (0)
dseg		ends

wp		equ	<word ptr>


cseg		segment	para public 'code'
		assume	cs:cseg, ds:dseg

;
; Variables that wind up being used by the standard library routines.
; The MemInit routine uses "PSP" and "zzzzzzseg" labels.  They must be
; present if you intend to use getenv, MemInit, malloc, and free.
;
;
		public	PSP
PSP		dw	?
;
;
; Error- Prints a DOS error message depending upon the error type.
;
Error		proc	near
		cmp	ax, 2
		jne	NotFNF
		print
		db	"File not found",0
		jmp	ErrorDone

NotFNF:		cmp	ax, 4
		jne	NotTMF
		print
		db	"Too many open files",0
		jmp	ErrorDone

NotTMF:		cmp	ax, 5
		jne	NotAD
		print
		db	"Access denied",0
		jmp	ErrorDone

NotAD:		cmp	ax, 12
		jne	NotIA
		print
		db	"Invalid access",0
		jmp	ErrorDone

NotIA:
ErrorDone:	putcr
		ret
Error		endp




;-----------------------------------------------------------------
; Main is the main program.  Program execution always begins here.
;
Main		proc
		mov	cs:PSP, es		;Save pgm seg prefix
		mov	ax, seg dseg		;Set up the segment registers
		mov	ds, ax
		mov	es, ax
;
		mov	dx, 0
		meminit
		jnc	GoodMemInit

		print
		db	"Error initializing memory manager",cr,lf,0
		jmp	Quit
GoodMemInit:

; File comparison routine.  First, open the two source files.

		argc
		cmp	cx, 2		;Do we have two filenames?
		je	GotTwoNames
		print
		db	"Usage: fcmp file1 file2",cr,lf,0
		jmp	Quit

GotTwoNames:	mov	ax, 1		;Get first file name
		argv
		mov	wp Name1, di
		mov	wp Name1+2, es

; Open the files by calling DOS.

		mov	ax, 3d00h	;Open for reading
		lds	dx, Name1
		int	21h
		jnc	GoodOpen1
		printf
		db	"Error opening %^s:",0
		dd	Name1
		call	Error
		jmp	Quit

GoodOpen1:	mov	dx, dseg
		mov	ds, dx
		mov	Handle1, ax

		mov	ax, 2		;Get first file name
		argv
		mov	wp Name2, di
		mov	wp Name2+2, es

		mov	ax, 3d00h	;Open for reading
		lds	dx, Name2
		int	21h
		jnc	GoodOpen2
		printf
		db	"Error opening %^s:",0
		dd	Name2
		call	Error
		jmp	Quit

GoodOpen2:	mov	dx, dseg
		mov	ds, dx
		mov	Handle2, ax

; Read the data from the files and compare it.

		mov	LineCnt, 1
CmpLoop:	mov	bx, Handle1
		mov	cx, 256
		lea	dx, Buffer1
		mov	ah, 3fh
		int	21h
		jc	FileError
		cmp	ax, 256
		jne	EndOfFile

		mov	bx, Handle2
		mov	cx, 256
		lea	dx, Buffer2
		mov	ah, 3fh
		int	21h
		jc	FileError
		cmp	ax, 256
		jne	BadLen
		mov	ax, dseg
		mov	ds, ax
		mov	es, ax
		mov	cx, 256
		lea	di, Buffer1
		lea	si, Buffer2
		cld
	repe	cmpsb
		jne	BadCmp
		jmp	CmpLoop


FileError:	print
		db	"Error reading files: ",0
		call	Error
		jmp	Quit


BadLen:		print
		db	"File lengths were different",cr,lf,0

BadCmp:		print
		db      7,"Files were not equal",cr,lf,0
		mov	ax, 4c01h
		int	21h


EndOfFile:	push	ax			;Save final length.
		mov	bx, Handle2
		mov	cx, 256
		lea	dx, Buffer2
		mov	ah, 3fh
		int	21h
		jc	BadCmp
		pop	bx
		cmp	ax, bx
		jne	BadLen

		mov	cx, ax
		mov	ax, dseg
		mov	ds, ax
		mov	es, ax
		lea	di, Buffer2
		lea	si, Buffer1
	repe	cmpsb
		jne	BadCmp

Quit:		mov	ax, 4c00h		;Set Exit code to okay.
		int	21h
Main		endp

cseg            ends



; Allocate a reasonable amount of space for the stack (2k).

sseg		segment	para stack 'stack'
stk		db	256 dup ("stack   ")
sseg		ends


; zzzzzzseg must be the last segment that gets loaded into memory!

zzzzzzseg	segment	para public 'zzzzzz'
LastBytes	db	16 dup (?)
zzzzzzseg	ends
		end	Main
